/*
 * Decompiled with CFR 0.152.
 */
package compbio.conservation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Alphabet {
    private static final Set<Character> ALPHABET;
    private static final char[] alpArray;

    Alphabet() {
    }

    static char[] alphabetArray() {
        return alpArray;
    }

    static Set<Character> alphabet() {
        return ALPHABET;
    }

    static Map<Character, Integer> calculateOccurance(char[] column) {
        if (column == null) {
            throw new IllegalArgumentException("Column must not be  null");
        }
        Set<Character> alph = ALPHABET;
        HashMap<Character, Integer> charCount = new HashMap<Character, Integer>();
        for (char ch : column) {
            if (ch == '.' || ch == '*' || ch == ' ' || ch == 'X') {
                ch = '-';
            }
            assert (alph.contains(Character.valueOf(ch))) : "Illegal character in the column";
            Integer count = (Integer)charCount.get(Character.valueOf(ch));
            if (count == null) {
                charCount.put(Character.valueOf(ch), new Integer(1));
                continue;
            }
            charCount.put(Character.valueOf(ch), count + 1);
        }
        assert (!charCount.isEmpty());
        return charCount;
    }

    static String legalCharacterstoString() {
        String legalChars = "";
        Iterator<Character> itr = ALPHABET.iterator();
        while (itr.hasNext()) {
            legalChars = legalChars + itr.next();
        }
        return legalChars;
    }

    static {
        alpArray = new char[]{'A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V'};
        HashSet<Character> alph = new HashSet<Character>();
        alph.add(Character.valueOf('R'));
        alph.add(Character.valueOf('H'));
        alph.add(Character.valueOf('K'));
        alph.add(Character.valueOf('D'));
        alph.add(Character.valueOf('E'));
        alph.add(Character.valueOf('S'));
        alph.add(Character.valueOf('T'));
        alph.add(Character.valueOf('Q'));
        alph.add(Character.valueOf('C'));
        alph.add(Character.valueOf('G'));
        alph.add(Character.valueOf('P'));
        alph.add(Character.valueOf('A'));
        alph.add(Character.valueOf('I'));
        alph.add(Character.valueOf('L'));
        alph.add(Character.valueOf('M'));
        alph.add(Character.valueOf('F'));
        alph.add(Character.valueOf('W'));
        alph.add(Character.valueOf('Y'));
        alph.add(Character.valueOf('V'));
        alph.add(Character.valueOf('N'));
        alph.add(Character.valueOf('-'));
        ALPHABET = Collections.unmodifiableSet(alph);
    }
}

