/*
 * Decompiled with CFR 0.152.
 */
package compbio.conservation;

import compbio.common.NotAnAminoAcidException;
import compbio.common.SequencesNotEquallyLongException;
import compbio.conservation.Alphabet;
import compbio.conservation.ConservationAccessory;
import compbio.conservation.ConservationSets;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.FastaSequence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AminoAcidMatrix {
    private final char[][] matrix;
    private final char[][] inverseMatrix;
    private String[] sequenceNames;
    private List<Map<Character, Integer>> acidsIntMap;
    private char[] gaps;
    private Map<Character, Integer> totalFrequency;
    private Map<String, Integer> willSetsTotal;
    private double[] vingronArgosWeights;
    private double[][] percentIdentity;
    private double[] voronoiWeighths;
    private static final char[] DEFAULT_GAP_CHARS = new char[]{'.', '*', ' ', 'X', '-'};

    AminoAcidMatrix(char[] column) {
        Set<Character> alp = Alphabet.alphabet();
        this.matrix = new char[column.length][1];
        this.inverseMatrix = new char[1][column.length];
        for (int i = 0; i < column.length; ++i) {
            if (!alp.contains(Character.valueOf(column[i]))) {
                throw new NotAnAminoAcidException("Illegal chracter in the column");
            }
            this.matrix[i][0] = column[i];
            this.inverseMatrix[0][i] = column[i];
        }
        this.calTotalAcidsFreqByCol();
    }

    AminoAcidMatrix(char p1, char p2, char p3, char p4, char p5, char p6, char p7, char p8, char p9) {
        Set<Character> alp = Alphabet.alphabet();
        if (!alp.contains(Character.valueOf(p1))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p2))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p3))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p4))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p5))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p6))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p7))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p8))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p9))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        this.matrix = new char[3][3];
        this.matrix[0][0] = p1;
        this.matrix[0][1] = p2;
        this.matrix[0][2] = p3;
        this.matrix[1][0] = p4;
        this.matrix[1][1] = p5;
        this.matrix[1][2] = p6;
        this.matrix[2][0] = p7;
        this.matrix[2][1] = p8;
        this.matrix[2][2] = p9;
        this.inverseMatrix = new char[3][3];
        this.inverseMatrix[0][0] = p1;
        this.inverseMatrix[0][1] = p4;
        this.inverseMatrix[0][2] = p7;
        this.inverseMatrix[1][0] = p2;
        this.inverseMatrix[1][1] = p5;
        this.inverseMatrix[1][2] = p8;
        this.inverseMatrix[2][0] = p3;
        this.inverseMatrix[2][1] = p6;
        this.inverseMatrix[2][2] = p9;
    }

    AminoAcidMatrix(Alignment alignment) {
        this(alignment.getSequences(), new char[]{alignment.getMetadata().getGapchar()});
    }

    AminoAcidMatrix(char p1, char p2, char p3, char p4, char p5, char p6, char p7, char p8, char p9, char p10, char p11, char p12, char p13, char p14, char p15) {
        Set<Character> alp = Alphabet.alphabet();
        if (!alp.contains(Character.valueOf(p1))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p2))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p3))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p4))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p5))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p6))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p7))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p8))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p9))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p10))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p11))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p12))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p13))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p14))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        if (!alp.contains(Character.valueOf(p15))) {
            throw new NotAnAminoAcidException("Illegal chracter in the column");
        }
        this.matrix = new char[3][5];
        this.matrix[0][0] = p1;
        this.matrix[0][1] = p2;
        this.matrix[0][2] = p3;
        this.matrix[0][3] = p4;
        this.matrix[0][4] = p5;
        this.matrix[1][0] = p6;
        this.matrix[1][1] = p7;
        this.matrix[1][2] = p8;
        this.matrix[1][3] = p9;
        this.matrix[1][4] = p10;
        this.matrix[2][0] = p11;
        this.matrix[2][1] = p12;
        this.matrix[2][2] = p13;
        this.matrix[2][3] = p14;
        this.matrix[2][4] = p15;
        this.inverseMatrix = new char[5][3];
        this.inverseMatrix[0][0] = p1;
        this.inverseMatrix[0][1] = p6;
        this.inverseMatrix[0][2] = p11;
        this.inverseMatrix[1][0] = p2;
        this.inverseMatrix[1][1] = p7;
        this.inverseMatrix[1][2] = p12;
        this.inverseMatrix[2][0] = p3;
        this.inverseMatrix[2][1] = p8;
        this.inverseMatrix[2][2] = p13;
        this.inverseMatrix[3][0] = p4;
        this.inverseMatrix[3][1] = p9;
        this.inverseMatrix[3][2] = p14;
        this.inverseMatrix[4][0] = p5;
        this.inverseMatrix[4][1] = p10;
        this.inverseMatrix[4][2] = p15;
        assert (this.inverseMatrix != null && this.inverseMatrix[0] != null);
        for (char[] column : this.inverseMatrix) {
            char[] gapchars = DEFAULT_GAP_CHARS;
            boolean gaponly = true;
            Arrays.sort(gapchars);
            for (char charr : column) {
                if (Arrays.binarySearch(gapchars, charr) >= 0) continue;
                gaponly = false;
                break;
            }
            if (!gaponly) continue;
            String message = "Input has badly aligned sequences with columns containing nothing but the gaps. Conservation methods cannot be calculated for such an alignment ! \nGap characters are : " + Arrays.toString(gapchars);
            System.err.println(message);
            throw new IllegalArgumentException(message);
        }
    }

    AminoAcidMatrix(List<FastaSequence> seqs, char[] gapChars) {
        this.gaps = gapChars != null ? gapChars : DEFAULT_GAP_CHARS;
        Set<Character> alph = Alphabet.alphabet();
        int sequenceNr = seqs.size();
        FastaSequence seq = seqs.get(0);
        String firstSequence = seq.getSequence();
        int sequenceLength = firstSequence.length();
        this.matrix = new char[sequenceNr][sequenceLength];
        this.inverseMatrix = new char[sequenceLength][sequenceNr];
        this.sequenceNames = new String[sequenceNr];
        for (int i = 0; i < sequenceNr; ++i) {
            FastaSequence s = seqs.get(i);
            char[] sequenceChars = s.getSequence().toCharArray();
            this.sequenceNames[i] = s.getId();
            if (sequenceChars.length != sequenceLength) {
                int seqNr = i + 1;
                String message = "Sequence number " + seqNr + "(id: " + this.sequenceNames[i] + ")" + " is of differen length than previous sequences.";
                throw new SequencesNotEquallyLongException(message);
            }
            for (int j = 0; j < sequenceLength; ++j) {
                char ch = sequenceChars[j];
                for (int d = 0; d < this.gaps.length; ++d) {
                    if (ch != this.gaps[d]) continue;
                    ch = '-';
                }
                if (!alph.contains(Character.valueOf(ch))) {
                    String legals = Alphabet.legalCharacterstoString();
                    int seqNr = i + 1;
                    String message = "Illegal character in sequence number " + seqNr + "(sequence ID: " + this.sequenceNames[i] + "). Illegal character: " + ch + " is at position: " + j + ". " + "List of legal characters: " + legals + ". ";
                    throw new NotAnAminoAcidException(message);
                }
                this.matrix[i][j] = ch;
                this.inverseMatrix[j][i] = ch;
            }
        }
        this.calTotalAcidsFreqByCol();
        this.gapOnlyColumnsCheck();
    }

    private void gapOnlyColumnsCheck() {
        assert (this.inverseMatrix != null && this.inverseMatrix[0] != null);
        for (char[] column : this.inverseMatrix) {
            AminoAcidMatrix.gapOnlyColumnCheck(column, this.gaps);
        }
    }

    static void gapOnlyColumnCheck(char[] column, char[] gapchars) {
        boolean gaponly = true;
        Arrays.sort(gapchars);
        for (char charr : column) {
            if (Arrays.binarySearch(gapchars, charr) >= 0) continue;
            gaponly = false;
            break;
        }
        if (gaponly) {
            String message = "Input has badly aligned sequences with columns containing nothing but the gaps. Conservation methods cannot be calculated for such an alignment ! \nGap characters are : " + Arrays.toString(gapchars);
            System.err.println(message);
            throw new IllegalArgumentException(message);
        }
    }

    int numberOfColumns() {
        return this.matrix[0].length;
    }

    int numberOfRows() {
        return this.matrix.length;
    }

    char[][] getMatrix() {
        return this.matrix;
    }

    char[][] getInverseMatrix() {
        return this.inverseMatrix;
    }

    char getMatrixPosition(int row, int column) {
        char position = this.matrix[row][column];
        return position;
    }

    char[] getColumn(int number) {
        return this.inverseMatrix[number];
    }

    char[] getRow(int number) {
        assert (number < this.numberOfRows());
        return this.matrix[number];
    }

    private void calTotalAcidsFreqByCol() {
        this.acidsIntMap = new ArrayList<Map<Character, Integer>>(this.numberOfColumns());
        for (int i = 0; i < this.numberOfColumns(); ++i) {
            this.acidsIntMap.add(Alphabet.calculateOccurance(this.inverseMatrix[i]));
        }
    }

    synchronized List<Map<Character, Integer>> getTotalAcidsFreqByCol() {
        if (this.acidsIntMap == null) {
            this.calTotalAcidsFreqByCol();
        }
        return this.acidsIntMap;
    }

    synchronized Map<Character, Integer> totalAcidsFrequency() {
        if (this.totalFrequency == null) {
            this.calTotalAcidsFrequency();
        }
        return this.totalFrequency;
    }

    synchronized Map<String, Integer> totalAcidsWillSets() {
        if (this.willSetsTotal == null) {
            this.calTotalAcidsWillSets();
        }
        return this.willSetsTotal;
    }

    private void calTotalAcidsFrequency() {
        HashMap<Character, Integer> totalFreq = new HashMap<Character, Integer>();
        Set<Character> alph = Alphabet.alphabet();
        for (int i = 0; i < this.numberOfRows(); ++i) {
            for (int j = 0; j < this.numberOfColumns(); ++j) {
                Character ch = Character.valueOf(this.matrix[i][j]);
                if (ch.charValue() == '.' || ch.charValue() == '*' || ch.charValue() == ' ' || ch.charValue() == 'X') {
                    ch = Character.valueOf('-');
                }
                assert (alph.contains(ch)) : "Illegal character in the matrix";
                Integer count = (Integer)totalFreq.get(ch);
                if (count == null) {
                    totalFreq.put(ch, 1);
                    continue;
                }
                totalFreq.put(ch, count + 1);
            }
        }
        this.totalFrequency = totalFreq;
    }

    private void calTotalAcidsWillSets() {
        Map<String, HashSet<Character>> sets = ConservationSets.williamsonSets();
        HashMap<String, Integer> setsFreq = new HashMap<String, Integer>();
        Set<String> setsKeys = sets.keySet();
        Iterator<String> setsKeysItr = setsKeys.iterator();
        this.totalAcidsFrequency();
        Map<Character, Integer> totalFreq = this.totalFrequency;
        Set<Character> totalFreqKeys = totalFreq.keySet();
        while (setsKeysItr.hasNext()) {
            String setsKey = setsKeysItr.next();
            for (Character totalFreqKey : totalFreqKeys) {
                if (!sets.get(setsKey).contains(totalFreqKey)) continue;
                Integer count = (Integer)setsFreq.get(setsKey);
                if (count == null) {
                    setsFreq.put(setsKey, totalFreq.get(totalFreqKey));
                    continue;
                }
                setsFreq.put(setsKey, count + totalFreq.get(totalFreqKey));
            }
        }
        this.willSetsTotal = setsFreq;
    }

    private double weightOfSequenceVingronArgos(int seqNr) {
        double weight = 0.0;
        for (int i = 0; i < this.numberOfRows(); ++i) {
            if (i == seqNr) continue;
            weight += ConservationAccessory.percentIdentity(this.getRow(seqNr), this.getRow(i));
        }
        double result = 1.0 / (double)this.numberOfRows() * weight;
        return result;
    }

    private void weightOfSequencesVingronArgos() {
        this.vingronArgosWeights = new double[this.numberOfRows()];
        for (int i = 0; i < this.numberOfRows(); ++i) {
            this.vingronArgosWeights[i] = this.weightOfSequenceVingronArgos(i);
        }
    }

    synchronized double[] vingronArgosWeights() {
        if (this.vingronArgosWeights == null) {
            this.weightOfSequencesVingronArgos();
        }
        return this.vingronArgosWeights;
    }

    private void calPercentIdentity() {
        this.percentIdentity = new double[this.numberOfRows()][this.numberOfRows()];
        int ident = 0;
        for (int i = 0; i < this.numberOfRows(); ++i) {
            for (int j = i + 1; j < this.numberOfRows(); ++j) {
                double result;
                for (int a = 0; a < this.numberOfColumns(); ++a) {
                    if (this.getRow(i) != this.getRow(j)) continue;
                    ++ident;
                }
                this.percentIdentity[i][j] = result = (double)ident / (double)this.numberOfColumns();
            }
        }
    }

    synchronized double[][] getPercentIdentity() {
        if (this.percentIdentity == null) {
            this.calPercentIdentity();
        }
        return this.percentIdentity;
    }

    void voronoiWeights(int iterNr) {
        int iterations = iterNr;
        Random rgen = new Random();
        double[] weights = new double[this.numberOfRows()];
        char[] randSeq = new char[this.numberOfColumns()];
        for (int i = 0; i < iterations; ++i) {
            for (int j = 0; j < this.numberOfColumns(); ++j) {
                int random = rgen.nextInt(this.numberOfRows());
                randSeq[j] = this.getMatrixPosition(random, j);
            }
            double[] distances = new double[this.numberOfRows()];
            double closestValue = 1000.0;
            for (int a = 0; a < this.numberOfRows(); ++a) {
                distances[a] = 1.0 - ConservationAccessory.percentIdentity(this.getRow(a), randSeq);
                if (!(distances[a] < closestValue)) continue;
                closestValue = distances[a];
            }
            ArrayList<Integer> closestSeqs = new ArrayList<Integer>();
            for (int b = 0; b < distances.length; ++b) {
                double dis = distances[b];
                if (dis != closestValue) continue;
                closestSeqs.add(b);
            }
            double increase = 1.0 / (double)closestSeqs.size();
            for (int c = 0; c < closestSeqs.size(); ++c) {
                int cs;
                int n = cs = ((Integer)closestSeqs.get(c)).intValue();
                weights[n] = weights[n] + increase;
            }
        }
        double weightSum = 0.0;
        for (int d = 0; d < weights.length; ++d) {
            weightSum += weights[d];
        }
        double scaleFactor = weightSum / (double)this.numberOfRows();
        for (int e = 0; e < weights.length; ++e) {
            weights[e] = weights[e] + scaleFactor;
        }
        this.voronoiWeighths = weights;
    }

    synchronized double[] getVoronoiWeights(int iterNr) {
        if (this.voronoiWeighths == null) {
            this.voronoiWeights(iterNr);
        }
        return this.voronoiWeighths;
    }

    List<FastaSequence> getAlignment() throws IOException {
        ArrayList<FastaSequence> fastaseqs = new ArrayList<FastaSequence>();
        for (int i = 0; i < this.numberOfRows(); ++i) {
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < this.getRow(i).length; ++j) {
                sb.append(this.getRow(i)[j]);
            }
            fastaseqs.add(new FastaSequence(this.sequenceNames[i], sb.toString()));
        }
        return fastaseqs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.acidsIntMap == null ? 0 : ((Object)this.acidsIntMap).hashCode());
        result = 31 * result + Arrays.hashCode((Object[])this.matrix);
        result = 31 * result + Arrays.hashCode(this.sequenceNames);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AminoAcidMatrix other = (AminoAcidMatrix)obj;
        if (this.acidsIntMap == null ? other.acidsIntMap != null : !((Object)this.acidsIntMap).equals(other.acidsIntMap)) {
            return false;
        }
        if (!Arrays.equals((Object[])this.matrix, (Object[])other.matrix)) {
            return false;
        }
        return Arrays.equals(this.sequenceNames, other.sequenceNames);
    }
}

