/*
 * Decompiled with CFR 0.152.
 */
package compbio.conservation;

import compbio.common.IllegalGapCharacterException;
import compbio.data.sequence.ConservationMethod;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CmdParser {
    static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    static final String pseparator = "=";
    static final String methodKey = "-m";
    static final String normalizationKey = "-n";
    static final String threadNumberKey = "-t";
    static final String formatKey = "-f";
    static final String inputKey = "-i";
    static final String outputKey = "-o";
    static final String SMERFSWindowWidth = "-smerfsww";
    static final String SMERFSGapTreshold = "-smerfsgt";
    static final String SMERFSColumnScore = "-smerfscs";
    static final String gapKey = "-g";
    static final String statKey = "-d";
    static final String CONSERVATION_HELP = "\r\nAA Conservation version 1.1 (19 April 2017)\r\n\r\nThis program allows calculation of conservation of amino acids in\r\nmultiple sequence alignments.\r\nIt implements 17 different conservation scores as described by Valdar in\r\nhis paper (Scoring Residue Conservation, PROTEINS: Structure, Function\r\nand  Bioinformatics 48:227-241 (2002)) and SMERFS scoring algorithm as described\r\nby Manning, Jefferson and Barton (The contrasting properties of conservation\r\nand correlated phylogeny in protein functional residue prediction,\r\nBMC Bioinformatics (2008)).\r\n\r\nThe conservation algorithms supported are:\r\n\r\nKABAT, JORES, SCHNEIDER, SHENKIN, GERSTEIN, TAYLOR_GAPS, TAYLOR_NO_GAPS, \r\nZVELIBIL, KARLIN, ARMON, THOMPSON, NOT_LANCET, MIRNY, WILLIAMSON, \r\nLANDGRAF, SANDER, VALDAR, SMERFS\r\n\r\nInput format is either a FASTA formatted file containing aligned sequences with \r\ngaps or a Clustal alignment. The valid gap characters are *, -, space character,\r\nX and . (a dot). By default program prints the results to the command window. \r\nIf the output file is provided the results are printed to the file in two \r\npossible formats with or without an alignment.\r\nIf format is not specified, the program outputs conservation scores without \r\nalignment. The scores are not normalized by default but they can be (see below).\r\nSMERFS default parameters are window width of 7, column score is set to\r\nthe middle column (MID_SCORE), gap% cutoff of 0.1. Different parameters for SMERFS \r\ncan be provided (see below). Details of the program execution can be recorded to\r\na separate file if an appropriate file path is provided.\r\n\r\nList of command line arguments:\r\n\r\n-m=  precedes a comma separated list of method names\r\n     EXAMPLE: -m=KABAT,JORES,GERSTEIN\r\n     Optional, if no method is specified request for all is assumed. \r\n\r\n-i=  precedes a full path to the input FASTA file, required\r\n\r\n-o=  precedes a full path to the output file, optional, if no output file is \r\n     provided the program will output to the standard out.  \r\n\r\n-t=  precedes the number of CPUs (CPU cores more precisely) to use. Optional, \r\n\t defaults to all processors available on the machine.  \r\n      \r\n-f=  precedes the format  of the results in the output file\r\n     two different formats are possible:\r\n      RESULT_WITH_ALIGNMENT\r\n      RESULT_NO_ALIGNMENT\r\n     Optional, if not specified RESULT_NO_ALIGNMENT is assumed \r\n\r\n-d=  precedes a full path to a file where program execution details are to be \r\n     listed. Optional, if not provided, no execution statistics is produced.  \r\n      \r\n-g=  precedes comma separated list of gap characters provided by the user, if \r\n     you're using an unusual gap character (not a -,., ,*,X) you have to \r\n     provide it. If you you provide this list you have to list all the gaps \r\n     accepted. Including those that were previously treated as a default. \r\n     Optional.      \r\n      \r\n-n   using this key causes the results to be normalized. \r\n\t Normalized results have values between 0 and 1. Please note however, that \r\n\t some results cannot be normalized. In such a case, the system returns not \r\n\t normalized value, and log the issue to the standard error stream. \r\n\t The following formula is used for normalization \r\n\t\t\tn = (d - dmin)/(dmax - dmin)\r\n\t Negative results first converted to positive by adding an absolute value of\r\n\t the most negative result. Optional.\r\n\r\nSMERFS Only Parameters: \r\n\r\n-smerfsGT=  precedes SMERFS Gap Treshold - a gap percentage cutoff - \r\n\t\t\ta float greater than 0 and smaller or equal 1. Optional defaults \r\n\t\t\tto 0.1\r\n\r\n-smerfsCS=  precedes SMERFS Column Score algorithm defines the window scores to \r\n\t\t\tcolumns\tallocation , two methods are possible:\r\n\t        MID_SCORE - gives the window score to the middle column\r\n\t        MAX_SCORE - gives the column the highest score of all the windows it \r\n\t        belongs to. Optional defaults to MID_SCORE.  \r\n\r\n-smerfsWW=  precedes Window Width parameter - an integer and an odd number.\r\n            Optional, defaults to 7 \r\n\t  \r\n\r\nEXAMPLE HOW TO RUN THE PROGRAM:\r\njava -jar <jar name> -m=KABAT,SMERFS -i=prot1 -o=prot1_results -n\r\n\r\nAs a result of the execution KABAT and SMERFS scores will be calculated. \r\nInput comes form prot1 file and an output without an alignment is recorded to \r\nprot1_results file. \r\n\r\nAuthors: Peter Troshin, Agnieszka Golicz, David Martin, F\u00e1bio Madeira and Geoff J. Barton.\r\nPlease visit http://www.compbio.dundee.ac.uk/aacon for further information.\r\n ";

    private CmdParser() {
    }

    static String getSMERFSColumnScore(String[] cmd) {
        for (int i = 0; i < cmd.length; ++i) {
            String meths = cmd[i];
            if (!meths.trim().toLowerCase().startsWith("-smerfscs=")) continue;
            return meths.substring(meths.indexOf(pseparator) + 1).trim();
        }
        return null;
    }

    static String getSMERFSWindowWidth(String[] cmd) {
        for (int i = 0; i < cmd.length; ++i) {
            String meths = cmd[i];
            if (!meths.trim().toLowerCase().startsWith("-smerfsww=")) continue;
            return meths.substring(meths.indexOf(pseparator) + 1).trim();
        }
        return null;
    }

    static String getSMERFSGapTreshold(String[] cmd) {
        for (int i = 0; i < cmd.length; ++i) {
            String meths = cmd[i];
            if (!meths.trim().toLowerCase().startsWith("-smerfsgt=")) continue;
            return meths.substring(meths.indexOf(pseparator) + 1).trim();
        }
        return null;
    }

    static boolean getNormalize(String[] cmd) {
        for (int i = 0; i < cmd.length; ++i) {
            String norm = cmd[i];
            if (!norm.trim().toLowerCase().equals(normalizationKey)) continue;
            return true;
        }
        return false;
    }

    static int getThreadNumber(String[] cmd) {
        int threadNum = 0;
        for (int i = 0; i < cmd.length; ++i) {
            String num;
            String tnum = cmd[i].trim().toLowerCase();
            if (!tnum.startsWith("-t=") || (num = tnum.substring(tnum.indexOf(pseparator) + 1)) == null) continue;
            threadNum = Integer.parseInt(num);
        }
        return threadNum;
    }

    static String getFormat(String[] cmd) {
        for (int i = 0; i < cmd.length; ++i) {
            String form = cmd[i];
            if (!form.trim().toLowerCase().startsWith("-f=")) continue;
            return form.substring(form.indexOf(pseparator) + 1);
        }
        return null;
    }

    static String getOutputFilePath(String[] cmd) {
        for (int i = 0; i < cmd.length; ++i) {
            String name = cmd[i];
            if (!name.trim().toLowerCase().startsWith("-o=")) continue;
            return name.substring(name.indexOf(pseparator) + 1);
        }
        return null;
    }

    static String getInputFilePath(String[] cmd) {
        for (int i = 0; i < cmd.length; ++i) {
            String name = cmd[i];
            if (!name.trim().toLowerCase().startsWith("-i=")) continue;
            return name.substring(name.indexOf(pseparator) + 1);
        }
        return null;
    }

    static String getStatFilePath(String[] cmd) {
        for (int i = 0; i < cmd.length; ++i) {
            String name = cmd[i];
            if (!name.trim().toLowerCase().startsWith("-d=")) continue;
            return name.substring(name.indexOf(pseparator) + 1);
        }
        return null;
    }

    static String[] getGapChars(String[] cmd) {
        for (int i = 0; i < cmd.length; ++i) {
            String form = cmd[i];
            if (!form.trim().toLowerCase().startsWith("-g=")) continue;
            return form.substring(form.indexOf(pseparator) + 1).split(",");
        }
        return null;
    }

    static Set<ConservationMethod> getMethodNames(String[] cmd) {
        EnumSet<ConservationMethod> methods = EnumSet.noneOf(ConservationMethod.class);
        for (int i = 0; i < cmd.length; ++i) {
            String[] mets;
            String meths = cmd[i];
            if (!meths.trim().toLowerCase().startsWith("-m=")) continue;
            for (String method : mets = meths.substring(meths.indexOf(pseparator) + 1).split(",")) {
                methods.add(ConservationMethod.getMethod(method));
            }
        }
        return methods;
    }

    static char[] extractGapChars(String[] gap) {
        char[] gapChars = null;
        if (gap != null) {
            gapChars = new char[gap.length];
            for (int i = 0; i < gap.length; ++i) {
                if (gap[i].length() != 1) {
                    throw new IllegalGapCharacterException("Argument provided as gap charcetr is more than one character long.");
                }
                gapChars[i] = gap[i].charAt(0);
            }
        }
        return gapChars;
    }

    static String getDateTime() {
        return DATE_FORMAT.format(new Date());
    }
}

