/*
 * Decompiled with CFR 0.152.
 */
package compbio.conservation;

import compbio.conservation.Alphabet;
import compbio.conservation.AminoAcidMatrix;
import compbio.conservation.ConservationAccessory;
import compbio.conservation.ConservationMatrices;
import compbio.conservation.ConservationSets;
import compbio.conservation.ShannonEnthropy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

final class ColumnScores {
    ColumnScores() {
    }

    private static boolean allButOneGaps(int columnNr, AminoAcidMatrix matrix) {
        assert (columnNr < matrix.numberOfColumns()) : "Column number greater than number of columns in the matrix.";
        Map<Character, Integer> acidsInt = matrix.getTotalAcidsFreqByCol().get(columnNr);
        return acidsInt.containsKey(Character.valueOf('-')) && acidsInt.get(Character.valueOf('-')) == matrix.getInverseMatrix()[columnNr].length - 1;
    }

    private static boolean oneResidueTypeNoGaps(int columnNr, AminoAcidMatrix matrix) {
        assert (columnNr < matrix.numberOfColumns()) : "Column number greater than number of columns in the matrix.";
        Map<Character, Integer> acidsInt = matrix.getTotalAcidsFreqByCol().get(columnNr);
        return acidsInt.size() == 1 && !acidsInt.containsKey(Character.valueOf('-'));
    }

    private static boolean containsGaps(int columnNr, AminoAcidMatrix matrix) {
        assert (columnNr < matrix.numberOfColumns()) : "Column number greater than number of columns in the matrix.";
        return matrix.getTotalAcidsFreqByCol().get(columnNr).containsKey(Character.valueOf('-'));
    }

    private static int numberOfAcidsWithGap(int columnNr, AminoAcidMatrix matrix) {
        assert (columnNr < matrix.numberOfColumns()) : "Column number greater than number of columns in the matrix.";
        return matrix.getTotalAcidsFreqByCol().get(columnNr).size();
    }

    private static int numberOfAcidsNoGap(int columnNr, AminoAcidMatrix matrix) {
        assert (columnNr < matrix.numberOfColumns()) : "Column number greater than number of columns in the matrix.";
        if (ColumnScores.containsGaps(columnNr, matrix)) {
            return matrix.getTotalAcidsFreqByCol().get(columnNr).size() - 1;
        }
        return matrix.getTotalAcidsFreqByCol().get(columnNr).size();
    }

    private static int mostCommonNumber(int columnNr, AminoAcidMatrix matrix) {
        assert (columnNr < matrix.numberOfColumns()) : "Column number greater than number of columns in teh matrix.";
        int max = 0;
        Map<Character, Integer> acidsInt = matrix.getTotalAcidsFreqByCol().get(columnNr);
        Set<Character> keys = acidsInt.keySet();
        for (Character key : keys) {
            int value = acidsInt.get(key);
            if (key.charValue() == '-' || value <= max) continue;
            max = value;
        }
        assert (max != 0) : "Zero in the most Common Number";
        return max;
    }

    static double kabatScore(AminoAcidMatrix matrix, int columnNumber) {
        assert (columnNumber < matrix.numberOfColumns()) : "Column number greater than number of columns in teh matrix.";
        assert (ColumnScores.mostCommonNumber(columnNumber, matrix) > 0 && ColumnScores.mostCommonNumber(columnNumber, matrix) < matrix.getInverseMatrix()[columnNumber].length + 1);
        double result = (double)matrix.getInverseMatrix()[columnNumber].length * (double)ColumnScores.numberOfAcidsNoGap(columnNumber, matrix) / (double)ColumnScores.mostCommonNumber(columnNumber, matrix);
        return ConservationAccessory.round(result, 4);
    }

    static double joresScore(AminoAcidMatrix matrix, int colNr) {
        int diff;
        int same;
        assert (colNr < matrix.numberOfColumns()) : "Column number greater than number of columns in teh matrix.";
        double result = 0.0;
        boolean oneRes = ColumnScores.oneResidueTypeNoGaps(colNr, matrix);
        boolean allButOne = ColumnScores.allButOneGaps(colNr, matrix);
        if (oneRes || allButOne) {
            if (oneRes) {
                result = 1.0;
                return ConservationAccessory.round(result, 4);
            }
            int length = matrix.getInverseMatrix().length;
            result = length * (length - 1) / 2;
            return ConservationAccessory.round(result, 4);
        }
        int samePairs = 0;
        int differentPairs = 0;
        Map<Character, Integer> acidsIntMap = matrix.getTotalAcidsFreqByCol().get(colNr);
        HashMap<Character, Integer> acidsIntMapCopy = new HashMap<Character, Integer>(acidsIntMap);
        Set keys = acidsIntMapCopy.keySet();
        keys.remove(Character.valueOf('-'));
        int types = keys.size();
        differentPairs = types * (types - 1) / 2;
        Iterator itr = acidsIntMapCopy.values().iterator();
        while (itr.hasNext()) {
            if ((Integer)itr.next() <= 1) continue;
            ++samePairs;
        }
        int totalPairs = samePairs + differentPairs;
        Iterator itr2 = acidsIntMapCopy.keySet().iterator();
        int max1 = 0;
        Character maxKey = null;
        while (itr2.hasNext()) {
            Character key = (Character)itr2.next();
            int value = (Integer)acidsIntMapCopy.get(key);
            if (value <= max1) continue;
            maxKey = key;
            max1 = value;
        }
        acidsIntMapCopy.remove(maxKey);
        Iterator itr3 = acidsIntMapCopy.values().iterator();
        int max2 = 0;
        while (itr3.hasNext()) {
            int value = (Integer)itr3.next();
            if (value <= max2) continue;
            max2 = value;
        }
        int mostFreqNr = 0;
        mostFreqNr = max2 == 0 ? max1 * (max1 - 1) / 2 : (max1 == max2 ? max1 * max2 : ((same = max1 * (max1 - 1) / 2) > (diff = max1 * max2) ? same : diff));
        int length = matrix.getInverseMatrix()[colNr].length;
        result = (double)totalPairs / (double)mostFreqNr * (double)(length * (length - 1) / 2);
        return ConservationAccessory.round(result, 4);
    }

    static double schneiderScore(AminoAcidMatrix matrix, int colNr) {
        assert (colNr < matrix.numberOfColumns()) : "Column number greater than number of columns in teh matrix.";
        double result = 0.0;
        double normal = 1.0 / Math.log(20.0);
        result = ShannonEnthropy.ShannonLn(matrix.getTotalAcidsFreqByCol().get(colNr), matrix.getInverseMatrix()[colNr].length) * normal;
        assert (result >= 0.0 && result <= 1.0);
        return ConservationAccessory.round(result, 4);
    }

    static double shenkinScore(AminoAcidMatrix matrix, int colNr) {
        assert (colNr < matrix.numberOfColumns()) : "Column number greater than number of columns in teh matrix.";
        double result = 0.0;
        result = Math.pow(2.0, ShannonEnthropy.ShannonLog2(matrix.getTotalAcidsFreqByCol().get(colNr), matrix.getInverseMatrix()[colNr].length)) * 6.0;
        assert (result >= 6.0 && result <= 120.0);
        return ConservationAccessory.round(result, 4);
    }

    static double gersteinScore(AminoAcidMatrix matrix, int colNr) {
        assert (colNr < matrix.numberOfColumns()) : "Column number greater than number of columns in teh matrix.";
        double result = 0.0;
        result = -ShannonEnthropy.ShannonLn(matrix.totalAcidsFrequency(), matrix.numberOfColumns() * matrix.numberOfRows()) - -ShannonEnthropy.ShannonLn(matrix.getTotalAcidsFreqByCol().get(colNr), matrix.getInverseMatrix()[colNr].length);
        return ConservationAccessory.round(result, 4);
    }

    static double taylorScoreGaps(AminoAcidMatrix matrix, int colNr) {
        assert (colNr < matrix.numberOfColumns()) : "Column number greater than number of columns in teh matrix.";
        Map<String, HashSet<Character>> setMap = ConservationSets.taylorSets();
        double smallestSetSize = 0.0;
        HashMap<String, Integer> repSets = new HashMap<String, Integer>();
        Set<String> setMapKeys = setMap.keySet();
        for (String key : setMapKeys) {
            if (!setMap.get(key).containsAll(matrix.getTotalAcidsFreqByCol().get(colNr).keySet())) continue;
            repSets.put(key, new Integer(setMap.get(key).size()));
        }
        smallestSetSize = ((Integer)Collections.min(repSets.values())).intValue();
        assert (smallestSetSize > 0.0 && smallestSetSize < 25.0);
        return ConservationAccessory.round(smallestSetSize, 4);
    }

    static double taylorScoreNoGaps(AminoAcidMatrix matrix, int colNr) {
        assert (colNr < matrix.numberOfColumns()) : "Column number greater than number of columns in teh matrix.";
        Map<String, HashSet<Character>> setMap = ConservationSets.taylorSets();
        Set<String> setMapKeys = setMap.keySet();
        double smallestSetSize = 0.0;
        HashMap<Character, Integer> acidsMapNoGaps = new HashMap<Character, Integer>(matrix.getTotalAcidsFreqByCol().get(colNr));
        if (acidsMapNoGaps.containsKey(Character.valueOf('-'))) {
            acidsMapNoGaps.remove(Character.valueOf('-'));
        }
        HashMap<String, Integer> repSets = new HashMap<String, Integer>();
        for (String key : setMapKeys) {
            if (!setMap.get(key).containsAll(acidsMapNoGaps.keySet())) continue;
            repSets.put(key, new Integer(setMap.get(key).size()));
        }
        smallestSetSize = ((Integer)Collections.min(repSets.values())).intValue();
        assert (smallestSetSize > 0.0 && smallestSetSize < 25.0);
        return ConservationAccessory.round(smallestSetSize, 4);
    }

    static double zvelibilScore(AminoAcidMatrix matrix, int colNr) {
        assert (colNr < matrix.numberOfColumns()) : "Column number greater than number of columns in teh matrix.";
        double result = 0.0;
        double finalResult = 0.0;
        Map<String, HashSet<Character>> setMap = ConservationSets.zvelibilSets();
        Set<String> keys = setMap.keySet();
        Iterator<String> itr = keys.iterator();
        while (itr.hasNext()) {
            if (!setMap.get(itr.next()).containsAll(matrix.getTotalAcidsFreqByCol().get(colNr).keySet())) continue;
            result += 1.0;
        }
        assert (result >= 0.0 && result < 11.0);
        finalResult = result * 0.1;
        return ConservationAccessory.round(finalResult, 4);
    }

    static double karlinScore(AminoAcidMatrix matrix, int colNr) {
        assert (colNr < matrix.numberOfColumns()) : "Column number greater than number of columns in teh matrix.";
        double blosumSum = 0.0;
        char[] curColumn = matrix.getInverseMatrix()[colNr];
        for (int a = 0; a < curColumn.length; ++a) {
            if (curColumn[a] == '-') continue;
            int idxA = ConservationMatrices.getIndex(curColumn[a]);
            int pairAIndex = 24 * idxA + idxA;
            double aSelf = ConservationMatrices.blosum[pairAIndex];
            assert (aSelf > 0.0);
            for (int b = a + 1; b < curColumn.length; ++b) {
                if (curColumn[b] == '-') continue;
                int idxB = ConservationMatrices.getIndex(curColumn[b]);
                int pairABIndex = 24 * idxA + idxB;
                double pairScore = ConservationMatrices.blosum[pairABIndex];
                int pairBIndex = 24 * idxB + idxB;
                double bSelf = ConservationMatrices.blosum[pairBIndex];
                assert (bSelf > 0.0);
                blosumSum += pairScore / Math.sqrt(aSelf * bSelf);
            }
        }
        double finalSum = blosumSum * (2.0 / (double)(matrix.getInverseMatrix()[colNr].length * (matrix.getInverseMatrix()[colNr].length - 1)));
        assert (finalSum >= -1.0 && finalSum <= 1.0);
        return ConservationAccessory.round(finalSum, 4);
    }

    static double armonScore(AminoAcidMatrix matrix, int colNr) {
        assert (colNr < matrix.numberOfColumns()) : "Column number greater than number of columns in teh matrix.";
        double scoreSum = 0.0;
        int arrayLength = matrix.getTotalAcidsFreqByCol().get(colNr).keySet().size();
        Character[] acidsPresent = new Character[arrayLength];
        int arrayIndex = 0;
        Set<Character> keys = matrix.getTotalAcidsFreqByCol().get(colNr).keySet();
        Iterator<Character> itr = keys.iterator();
        while (itr.hasNext()) {
            acidsPresent[arrayIndex] = itr.next();
            ++arrayIndex;
        }
        for (int a = 0; a < acidsPresent.length; ++a) {
            char charA = acidsPresent[a].charValue();
            int idxA = ConservationMatrices.getIndex(charA);
            for (int b = a + 1; b < acidsPresent.length; ++b) {
                char charB = acidsPresent[b].charValue();
                int idxB = ConservationMatrices.getIndex(charB);
                int pairABIndex = 24 * idxA + idxB;
                scoreSum += ConservationMatrices.miyataArmon[pairABIndex];
            }
        }
        return ConservationAccessory.round(scoreSum, 4);
    }

    static double thompsonScore(AminoAcidMatrix matrix, int colNr) {
        assert (colNr < matrix.numberOfColumns()) : "Column number greater than number of columns in teh matrix.";
        double[] sum = null;
        double[] meanPoint = null;
        double distance = 0.0;
        double nonGapsFraction = 0.0;
        char[] alp = Alphabet.alphabetArray();
        assert (alp != null && alp.length != 0);
        double result = 0.0;
        double[][] points = new double[matrix.getInverseMatrix()[colNr].length][alp.length];
        char[] curColumn = matrix.getInverseMatrix()[colNr];
        for (int a = 0; a < curColumn.length; ++a) {
            int idxA = ConservationMatrices.getIndex(curColumn[a]);
            for (int b = 0; b < alp.length; ++b) {
                int idxB = ConservationMatrices.getIndex(alp[b]);
                int pairABIndex = 24 * idxA + idxB;
                points[a][b] = ConservationMatrices.blosum[pairABIndex];
            }
            sum = sum == null ? points[a] : ConservationAccessory.addPoints(sum, points[a]);
        }
        assert (sum != null);
        meanPoint = ConservationAccessory.multPointByScalar(sum, 1.0 / (double)curColumn.length);
        for (int c = 0; c < curColumn.length; ++c) {
            distance += ConservationAccessory.pointDistance(points[c], meanPoint);
        }
        nonGapsFraction = matrix.getTotalAcidsFreqByCol().get(colNr).keySet().contains(Character.valueOf('-')) ? (double)(curColumn.length - matrix.getTotalAcidsFreqByCol().get(colNr).get(Character.valueOf('-'))) / (double)curColumn.length : 1.0;
        result = nonGapsFraction * 1.0 / (double)matrix.getInverseMatrix()[colNr].length * distance;
        return ConservationAccessory.round(result, 4);
    }

    static double notLancetScore(AminoAcidMatrix matrix, int colNr) {
        assert (colNr < matrix.numberOfColumns()) : "Column number greater than number of columns in teh matrix.";
        double result = 0.0;
        char[] curColumn = matrix.getInverseMatrix()[colNr];
        Map<Character, Integer> acidsInt = matrix.getTotalAcidsFreqByCol().get(colNr);
        Set<Character> keys = acidsInt.keySet();
        for (char key1 : keys) {
            int idx1 = ConservationMatrices.getIndex(key1);
            for (char key2 : keys) {
                int idx2 = ConservationMatrices.getIndex(key2);
                int pair12Index = 24 * idx1 + idx2;
                double blosum = ConservationMatrices.blosum[pair12Index];
                result += (double)acidsInt.get(Character.valueOf(key1)).intValue() / (double)curColumn.length * (double)acidsInt.get(Character.valueOf(key2)).intValue() / (double)curColumn.length * blosum;
            }
        }
        return ConservationAccessory.round(result, 4);
    }

    static double mirnyScore(AminoAcidMatrix matrix, int colNr) {
        assert (colNr < matrix.numberOfColumns()) : "Column number greater than number of columns in teh matrix.";
        double mirnySum = 0.0;
        Map<String, HashSet<Character>> mirnySets = ConservationSets.mirnySets();
        assert (mirnySets != null && !mirnySets.isEmpty());
        Set<String> mirnyKeys = mirnySets.keySet();
        assert (!mirnyKeys.isEmpty());
        Iterator<String> mirnyKeysItr = mirnyKeys.iterator();
        Set<Character> acInKeys = matrix.getTotalAcidsFreqByCol().get(colNr).keySet();
        assert (!acInKeys.isEmpty());
        HashMap<String, Integer> setsFreq = new HashMap<String, Integer>();
        while (mirnyKeysItr.hasNext()) {
            String mirnyKey = mirnyKeysItr.next();
            for (Character acInKey : acInKeys) {
                if (!mirnySets.get(mirnyKey).contains(acInKey)) continue;
                Integer count = (Integer)setsFreq.get(mirnyKey);
                if (count == null) {
                    setsFreq.put(mirnyKey, matrix.getTotalAcidsFreqByCol().get(colNr).get(acInKey));
                    continue;
                }
                setsFreq.put(mirnyKey, count + matrix.getTotalAcidsFreqByCol().get(colNr).get(acInKey));
            }
        }
        assert (!setsFreq.isEmpty());
        for (String setFreqKey : setsFreq.keySet()) {
            double pI = (double)((Integer)setsFreq.get(setFreqKey)).intValue() / (double)matrix.getInverseMatrix()[colNr].length;
            mirnySum += pI * Math.log(pI);
        }
        return ConservationAccessory.round(mirnySum, 4);
    }

    static double williamsonScore(AminoAcidMatrix matrix, int colNr) {
        assert (colNr < matrix.numberOfColumns()) : "Column number greater than number of columns in teh matrix.";
        double willSum = 0.0;
        Map<String, HashSet<Character>> willSets = ConservationSets.williamsonSets();
        assert (willSets != null && !willSets.isEmpty());
        Set<String> willKeys = willSets.keySet();
        assert (!willKeys.isEmpty());
        Iterator<String> willKeysItr = willKeys.iterator();
        Set<Character> acInKeys = matrix.getTotalAcidsFreqByCol().get(colNr).keySet();
        assert (!acInKeys.isEmpty());
        HashMap<String, Integer> setsFreq = new HashMap<String, Integer>();
        while (willKeysItr.hasNext()) {
            String willKey = willKeysItr.next();
            for (Character acInKey : acInKeys) {
                if (!willSets.get(willKey).contains(acInKey)) continue;
                Integer count = (Integer)setsFreq.get(willKey);
                if (count == null) {
                    setsFreq.put(willKey, matrix.getTotalAcidsFreqByCol().get(colNr).get(acInKey));
                    continue;
                }
                setsFreq.put(willKey, count + matrix.getTotalAcidsFreqByCol().get(colNr).get(acInKey));
            }
        }
        assert (!setsFreq.isEmpty());
        Set setsFreqKeys = setsFreq.keySet();
        for (String setFreqKey : setsFreqKeys) {
            double pI = (double)((Integer)setsFreq.get(setFreqKey)).intValue() / (double)matrix.getInverseMatrix()[colNr].length;
            double piAve = (double)matrix.totalAcidsWillSets().get(setFreqKey).intValue() / (double)matrix.numberOfRows();
            willSum += pI * Math.log(pI / piAve);
        }
        return ConservationAccessory.round(willSum, 4);
    }

    static double landgrafScore(AminoAcidMatrix matrix, int colNr) {
        assert (colNr < matrix.numberOfColumns()) : "Column number greater than number of columns in teh matrix.";
        double sum = 0.0;
        double result = 0.0;
        char[] curColumn = matrix.getInverseMatrix()[colNr];
        double[] voronoiWeights = matrix.getVoronoiWeights(1000);
        for (int a = 0; a < curColumn.length; ++a) {
            double voronoiA = voronoiWeights[a];
            char currentCharA = curColumn[a];
            for (int b = a + 1; b < curColumn.length; ++b) {
                char currentCharB = curColumn[b];
                double disIJ = ConservationMatrices.dissimilarity(currentCharA, currentCharB);
                double disJI = ConservationMatrices.dissimilarity(currentCharB, currentCharA);
                sum = sum + voronoiA * disIJ + voronoiWeights[b] * disJI;
            }
        }
        result = sum / (double)curColumn.length;
        return ConservationAccessory.round(result, 4);
    }

    static double sanderScore(AminoAcidMatrix matrix, int colNr) {
        assert (colNr < matrix.numberOfColumns()) : "Column number greater than number of columns in the matrix.";
        double sum = 0.0;
        double moderator = 0.0;
        double result = 0.0;
        char[] curColumn = matrix.getInverseMatrix()[colNr];
        double[][] percent_identity = matrix.getPercentIdentity();
        for (int a = 0; a < curColumn.length; ++a) {
            int aIdx = 24 * ConservationMatrices.getIndex(curColumn[a]);
            double[] percent_id = percent_identity[a];
            for (int b = a + 1; b < curColumn.length; ++b) {
                double identity = 1.0 - percent_id[b];
                int pairIndex = aIdx + ConservationMatrices.getIndex(curColumn[b]);
                sum += identity * ConservationMatrices.pam250[pairIndex];
                moderator += identity;
            }
        }
        result = sum * moderator;
        return ConservationAccessory.round(result, 4);
    }

    static double valdarScore(AminoAcidMatrix matrix, int colNr) {
        assert (colNr < matrix.numberOfColumns()) : "Column number greater than number of columns in the matrix.";
        double sum = 0.0;
        double moderator = 0.0;
        double result = 0.0;
        char[] curColumn = matrix.getInverseMatrix()[colNr];
        double[] vingronArgosWeights = matrix.vingronArgosWeights();
        for (int a = 0; a < curColumn.length; ++a) {
            double vaweight = vingronArgosWeights[a];
            int aIdx = 24 * ConservationMatrices.getIndex(curColumn[a]);
            for (int b = a + 1; b < curColumn.length; ++b) {
                double mod = vaweight * vingronArgosWeights[b];
                int pairIndex = aIdx + ConservationMatrices.getIndex(curColumn[b]);
                sum += mod * ConservationMatrices.pet91[pairIndex];
                moderator += mod;
            }
        }
        result = sum * moderator;
        return ConservationAccessory.round(result, 4);
    }
}

