/*
 * Decompiled with CFR 0.152.
 */
package compbio.conservation;

import compbio.conservation.AminoAcidMatrix;
import compbio.conservation.ColumnScores;
import compbio.conservation.ConservationAccessory;
import compbio.conservation.ConservationFormatter;
import compbio.conservation.Correlation;
import compbio.conservation.Format;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.ClustalAlignmentUtil;
import compbio.data.sequence.ConservationMethod;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.SMERFSConstraints;
import compbio.data.sequence.SequenceUtil;
import compbio.data.sequence.UnknownFileFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Conservation {
    private final AminoAcidMatrix alignMatrix;
    private final boolean normalize;
    private final Map<ConservationMethod, double[]> results;
    private final ExecutorService executor;

    Conservation(AminoAcidMatrix alignment, boolean normalize, ExecutorService executor) {
        this.alignMatrix = alignment;
        this.normalize = normalize;
        this.executor = executor;
        this.results = new EnumMap<ConservationMethod, double[]>(ConservationMethod.class);
    }

    AminoAcidMatrix getAlignment() {
        return this.alignMatrix;
    }

    public Map<ConservationMethod, double[]> calculateScores(Set<ConservationMethod> methods) {
        return this.calculateConservation(methods);
    }

    public double[] calculateScore(ConservationMethod method) {
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
        double[] result = new double[this.alignMatrix.numberOfColumns()];
        double[] normalized = null;
        switch (method) {
            case KABAT: {
                for (int i = 0; i < this.alignMatrix.numberOfColumns(); ++i) {
                    result[i] = ColumnScores.kabatScore(this.alignMatrix, i);
                }
                if (!this.normalize) break;
                normalized = ConservationAccessory.inversedNormalize01(result, method);
                break;
            }
            case JORES: {
                for (int i = 0; i < this.alignMatrix.numberOfColumns(); ++i) {
                    result[i] = ColumnScores.joresScore(this.alignMatrix, i);
                }
                if (!this.normalize) break;
                normalized = ConservationAccessory.inversedNormalize01(result, method);
                break;
            }
            case SCHNEIDER: {
                for (int i = 0; i < this.alignMatrix.numberOfColumns(); ++i) {
                    result[i] = ColumnScores.schneiderScore(this.alignMatrix, i);
                }
                if (!this.normalize) break;
                normalized = ConservationAccessory.inversedNormalize01(result, method);
                break;
            }
            case SHENKIN: {
                for (int i = 0; i < this.alignMatrix.numberOfColumns(); ++i) {
                    result[i] = ColumnScores.shenkinScore(this.alignMatrix, i);
                }
                if (!this.normalize) break;
                normalized = ConservationAccessory.inversedNormalize01(result, method);
                break;
            }
            case GERSTEIN: {
                for (int i = 0; i < this.alignMatrix.numberOfColumns(); ++i) {
                    result[i] = ColumnScores.gersteinScore(this.alignMatrix, i);
                }
                if (!this.normalize) break;
                normalized = ConservationAccessory.inversedNormalize01(result, method);
                break;
            }
            case TAYLOR_GAPS: {
                for (int i = 0; i < this.alignMatrix.numberOfColumns(); ++i) {
                    result[i] = ColumnScores.taylorScoreGaps(this.alignMatrix, i);
                }
                if (!this.normalize) break;
                normalized = ConservationAccessory.inversedNormalize01(result, method);
                break;
            }
            case TAYLOR_NO_GAPS: {
                for (int i = 0; i < this.alignMatrix.numberOfColumns(); ++i) {
                    result[i] = ColumnScores.taylorScoreNoGaps(this.alignMatrix, i);
                }
                if (!this.normalize) break;
                normalized = ConservationAccessory.inversedNormalize01(result, method);
                break;
            }
            case ZVELIBIL: {
                for (int i = 0; i < this.alignMatrix.numberOfColumns(); ++i) {
                    result[i] = ColumnScores.zvelibilScore(this.alignMatrix, i);
                }
                if (!this.normalize) break;
                normalized = ConservationAccessory.normalize01(result, method);
                break;
            }
            case KARLIN: {
                for (int i = 0; i < this.alignMatrix.numberOfColumns(); ++i) {
                    tasks.add(Executors.callable(new TaskRunner(i, ConservationMethod.KARLIN, result)));
                }
                this.executeAndWait(tasks);
                if (!this.normalize) break;
                normalized = ConservationAccessory.normalize01(result, method);
                break;
            }
            case ARMON: {
                for (int i = 0; i < this.alignMatrix.numberOfColumns(); ++i) {
                    result[i] = ColumnScores.armonScore(this.alignMatrix, i);
                }
                if (!this.normalize) break;
                normalized = ConservationAccessory.inversedNormalize01(result, method);
                break;
            }
            case THOMPSON: {
                for (int i = 0; i < this.alignMatrix.numberOfColumns(); ++i) {
                    result[i] = ColumnScores.thompsonScore(this.alignMatrix, i);
                }
                if (!this.normalize) break;
                normalized = ConservationAccessory.inversedNormalize01(result, method);
                break;
            }
            case NOT_LANCET: {
                for (int i = 0; i < this.alignMatrix.numberOfColumns(); ++i) {
                    result[i] = ColumnScores.notLancetScore(this.alignMatrix, i);
                }
                if (!this.normalize) break;
                normalized = ConservationAccessory.normalize01(result, method);
                break;
            }
            case MIRNY: {
                for (int i = 0; i < this.alignMatrix.numberOfColumns(); ++i) {
                    result[i] = ColumnScores.mirnyScore(this.alignMatrix, i);
                }
                if (!this.normalize) break;
                normalized = ConservationAccessory.normalize01(result, method);
                break;
            }
            case WILLIAMSON: {
                for (int i = 0; i < this.alignMatrix.numberOfColumns(); ++i) {
                    result[i] = ColumnScores.williamsonScore(this.alignMatrix, i);
                }
                if (!this.normalize) break;
                normalized = ConservationAccessory.normalize01(result, method);
                break;
            }
            case LANDGRAF: {
                for (int i = 0; i < this.alignMatrix.numberOfColumns(); ++i) {
                    tasks.add(Executors.callable(new TaskRunner(i, ConservationMethod.LANDGRAF, result)));
                }
                this.executeAndWait(tasks);
                if (!this.normalize) break;
                normalized = ConservationAccessory.inversedNormalize01(result, method);
                break;
            }
            case SANDER: {
                for (int i = 0; i < this.alignMatrix.numberOfColumns(); ++i) {
                    tasks.add(Executors.callable(new TaskRunner(i, ConservationMethod.SANDER, result)));
                }
                this.executeAndWait(tasks);
                if (!this.normalize) break;
                normalized = ConservationAccessory.normalize01(result, method);
                break;
            }
            case VALDAR: {
                for (int i = 0; i < this.alignMatrix.numberOfColumns(); ++i) {
                    tasks.add(Executors.callable(new TaskRunner(i, ConservationMethod.VALDAR, result)));
                }
                this.executeAndWait(tasks);
                if (!this.normalize) break;
                normalized = ConservationAccessory.normalize01(result, method);
                break;
            }
            case SMERFS: {
                result = this.getSMERFS(7, SMERFSConstraints.DEFAULT_COLUMN_SCORE, 0.1);
                break;
            }
            default: {
                throw new RuntimeException("You should never ever get here");
            }
        }
        if (normalized != null) {
            this.results.put(method, normalized);
            return normalized;
        }
        this.results.put(method, result);
        return result;
    }

    private final void executeAndWait(List<Callable<Object>> tasks) {
        try {
            this.executor.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("The program was stopped in the middle of the calculation");
        }
    }

    public static Conservation getConservation(File file, boolean normalize, ExecutorService executor) throws FileNotFoundException, IOException, UnknownFileFormatException {
        if (file == null) {
            throw new NullPointerException("File must be provided!");
        }
        AminoAcidMatrix alignMatrix = null;
        FileInputStream fis = new FileInputStream(file);
        boolean isClustalFile = ClustalAlignmentUtil.isValidClustalFile(fis);
        fis = new FileInputStream(file);
        if (isClustalFile) {
            Alignment alignment = ClustalAlignmentUtil.readClustalFile(fis);
            assert (alignment != null) : "Fails to read the alignement!";
            alignMatrix = new AminoAcidMatrix(alignment);
        } else {
            List<FastaSequence> sequences = SequenceUtil.readFasta(fis);
            alignMatrix = new AminoAcidMatrix(sequences, null);
        }
        return new Conservation(alignMatrix, normalize, executor);
    }

    public static Conservation getConservation(Alignment alignment, boolean normalize, ExecutorService executor) {
        if (alignment == null) {
            throw new NullPointerException("Alignment must be provided!");
        }
        if (executor == null) {
            throw new NullPointerException("Executor must be provided!");
        }
        return new Conservation(new AminoAcidMatrix(alignment), normalize, executor);
    }

    public static Conservation getConservation(List<FastaSequence> sequences, boolean normalize, ExecutorService executor) {
        if (sequences == null || sequences.isEmpty()) {
            throw new NullPointerException("Sequences must be provided!");
        }
        return new Conservation(new AminoAcidMatrix(sequences, null), normalize, executor);
    }

    private synchronized Map<ConservationMethod, double[]> calculateConservation(Set<ConservationMethod> methods) {
        for (ConservationMethod method : methods) {
            double[] singleRes = this.calculateScore(method);
            assert (singleRes != null && singleRes.length > 0);
            this.results.put(method, singleRes);
        }
        return Collections.unmodifiableMap(this.results);
    }

    public void outputResults(File outFile, Format format) throws IOException {
        ConservationFormatter.formatResults(this.results, outFile.getAbsolutePath(), format, this.alignMatrix);
    }

    public void printResults(Format format) throws IOException {
        ConservationFormatter.formatResults(this.results, null, format, this.alignMatrix);
    }

    public static void printResults(Map<ConservationMethod, double[]> results) {
        ConservationFormatter.formatResults(results, System.out);
    }

    public static void printResults(double[] result, ConservationMethod method) {
        EnumMap<ConservationMethod, double[]> results = new EnumMap<ConservationMethod, double[]>(ConservationMethod.class);
        results.put(method, result);
        Conservation.printResults(results);
    }

    public double[] getSMERFS(int width, SMERFSConstraints score, double gapTreshold) {
        if (this.alignMatrix == null) {
            throw new IllegalArgumentException("Matrix must not be null.");
        }
        double[] result = null;
        if (width <= 0 || width % 2 != 1 || width > this.alignMatrix.numberOfColumns() || score == null || gapTreshold < 0.0 || gapTreshold > 1.0) {
            if (width <= 0 || width % 2 != 1) {
                throw new IllegalArgumentException("Column width for SMERFS not provided or smaller or equal zero or not an odd number or not an integer.");
            }
            if (width > this.alignMatrix.numberOfColumns()) {
                throw new IllegalArgumentException("Column width greater than the length of the alignment");
            }
            if (score == null) {
                throw new IllegalArgumentException("Column score not privided or the type provided is not supported.Supported scores are: " + SMERFSConstraints.values());
            }
            if (gapTreshold < 0.0 || gapTreshold > 1.0) {
                throw new IllegalArgumentException("Gap treshold could not have been parsed as a double or it was smaller than zero or it was greater than one.");
            }
        }
        Correlation corr = new Correlation(this.alignMatrix, width, gapTreshold, this.executor);
        try {
            result = corr.getCorrelationScore(score, this.normalize);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Calculation was interrupted!", e.getCause());
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error during calculation!" + e.getLocalizedMessage(), e.getCause());
        }
        return result;
    }

    public int hashCode() {
        int prime = 7;
        int result = 1;
        result = 7 * result + (this.alignMatrix == null ? 0 : this.alignMatrix.hashCode());
        result = 7 * result + (this.normalize ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Conservation other = (Conservation)obj;
        if (this.alignMatrix == null ? other.alignMatrix != null : !this.alignMatrix.equals(other.alignMatrix)) {
            return false;
        }
        return this.normalize == other.normalize;
    }

    private final class TaskRunner
    implements Runnable {
        private final int iteration;
        private final ConservationMethod method;
        private final double[] result;

        public TaskRunner(int i, ConservationMethod method, double[] result) {
            this.iteration = i;
            this.method = method;
            this.result = result;
        }

        public void run() {
            switch (this.method) {
                case KARLIN: {
                    this.result[this.iteration] = ColumnScores.karlinScore(Conservation.this.alignMatrix, this.iteration);
                    break;
                }
                case VALDAR: {
                    this.result[this.iteration] = ColumnScores.valdarScore(Conservation.this.alignMatrix, this.iteration);
                    break;
                }
                case LANDGRAF: {
                    this.result[this.iteration] = ColumnScores.landgrafScore(Conservation.this.alignMatrix, this.iteration);
                    break;
                }
                case SANDER: {
                    this.result[this.iteration] = ColumnScores.sanderScore(Conservation.this.alignMatrix, this.iteration);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Only KARLIN, VALDAR, LANDGRAF and SANDER methods can be executed via TaskRunner!");
                }
            }
        }
    }
}

