/*
 * Decompiled with CFR 0.152.
 */
package compbio.conservation;

import compbio.conservation.AminoAcidMatrix;
import compbio.conservation.ConservationFormatter;
import compbio.data.sequence.ConservationMethod;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Random;

final class ConservationAccessory {
    ConservationAccessory() {
    }

    static double[] addPoints(double[] a, double[] b) {
        if (a == null || b == null) {
            throw new IllegalArgumentException("Reference must not be null");
        }
        assert (a.length == b.length);
        double[] aPlusB = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            aPlusB[i] = a[i] + b[i];
        }
        return aPlusB;
    }

    static double[] multPointByScalar(double[] point, double scalar) {
        double[] pointByScalar = new double[point.length];
        for (int i = 0; i < point.length; ++i) {
            pointByScalar[i] = point[i] * scalar;
        }
        return pointByScalar;
    }

    static double pointDistance(double[] a, double[] b) {
        if (a == null || b == null) {
            throw new IllegalArgumentException("Reference must not be null");
        }
        assert (a.length == b.length);
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += (b[i] - a[i]) * (b[i] - a[i]);
        }
        double distance = Math.sqrt(sum);
        return distance;
    }

    static double percentIdentity(char[] a, char[] b) {
        if (a == null || b == null) {
            throw new IllegalArgumentException("Reference must not be null");
        }
        assert (a.length == b.length);
        int ident = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != b[i]) continue;
            ++ident;
        }
        double result = (double)ident / (double)a.length;
        return result;
    }

    static double[] voronoiWeights(AminoAcidMatrix m, int iter) {
        AminoAcidMatrix matrix = m;
        int iterations = iter;
        Random rgen = new Random();
        double[] weights = new double[m.numberOfRows()];
        char[] randSeq = new char[m.numberOfColumns()];
        for (int i = 0; i < iterations; ++i) {
            for (int j = 0; j < matrix.numberOfColumns(); ++j) {
                int random = rgen.nextInt(matrix.numberOfRows());
                randSeq[j] = matrix.getMatrixPosition(random, j);
            }
            double[] distances = new double[matrix.numberOfRows()];
            double closestValue = 0.0;
            for (int a = 0; a < matrix.numberOfRows(); ++a) {
                distances[a] = 1.0 - ConservationAccessory.percentIdentity(matrix.getRow(a), randSeq);
                if (!(distances[a] < closestValue)) continue;
                closestValue = distances[a];
            }
            ArrayList<Integer> closestSeqs = new ArrayList<Integer>();
            for (int b = 0; b < distances.length; ++b) {
                double dis = distances[b];
                if (dis != closestValue) continue;
                closestSeqs.add(b);
            }
            double increase = 1.0 / (double)closestSeqs.size();
            for (int c = 0; c < closestSeqs.size(); ++c) {
                int cs;
                int n = cs = ((Integer)closestSeqs.get(c)).intValue();
                weights[n] = weights[n] + increase;
            }
        }
        double weightSum = 0.0;
        for (int d = 0; d < weights.length; ++d) {
            weightSum += weights[d];
        }
        double scaleFactor = weightSum / (double)matrix.numberOfRows();
        for (int e = 0; e < weights.length; ++e) {
            weights[e] = weights[e] + scaleFactor;
        }
        return weights;
    }

    static double weightOfSequenceVingronArgos(int seqNr, AminoAcidMatrix m) {
        double weight = 0.0;
        for (int i = 0; i < m.numberOfRows(); ++i) {
            if (i == seqNr) continue;
            weight += ConservationAccessory.percentIdentity(m.getRow(seqNr), m.getRow(i));
        }
        double result = 1.0 / (double)m.numberOfRows() * weight;
        return result;
    }

    static double[] normalize01(double[] scores, ConservationMethod method) {
        int i;
        double[] normalized = new double[scores.length];
        double max = scores[0];
        double min = scores[0];
        for (i = 0; i < scores.length; ++i) {
            if (scores[i] > max) {
                max = scores[i];
            }
            if (!(scores[i] < min)) continue;
            min = scores[i];
        }
        if (max == min) {
            System.err.println("Warning: Scores for method " + method.toString() + " were not normalized properly as maxScore == minScore." + " Default scores are provided instead.");
            return null;
        }
        if (min < 0.0) {
            int i2;
            double minAbs = min * -1.0;
            double[] shifted = new double[scores.length];
            for (i2 = 0; i2 < shifted.length; ++i2) {
                shifted[i2] = scores[i2] + minAbs;
            }
            max += minAbs;
            min += minAbs;
            for (i2 = 0; i2 < normalized.length; ++i2) {
                normalized[i2] = ConservationAccessory.round((shifted[i2] - min) / (max - min), 4);
            }
        } else {
            for (i = 0; i < scores.length; ++i) {
                normalized[i] = ConservationAccessory.round((scores[i] - min) / (max - min), 4);
            }
        }
        return normalized;
    }

    static double[] inversedNormalize01(double[] scores, ConservationMethod method) {
        double[] normalized = ConservationAccessory.normalize01(scores, method);
        if (normalized == null) {
            return null;
        }
        double[] inversed = new double[normalized.length];
        for (int i = 0; i < inversed.length; ++i) {
            inversed[i] = ConservationAccessory.round(1.0 - normalized[i], 4);
        }
        return inversed;
    }

    static void printArrayOfDouble(double[] arr1, PrintWriter print, int precision) {
        ConservationFormatter.NUMBER_FORMAT.setMaximumFractionDigits(precision);
        assert (arr1 != null) : "Nothing to print!";
        PrintWriter writer = print;
        if (print == null) {
            writer = new PrintWriter(System.out);
        }
        for (int i = 0; i < arr1.length; ++i) {
            writer.printf("%.4f", arr1[i]);
            writer.print(" ");
        }
        writer.println();
        writer.flush();
    }

    public static double round(double d, int decimalPlace) {
        if (Double.isNaN(d)) {
            return -1000.0;
        }
        BigDecimal bd = new BigDecimal(Double.toString(d));
        bd = bd.setScale(decimalPlace, 4);
        return bd.doubleValue();
    }
}

