/*
 * Decompiled with CFR 0.152.
 */
package compbio.conservation;

import compbio.conservation.AminoAcidMatrix;
import compbio.conservation.Conservation;
import compbio.conservation.ConservationFormatter;
import compbio.conservation.MethodWrapper;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.ConservationMethod;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.SMERFSConstraints;
import compbio.data.sequence.SequenceUtil;
import compbio.data.sequence.UnknownFileFormatException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConservationCalculator {
    public static Map<ConservationMethod, double[]> getConservation(List<FastaSequence> alignment, boolean normalize, Set<ConservationMethod> methods, ExecutorService executor) throws InterruptedException {
        EnumMap<ConservationMethod, double[]> results = new EnumMap<ConservationMethod, double[]>(ConservationMethod.class);
        AminoAcidMatrix alignMatrix = new AminoAcidMatrix(alignment, null);
        Conservation scores = new Conservation(alignMatrix, normalize, executor);
        ArrayList<MethodWrapper> tasks = new ArrayList<MethodWrapper>();
        for (ConservationMethod method : methods) {
            if (method == ConservationMethod.SMERFS) {
                double[] conservation = scores.getSMERFS(7, SMERFSConstraints.MID_SCORE, 0.1);
                results.put(ConservationMethod.SMERFS, conservation);
                continue;
            }
            if (method == ConservationMethod.LANDGRAF || method == ConservationMethod.SANDER || method == ConservationMethod.KARLIN || method == ConservationMethod.VALDAR) {
                double[] result = scores.calculateScore(method);
                results.put(method, result);
                continue;
            }
            MethodWrapper wrapper = new MethodWrapper(method, scores, null);
            tasks.add(wrapper);
        }
        ConservationCalculator.waitResults(executor, tasks, results);
        return results;
    }

    private static void waitResults(ExecutorService executor, List<MethodWrapper> tasks, Map<ConservationMethod, double[]> results) throws InterruptedException {
        List rawResults = executor.invokeAll(tasks);
        for (Future rawResult : rawResults) {
            MethodWrapper entry = null;
            try {
                entry = (MethodWrapper)rawResult.get();
            }
            catch (ExecutionException e) {
                System.err.println("Exception while executing method");
                throw new RuntimeException(e.getCause());
            }
            results.put(entry.method, entry.conservation);
        }
    }

    public static double[] getSMERFSScore(Alignment alignment, int windowWidth, SMERFSConstraints scoringMethod, float gapTreshold, boolean normalize, ExecutorService service) {
        AminoAcidMatrix alignMatrix = new AminoAcidMatrix(alignment.getSequences(), null);
        Conservation scores = new Conservation(alignMatrix, normalize, service);
        return scores.getSMERFS(windowWidth, scoringMethod, gapTreshold);
    }

    static void main(String[] args) throws InterruptedException, IOException, UnknownFileFormatException {
        int corenum = Runtime.getRuntime().availableProcessors();
        ExecutorService executor = Executors.newFixedThreadPool(corenum);
        List<FastaSequence> sequences = SequenceUtil.openInputStream("test/data/small.align");
        Map<ConservationMethod, double[]> result = ConservationCalculator.getConservation(sequences, true, EnumSet.allOf(ConservationMethod.class), executor);
        FileOutputStream outfile = new FileOutputStream("results.txt");
        ConservationFormatter.formatResults(result, outfile);
        outfile.close();
        executor.shutdown();
    }
}

