/*
 * Decompiled with CFR 0.152.
 */
package compbio.conservation;

import compbio.conservation.AminoAcidMatrix;
import compbio.conservation.ConservationAccessory;
import compbio.conservation.Format;
import compbio.data.sequence.ConservationMethod;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.SequenceUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConservationFormatter {
    static final int PRECISION = 3;
    static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance(Locale.UK);

    static void formatResults(Map<ConservationMethod, double[]> scores, String outFilePath, Format format, AminoAcidMatrix alignment) throws IOException {
        if (alignment == null) {
            throw new NullPointerException("Alignment must be provided!");
        }
        ConservationFormatter.formatResults(scores, outFilePath, format, alignment.getAlignment());
    }

    public static void formatResults(Map<ConservationMethod, double[]> scores, String outFilePath, Format format, List<FastaSequence> alignment) throws IOException {
        assert (format != null) : "Format must not be null";
        assert (scores != null) : "Scores must not be null";
        if (scores == null) {
            return;
        }
        if (format == null) {
            format = Format.RESULT_NO_ALIGNMENT;
        }
        if (alignment == null) {
            throw new NullPointerException("Alignment must be provided");
        }
        OutputStream out = ConservationFormatter.openPrintWriter(outFilePath);
        switch (format) {
            case RESULT_NO_ALIGNMENT: {
                ConservationFormatter.formatResults(scores, out);
                break;
            }
            case RESULT_WITH_ALIGNMENT: {
                SequenceUtil.writeFastaKeepTheStream(out, alignment, 80);
                ConservationFormatter.formatResults(scores, out);
            }
        }
        out.flush();
        out.close();
    }

    public static void formatResults(Map<ConservationMethod, double[]> scores, OutputStream outStream) {
        if (outStream == null) {
            throw new NullPointerException("Output stream must be provided!");
        }
        PrintWriter print = new PrintWriter(outStream);
        for (ConservationMethod key : scores.keySet()) {
            print.print("#" + key.toString() + " ");
            ConservationAccessory.printArrayOfDouble(scores.get((Object)key), print, 3);
        }
        print.println();
        print.flush();
    }

    static OutputStream openPrintWriter(String outFilePath) throws IOException {
        OutputStream outstream = null;
        outstream = outFilePath == null || outFilePath.isEmpty() ? System.out : new FileOutputStream(outFilePath);
        return outstream;
    }

    static {
        NUMBER_FORMAT.setGroupingUsed(false);
    }
}

