/*
 * Decompiled with CFR 0.152.
 */
package compbio.conservation;

import compbio.util.NullOutputStream;
import java.io.PrintWriter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

final class ExecutorFactory {
    private static volatile ExecutorService executor;
    private static volatile int threadNum;

    ExecutorFactory() {
    }

    private static void initializeExecutor(int procNum, PrintWriter statWriter) {
        int corenum = Runtime.getRuntime().availableProcessors();
        if (procNum < 1) {
            procNum = corenum;
        } else if (procNum > corenum * 2) {
            String message = "Number of processors must be more than 1 and \nless than the number of cores*2 \nHowever given number of processors is " + procNum + "\n" + "Changing number of processors to " + corenum + " - the number of cores\n";
            System.err.println(message);
            statWriter.println(message);
            procNum = corenum;
        }
        statWriter.println("Using " + procNum + " CPUs");
        threadNum = procNum;
        executor = ExecutorFactory.getExecutor(ExecutorType.AsynchQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initExecutor(int procNum, PrintWriter statWriter) {
        if (executor != null && threadNum == procNum) return;
        Class<ExecutorFactory> clazz = ExecutorFactory.class;
        synchronized (ExecutorFactory.class) {
            if (threadNum == procNum) return;
            if (executor != null) {
                executor.shutdownNow();
            }
            ExecutorFactory.initializeExecutor(procNum, statWriter);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void initExecutor(int procNum) {
        ExecutorFactory.initExecutor(procNum, new PrintWriter(new NullOutputStream()));
    }

    public static void initExecutor() {
        ExecutorFactory.initExecutor(0, new PrintWriter(new NullOutputStream()));
    }

    public static void initExecutor(PrintWriter statWriter) {
        ExecutorFactory.initExecutor(0, statWriter);
    }

    public static ExecutorService getExecutor() {
        if (executor == null) {
            throw new IllegalStateException("Please initialize the executor first!");
        }
        return executor;
    }

    private static ExecutorService getExecutor(ExecutorType etype) {
        switch (etype) {
            case AsynchQueue: {
                executor = Executors.newFixedThreadPool(threadNum);
                break;
            }
            case SynchroniousCallerRuns: {
                executor = new ThreadPoolExecutor(threadNum, threadNum, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
                break;
            }
            default: {
                throw new RuntimeException("Unsupported executor type!");
            }
        }
        return executor;
    }

    static {
        threadNum = -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExecutorType {
        SynchroniousCallerRuns,
        AsynchQueue;

    }
}

