/*
 * Decompiled with CFR 0.152.
 */
package compbio.conservation;

import compbio.conservation.Conservation;
import compbio.data.sequence.ConservationMethod;
import compbio.util.NullOutputStream;
import compbio.util.Timer;
import java.io.IOException;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MethodWrapper
implements Callable<MethodWrapper> {
    double[] conservation = null;
    final ConservationMethod method;
    private final Conservation scores;
    final Timer timer;

    MethodWrapper(ConservationMethod method, Conservation scores, Timer timer) {
        this.method = method;
        this.scores = scores;
        if (timer == null) {
            try {
                this.timer = new Timer(new NullOutputStream());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new AssertionError((Object)"Cannot construct Timer with NullOutputStream?!");
            }
        } else {
            this.timer = new Timer(timer);
        }
    }

    @Override
    public MethodWrapper call() throws Exception {
        assert (this.method != ConservationMethod.SMERFS) : " Must use separate method to calculate SMERFS to avoid thread contantion";
        this.timer.getStepTime();
        this.conservation = this.scores.calculateScore(this.method);
        this.timer.println(this.method.toString() + " " + this.timer.getStepTime() + " ms");
        return this;
    }
}

