/*
 * Decompiled with CFR 0.152.
 */
package compbio.conservation;

import compbio.conservation.AminoAcidMatrix;
import compbio.conservation.CmdParser;
import compbio.conservation.Conservation;
import compbio.conservation.ConservationFormatter;
import compbio.conservation.ExecutorFactory;
import compbio.conservation.Format;
import compbio.conservation.MethodWrapper;
import compbio.data.sequence.ConservationMethod;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.SMERFSConstraints;
import compbio.data.sequence.SequenceUtil;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.util.Timer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

final class ParallelConservationClient {
    private final Map<ConservationMethod, double[]> results = new EnumMap<ConservationMethod, double[]>(ConservationMethod.class);

    ParallelConservationClient(String[] cmd) throws IOException, InterruptedException, UnknownFileFormatException {
        Timer timer = Timer.getMilliSecondsTimer();
        String statFile = CmdParser.getStatFilePath(cmd);
        if (statFile == null) {
            timer.setStatOutput(null);
        } else {
            timer.setStatOutput(new FileOutputStream(statFile));
        }
        Set<ConservationMethod> methods = CmdParser.getMethodNames(cmd);
        if (methods.isEmpty()) {
            methods = EnumSet.allOf(ConservationMethod.class);
            timer.println("No methods are request assuming all are required.");
        }
        String inFilePath = CmdParser.getInputFilePath(cmd);
        if (!methods.isEmpty() && inFilePath != null) {
            String format = CmdParser.getFormat(cmd);
            String outFilePath = CmdParser.getOutputFilePath(cmd);
            if (outFilePath == null) {
                timer.println("No output file is provided, writing results to the standard output.");
            }
            Format outFormat = Format.RESULT_NO_ALIGNMENT;
            if (format != null) {
                Format userFormat = Format.getFormat(format);
                if (userFormat == null) {
                    timer.println("Cannot recognise format '" + format + "' Assuming " + Format.RESULT_NO_ALIGNMENT.toString() + " format");
                } else {
                    outFormat = userFormat;
                    timer.println("Setting output format to " + (Object)((Object)userFormat));
                }
            } else {
                timer.println("No format is provided assuming RESULT_NO_ALIGNMENT is required");
            }
            SMERFSParams smerfsPar = new SMERFSParams(cmd);
            boolean normalize = CmdParser.getNormalize(cmd);
            String[] gap = CmdParser.getGapChars(cmd);
            char[] gapChars = CmdParser.extractGapChars(gap);
            ExecutorFactory.initExecutor(CmdParser.getThreadNumber(cmd), timer.getStatWriter());
            ExecutorService executor = ExecutorFactory.getExecutor();
            List<FastaSequence> sequences = SequenceUtil.openInputStream(inFilePath);
            if (sequences != null) {
                AminoAcidMatrix alignment = new AminoAcidMatrix(sequences, gapChars);
                timer.println("Start time: " + CmdParser.getDateTime());
                timer.println("Alignment loaded in: " + timer.getStepTime() + " ms");
                timer.println("Alignment has: " + alignment.numberOfRows() + " sequences.");
                timer.println("Alignment length is: " + alignment.numberOfColumns() + " ");
                Conservation scores = new Conservation(alignment, normalize, ExecutorFactory.getExecutor());
                MethodWrapper wrapper = null;
                ArrayList<MethodWrapper> tasks = new ArrayList<MethodWrapper>();
                for (ConservationMethod method : methods) {
                    double[] result;
                    if (method == ConservationMethod.SMERFS) {
                        result = this.runSMERFS(scores, smerfsPar, timer);
                        this.results.put(ConservationMethod.SMERFS, result);
                        continue;
                    }
                    if (method == ConservationMethod.LANDGRAF || method == ConservationMethod.SANDER || method == ConservationMethod.KARLIN || method == ConservationMethod.VALDAR) {
                        result = this.runParallelMethod(scores, method, timer);
                        this.results.put(method, result);
                        continue;
                    }
                    wrapper = new MethodWrapper(method, scores, timer);
                    tasks.add(wrapper);
                }
                List rawResults = executor.invokeAll(tasks);
                for (Future rawResult : rawResults) {
                    MethodWrapper entry = null;
                    try {
                        entry = (MethodWrapper)rawResult.get();
                    }
                    catch (ExecutionException e) {
                        System.err.println("Exception while executing method");
                        throw new RuntimeException(e.getCause());
                    }
                    this.results.put(entry.method, entry.conservation);
                }
                executor.shutdown();
                ConservationFormatter.formatResults(this.results, outFilePath, outFormat, alignment);
                timer.println("Total calculation time: " + timer.getTotalTime(TimeUnit.SECONDS) + " s");
                timer.println("End time: " + CmdParser.getDateTime());
                timer.getStatWriter().close();
            } else {
                System.out.println("No input found in " + inFilePath + " ! Exiting");
            }
        }
    }

    static void checkArguments(String[] args) {
        if (args == null) {
            System.out.println("No parameters were suppled");
            System.out.println();
            System.out.print("\r\nAA Conservation version 1.1 (19 April 2017)\r\n\r\nThis program allows calculation of conservation of amino acids in\r\nmultiple sequence alignments.\r\nIt implements 17 different conservation scores as described by Valdar in\r\nhis paper (Scoring Residue Conservation, PROTEINS: Structure, Function\r\nand  Bioinformatics 48:227-241 (2002)) and SMERFS scoring algorithm as described\r\nby Manning, Jefferson and Barton (The contrasting properties of conservation\r\nand correlated phylogeny in protein functional residue prediction,\r\nBMC Bioinformatics (2008)).\r\n\r\nThe conservation algorithms supported are:\r\n\r\nKABAT, JORES, SCHNEIDER, SHENKIN, GERSTEIN, TAYLOR_GAPS, TAYLOR_NO_GAPS, \r\nZVELIBIL, KARLIN, ARMON, THOMPSON, NOT_LANCET, MIRNY, WILLIAMSON, \r\nLANDGRAF, SANDER, VALDAR, SMERFS\r\n\r\nInput format is either a FASTA formatted file containing aligned sequences with \r\ngaps or a Clustal alignment. The valid gap characters are *, -, space character,\r\nX and . (a dot). By default program prints the results to the command window. \r\nIf the output file is provided the results are printed to the file in two \r\npossible formats with or without an alignment.\r\nIf format is not specified, the program outputs conservation scores without \r\nalignment. The scores are not normalized by default but they can be (see below).\r\nSMERFS default parameters are window width of 7, column score is set to\r\nthe middle column (MID_SCORE), gap% cutoff of 0.1. Different parameters for SMERFS \r\ncan be provided (see below). Details of the program execution can be recorded to\r\na separate file if an appropriate file path is provided.\r\n\r\nList of command line arguments:\r\n\r\n-m=  precedes a comma separated list of method names\r\n     EXAMPLE: -m=KABAT,JORES,GERSTEIN\r\n     Optional, if no method is specified request for all is assumed. \r\n\r\n-i=  precedes a full path to the input FASTA file, required\r\n\r\n-o=  precedes a full path to the output file, optional, if no output file is \r\n     provided the program will output to the standard out.  \r\n\r\n-t=  precedes the number of CPUs (CPU cores more precisely) to use. Optional, \r\n\t defaults to all processors available on the machine.  \r\n      \r\n-f=  precedes the format  of the results in the output file\r\n     two different formats are possible:\r\n      RESULT_WITH_ALIGNMENT\r\n      RESULT_NO_ALIGNMENT\r\n     Optional, if not specified RESULT_NO_ALIGNMENT is assumed \r\n\r\n-d=  precedes a full path to a file where program execution details are to be \r\n     listed. Optional, if not provided, no execution statistics is produced.  \r\n      \r\n-g=  precedes comma separated list of gap characters provided by the user, if \r\n     you're using an unusual gap character (not a -,., ,*,X) you have to \r\n     provide it. If you you provide this list you have to list all the gaps \r\n     accepted. Including those that were previously treated as a default. \r\n     Optional.      \r\n      \r\n-n   using this key causes the results to be normalized. \r\n\t Normalized results have values between 0 and 1. Please note however, that \r\n\t some results cannot be normalized. In such a case, the system returns not \r\n\t normalized value, and log the issue to the standard error stream. \r\n\t The following formula is used for normalization \r\n\t\t\tn = (d - dmin)/(dmax - dmin)\r\n\t Negative results first converted to positive by adding an absolute value of\r\n\t the most negative result. Optional.\r\n\r\nSMERFS Only Parameters: \r\n\r\n-smerfsGT=  precedes SMERFS Gap Treshold - a gap percentage cutoff - \r\n\t\t\ta float greater than 0 and smaller or equal 1. Optional defaults \r\n\t\t\tto 0.1\r\n\r\n-smerfsCS=  precedes SMERFS Column Score algorithm defines the window scores to \r\n\t\t\tcolumns\tallocation , two methods are possible:\r\n\t        MID_SCORE - gives the window score to the middle column\r\n\t        MAX_SCORE - gives the column the highest score of all the windows it \r\n\t        belongs to. Optional defaults to MID_SCORE.  \r\n\r\n-smerfsWW=  precedes Window Width parameter - an integer and an odd number.\r\n            Optional, defaults to 7 \r\n\t  \r\n\r\nEXAMPLE HOW TO RUN THE PROGRAM:\r\njava -jar <jar name> -m=KABAT,SMERFS -i=prot1 -o=prot1_results -n\r\n\r\nAs a result of the execution KABAT and SMERFS scores will be calculated. \r\nInput comes form prot1 file and an output without an alignment is recorded to \r\nprot1_results file. \r\n\r\nAuthors: Peter Troshin, Agnieszka Golicz, David Martin, F\u00e1bio Madeira and Geoff J. Barton.\r\nPlease visit http://www.compbio.dundee.ac.uk/aacon for further information.\r\n ");
            System.exit(0);
        }
        if (args.length < 2) {
            System.out.println("Method names, input file paths are required. Application will not run until these 2 arguments are provided.");
            System.out.println("If you want results printed, both format an input file path have to be provided");
            System.out.println();
            System.out.print("\r\nAA Conservation version 1.1 (19 April 2017)\r\n\r\nThis program allows calculation of conservation of amino acids in\r\nmultiple sequence alignments.\r\nIt implements 17 different conservation scores as described by Valdar in\r\nhis paper (Scoring Residue Conservation, PROTEINS: Structure, Function\r\nand  Bioinformatics 48:227-241 (2002)) and SMERFS scoring algorithm as described\r\nby Manning, Jefferson and Barton (The contrasting properties of conservation\r\nand correlated phylogeny in protein functional residue prediction,\r\nBMC Bioinformatics (2008)).\r\n\r\nThe conservation algorithms supported are:\r\n\r\nKABAT, JORES, SCHNEIDER, SHENKIN, GERSTEIN, TAYLOR_GAPS, TAYLOR_NO_GAPS, \r\nZVELIBIL, KARLIN, ARMON, THOMPSON, NOT_LANCET, MIRNY, WILLIAMSON, \r\nLANDGRAF, SANDER, VALDAR, SMERFS\r\n\r\nInput format is either a FASTA formatted file containing aligned sequences with \r\ngaps or a Clustal alignment. The valid gap characters are *, -, space character,\r\nX and . (a dot). By default program prints the results to the command window. \r\nIf the output file is provided the results are printed to the file in two \r\npossible formats with or without an alignment.\r\nIf format is not specified, the program outputs conservation scores without \r\nalignment. The scores are not normalized by default but they can be (see below).\r\nSMERFS default parameters are window width of 7, column score is set to\r\nthe middle column (MID_SCORE), gap% cutoff of 0.1. Different parameters for SMERFS \r\ncan be provided (see below). Details of the program execution can be recorded to\r\na separate file if an appropriate file path is provided.\r\n\r\nList of command line arguments:\r\n\r\n-m=  precedes a comma separated list of method names\r\n     EXAMPLE: -m=KABAT,JORES,GERSTEIN\r\n     Optional, if no method is specified request for all is assumed. \r\n\r\n-i=  precedes a full path to the input FASTA file, required\r\n\r\n-o=  precedes a full path to the output file, optional, if no output file is \r\n     provided the program will output to the standard out.  \r\n\r\n-t=  precedes the number of CPUs (CPU cores more precisely) to use. Optional, \r\n\t defaults to all processors available on the machine.  \r\n      \r\n-f=  precedes the format  of the results in the output file\r\n     two different formats are possible:\r\n      RESULT_WITH_ALIGNMENT\r\n      RESULT_NO_ALIGNMENT\r\n     Optional, if not specified RESULT_NO_ALIGNMENT is assumed \r\n\r\n-d=  precedes a full path to a file where program execution details are to be \r\n     listed. Optional, if not provided, no execution statistics is produced.  \r\n      \r\n-g=  precedes comma separated list of gap characters provided by the user, if \r\n     you're using an unusual gap character (not a -,., ,*,X) you have to \r\n     provide it. If you you provide this list you have to list all the gaps \r\n     accepted. Including those that were previously treated as a default. \r\n     Optional.      \r\n      \r\n-n   using this key causes the results to be normalized. \r\n\t Normalized results have values between 0 and 1. Please note however, that \r\n\t some results cannot be normalized. In such a case, the system returns not \r\n\t normalized value, and log the issue to the standard error stream. \r\n\t The following formula is used for normalization \r\n\t\t\tn = (d - dmin)/(dmax - dmin)\r\n\t Negative results first converted to positive by adding an absolute value of\r\n\t the most negative result. Optional.\r\n\r\nSMERFS Only Parameters: \r\n\r\n-smerfsGT=  precedes SMERFS Gap Treshold - a gap percentage cutoff - \r\n\t\t\ta float greater than 0 and smaller or equal 1. Optional defaults \r\n\t\t\tto 0.1\r\n\r\n-smerfsCS=  precedes SMERFS Column Score algorithm defines the window scores to \r\n\t\t\tcolumns\tallocation , two methods are possible:\r\n\t        MID_SCORE - gives the window score to the middle column\r\n\t        MAX_SCORE - gives the column the highest score of all the windows it \r\n\t        belongs to. Optional defaults to MID_SCORE.  \r\n\r\n-smerfsWW=  precedes Window Width parameter - an integer and an odd number.\r\n            Optional, defaults to 7 \r\n\t  \r\n\r\nEXAMPLE HOW TO RUN THE PROGRAM:\r\njava -jar <jar name> -m=KABAT,SMERFS -i=prot1 -o=prot1_results -n\r\n\r\nAs a result of the execution KABAT and SMERFS scores will be calculated. \r\nInput comes form prot1 file and an output without an alignment is recorded to \r\nprot1_results file. \r\n\r\nAuthors: Peter Troshin, Agnieszka Golicz, David Martin, F\u00e1bio Madeira and Geoff J. Barton.\r\nPlease visit http://www.compbio.dundee.ac.uk/aacon for further information.\r\n ");
            System.exit(0);
        }
    }

    private double[] runSMERFS(Conservation scores, SMERFSParams sparams, Timer timer) {
        timer.getStepTime();
        double[] conservation = scores.getSMERFS(sparams.SMERFSWidth, sparams.colScoreSchema, sparams.SMERFSGapTreshold);
        timer.println("SMERFS " + timer.getStepTime() + " ms");
        return conservation;
    }

    private double[] runParallelMethod(Conservation scores, ConservationMethod method, Timer timer) {
        timer.getStepTime();
        double[] results = scores.calculateScore(method);
        timer.println(method.toString() + " " + timer.getStepTime() + " ms");
        return results;
    }

    public static void main(String[] args) {
        ParallelConservationClient.checkArguments(args);
        try {
            ParallelConservationClient cons = new ParallelConservationClient(args);
        }
        catch (IOException e) {
            System.err.println("Fail to write to the file system! " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            System.err.println("Interrupted!");
            e.printStackTrace();
        }
        catch (UnknownFileFormatException e) {
            System.err.println("Fail to recognise input file format! Must be either Clustal formatted alignment or a list of aligned Fasta formatted sequences separated by a new line." + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private static class SMERFSParams {
        private final SMERFSConstraints colScoreSchema = SMERFSConstraints.MID_SCORE;
        private double SMERFSGapTreshold = 0.1;
        private int SMERFSWidth = 7;

        SMERFSParams(String[] args) {
            try {
                String gapt;
                SMERFSConstraints colScoreSchema;
                String colScore;
                String wwidth = CmdParser.getSMERFSWindowWidth(args);
                if (wwidth != null) {
                    this.SMERFSWidth = Integer.parseInt(wwidth);
                }
                if ((colScore = CmdParser.getSMERFSColumnScore(args)) != null && (colScoreSchema = SMERFSConstraints.getSMERFSColumnScore(colScore)) == null) {
                    this.throwIllegalSMERFSParamException("Unrecognized parameter for SMERFS: " + colScore + "\n Valid values are " + Arrays.toString((Object[])SMERFSConstraints.values()));
                }
                if ((gapt = CmdParser.getSMERFSGapTreshold(args)) != null) {
                    this.SMERFSGapTreshold = Double.parseDouble(gapt);
                }
            }
            catch (NumberFormatException e) {
                this.throwIllegalSMERFSParamException(e.getMessage());
            }
        }

        private void throwIllegalSMERFSParamException(String message) {
            throw new IllegalArgumentException(message);
        }
    }
}

