/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.Alignment;
import compbio.data.sequence.AnnotatedSequence;
import compbio.data.sequence.ClustalAlignmentUtil;
import compbio.data.sequence.ConservationMethod;
import compbio.data.sequence.DisemblResultAnnot;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.MultiAnnotatedSequence;
import compbio.data.sequence.Score;
import compbio.data.sequence.UnknownFileFormatException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SequenceUtil {
    public static final Pattern WHITE_SPACE = Pattern.compile("\\s");
    public static final Pattern DIGIT = Pattern.compile("\\d");
    public static final Pattern NONWORD = Pattern.compile("\\W");
    public static final Pattern AA = Pattern.compile("[ARNDCQEGHILKMFPSTWYV]+", 2);
    public static final Pattern NON_AA = Pattern.compile("[^ARNDCQEGHILKMFPSTWYV]+", 2);
    public static final Pattern AMBIGUOUS_AA = Pattern.compile("[ARNDCQEGHILKMFPSTWYVXU]+", 2);
    public static final Pattern NUCLEOTIDE = Pattern.compile("[AGTCU]+", 2);
    public static final Pattern AMBIGUOUS_NUCLEOTIDE = Pattern.compile("[AGTCRYMKSWHBVDNU]+", 2);
    public static final Pattern NON_NUCLEOTIDE = Pattern.compile("[^AGTCU]+", 2);
    private static final String JRONN_WRONG_FORMAT_MESSAGE = "Jronn file must be in the following format:\n>sequence_name\n M\tV\tS\n0.43\t0.22\t0.65\nWhere first line is the sequence name,\nsecond line is the tab delimited sequence,\nthird line contains tab delimited disorder prediction values.\nNo lines are allowed between these three. Additionally, the number of  sequence residues must be equal to the number of the disorder values.";

    private SequenceUtil() {
    }

    public static boolean isNucleotideSequence(FastaSequence fastaSequence) {
        return SequenceUtil.isNonAmbNucleotideSequence(fastaSequence.getSequence());
    }

    public static boolean isNonAmbNucleotideSequence(String string) {
        if (DIGIT.matcher(string = SequenceUtil.cleanSequence(string)).find()) {
            return false;
        }
        if (NON_NUCLEOTIDE.matcher(string).find()) {
            return false;
        }
        Matcher matcher = NUCLEOTIDE.matcher(string);
        return matcher.find();
    }

    public static String cleanSequence(String string) {
        assert (string != null);
        Matcher matcher = WHITE_SPACE.matcher(string);
        string = matcher.replaceAll("").toUpperCase();
        return string;
    }

    public static String deepCleanSequence(String string) {
        string = SequenceUtil.cleanSequence(string);
        string = DIGIT.matcher(string).replaceAll("");
        string = NONWORD.matcher(string).replaceAll("");
        Pattern pattern = Pattern.compile("[_-]+");
        string = pattern.matcher(string).replaceAll("");
        return string;
    }

    public static boolean isProteinSequence(String string) {
        if (SequenceUtil.isNonAmbNucleotideSequence(string = SequenceUtil.cleanSequence(string))) {
            return false;
        }
        if (DIGIT.matcher(string).find()) {
            return false;
        }
        if (NON_AA.matcher(string).find()) {
            return false;
        }
        Matcher matcher = AA.matcher(string);
        return matcher.find();
    }

    public static boolean isAmbiguosProtein(String string) {
        if (SequenceUtil.isNonAmbNucleotideSequence(string = SequenceUtil.cleanSequence(string))) {
            return false;
        }
        if (DIGIT.matcher(string).find()) {
            return false;
        }
        if (NON_AA.matcher(string).find()) {
            return false;
        }
        if (AA.matcher(string).find()) {
            return false;
        }
        Matcher matcher = AMBIGUOUS_AA.matcher(string);
        return matcher.find();
    }

    public static void writeFasta(OutputStream outputStream, List<FastaSequence> list, int n) throws IOException {
        SequenceUtil.writeFastaKeepTheStream(outputStream, list, n);
        outputStream.close();
    }

    public static void writeFastaKeepTheStream(OutputStream outputStream, List<FastaSequence> list, int n) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        for (FastaSequence fastaSequence : list) {
            bufferedWriter.write(">" + fastaSequence.getId() + "\n");
            bufferedWriter.write(fastaSequence.getFormatedSequence(n));
            bufferedWriter.write("\n");
        }
        bufferedWriter.flush();
        outputStreamWriter.flush();
    }

    public static List<FastaSequence> readFasta(InputStream inputStream) throws IOException {
        String string;
        ArrayList<FastaSequence> arrayList = new ArrayList<FastaSequence>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"), 16000);
        Pattern pattern = Pattern.compile("//s+");
        String string2 = "";
        String string3 = null;
        do {
            if ((string = bufferedReader.readLine()) == null || string.startsWith(">")) {
                if (string3 != null) {
                    arrayList.add(new FastaSequence(string2.substring(1), string3));
                }
                string2 = string;
                string3 = "";
                continue;
            }
            String string4 = pattern.matcher(string).replaceAll("");
            string3 = string3 + string4;
        } while (string != null);
        bufferedReader.close();
        return arrayList;
    }

    public static void writeFasta(OutputStream outputStream, List<FastaSequence> list) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        for (FastaSequence fastaSequence : list) {
            bufferedWriter.write(fastaSequence.getOnelineFasta());
        }
        bufferedWriter.close();
        outputStreamWriter.close();
    }

    public static List<AnnotatedSequence> readJRonn(File file) throws IOException, UnknownFileFormatException {
        FileInputStream fileInputStream = new FileInputStream(file);
        List<AnnotatedSequence> list = SequenceUtil.readJRonn(fileInputStream);
        ((InputStream)fileInputStream).close();
        return list;
    }

    public static List<AnnotatedSequence> readJRonn(InputStream inputStream) throws IOException, UnknownFileFormatException {
        String string;
        ArrayList<AnnotatedSequence> arrayList = new ArrayList<AnnotatedSequence>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"), 16000);
        String string2 = "";
        do {
            if ((string = bufferedReader.readLine()) == null || string.isEmpty() || !string.startsWith(">")) continue;
            string2 = string.trim().substring(1);
            string = bufferedReader.readLine();
            String string3 = string.replace("\t", "");
            string = bufferedReader.readLine();
            String[] stringArray = string.split("\t");
            float[] fArray = SequenceUtil.convertToNumber(stringArray);
            if (fArray.length != string3.length()) {
                throw new UnknownFileFormatException("File does not look like Jronn horizontally formatted output file!\nJronn file must be in the following format:\n>sequence_name\n M\tV\tS\n0.43\t0.22\t0.65\nWhere first line is the sequence name,\nsecond line is the tab delimited sequence,\nthird line contains tab delimited disorder prediction values.\nNo lines are allowed between these three. Additionally, the number of  sequence residues must be equal to the number of the disorder values.");
            }
            arrayList.add(new AnnotatedSequence(string2, string3, fArray));
        } while (string != null);
        bufferedReader.close();
        return arrayList;
    }

    private static float[] convertToNumber(String[] stringArray) throws UnknownFileFormatException {
        float[] fArray = new float[stringArray.length];
        try {
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = Float.parseFloat(stringArray[i]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new UnknownFileFormatException(JRONN_WRONG_FORMAT_MESSAGE, numberFormatException.getCause());
        }
        return fArray;
    }

    public static final void closeSilently(Logger logger, Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, iOException.getLocalizedMessage(), iOException.getCause());
            }
        }
    }

    static List<MultiAnnotatedSequence<DisemblResultAnnot>> readDisembl(InputStream inputStream) throws IOException, UnknownFileFormatException {
        Scanner scanner = new Scanner(inputStream);
        scanner.useDelimiter("# RESIDUE COILS REM465 HOTLOOPS\n");
        if (!scanner.hasNext()) {
            throw new UnknownFileFormatException("In Disembl score format each seqeunce score is expected to start from the line: '# RESIDUE COILS REM465 HOTLOOPS\\n'. No such line was found!");
        }
        ArrayList<MultiAnnotatedSequence<DisemblResultAnnot>> arrayList = new ArrayList<MultiAnnotatedSequence<DisemblResultAnnot>>();
        int n = 0;
        while (scanner.hasNext()) {
            ++n;
            String string = scanner.next();
            Scanner scanner2 = new Scanner(string);
            StringBuffer stringBuffer = new StringBuffer();
            ArrayList<Float> arrayList2 = new ArrayList<Float>();
            ArrayList<Float> arrayList3 = new ArrayList<Float>();
            ArrayList<Float> arrayList4 = new ArrayList<Float>();
            MultiAnnotatedSequence<DisemblResultAnnot> multiAnnotatedSequence = new MultiAnnotatedSequence<DisemblResultAnnot>(DisemblResultAnnot.class);
            while (scanner2.hasNextLine()) {
                String string2 = scanner2.nextLine();
                Scanner scanner3 = new Scanner(string2);
                stringBuffer.append(scanner3.next());
                arrayList2.add(Float.valueOf(scanner3.nextFloat()));
                arrayList3.add(Float.valueOf(scanner3.nextFloat()));
                arrayList4.add(Float.valueOf(scanner3.nextFloat()));
                scanner3.close();
            }
            multiAnnotatedSequence.addAnnotation(DisemblResultAnnot.COILS, arrayList2);
            multiAnnotatedSequence.addAnnotation(DisemblResultAnnot.REM465, arrayList3);
            multiAnnotatedSequence.addAnnotation(DisemblResultAnnot.HOTLOOPS, arrayList4);
            scanner2.close();
            arrayList.add(multiAnnotatedSequence);
        }
        inputStream.close();
        return arrayList;
    }

    public static HashSet<Score> readAAConResults(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("InputStream with results must be provided");
        }
        HashSet<Score> hashSet = new HashSet<Score>();
        Scanner scanner = new Scanner(inputStream);
        scanner.useDelimiter("#");
        while (scanner.hasNext()) {
            String string = scanner.next();
            int n = string.indexOf(" ");
            assert (n > 0) : "Space is expected as delimited between method name and values!";
            String string2 = string.substring(0, n);
            ConservationMethod conservationMethod = ConservationMethod.getMethod(string2);
            assert (conservationMethod != null) : "Method " + string2 + " is not recognized! ";
            Scanner scanner2 = new Scanner(string.substring(n));
            ArrayList<Float> arrayList = new ArrayList<Float>();
            while (scanner2.hasNextDouble()) {
                Double d = scanner2.nextDouble();
                arrayList.add(Float.valueOf(d.floatValue()));
            }
            hashSet.add(new Score(conservationMethod, arrayList));
        }
        return hashSet;
    }

    public static List<FastaSequence> openInputStream(String string) throws IOException, UnknownFileFormatException {
        FileInputStream fileInputStream = new FileInputStream(string);
        FileInputStream fileInputStream2 = new FileInputStream(string);
        List<FastaSequence> list = null;
        if (ClustalAlignmentUtil.isValidClustalFile(fileInputStream)) {
            Alignment alignment = ClustalAlignmentUtil.readClustalFile(fileInputStream2);
            list = alignment.getSequences();
        } else {
            list = SequenceUtil.readFasta(fileInputStream2);
        }
        return list;
    }
}

