/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.data.sequence;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.biojava3.data.sequence.SequenceUtil;

@XmlAccessorType(value=XmlAccessType.FIELD)
public final class FastaSequence
implements Comparable<FastaSequence> {
    private String id;
    private String sequence;

    private FastaSequence() {
    }

    public FastaSequence(String id, String sequence) {
        this.id = id.trim();
        this.sequence = SequenceUtil.cleanSequence(sequence);
    }

    public String getId() {
        return this.id;
    }

    public String getSequence() {
        return this.sequence;
    }

    public static int countMatchesInSequence(String theString, String theRegExp) {
        Pattern p = Pattern.compile(theRegExp);
        Matcher m = p.matcher(theString);
        int cnt = 0;
        while (m.find()) {
            ++cnt;
        }
        return cnt;
    }

    public String getFormattedFasta() {
        return this.getFormatedSequence(80);
    }

    public String getOnelineFasta() {
        String fasta = ">" + this.getId() + "\n";
        fasta = String.valueOf(fasta) + this.getSequence() + "\n";
        return fasta;
    }

    public String getFormatedSequence(int width) {
        if (this.sequence == null) {
            return "";
        }
        assert (width >= 0) : "Wrong width parameter ";
        StringBuilder sb = new StringBuilder(this.sequence);
        int nchunks = this.sequence.length() / width;
        nchunks = (nchunks + this.sequence.length()) / width;
        int nlineCharcounter = 0;
        int i = 1;
        while (i <= nchunks) {
            int insPos = width * i + nlineCharcounter;
            if (sb.length() <= insPos) break;
            sb.insert(insPos, "\n");
            ++nlineCharcounter;
            ++i;
        }
        return sb.toString();
    }

    public int getLength() {
        return this.sequence.length();
    }

    public String toString() {
        return this.getOnelineFasta();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.sequence == null ? 0 : this.sequence.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FastaSequence other = (FastaSequence)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.sequence == null ? other.sequence != null : !this.sequence.equals(other.sequence));
    }

    @Override
    public int compareTo(FastaSequence o) {
        if (o == null || o.id == null) {
            return 1;
        }
        return this.getId().compareTo(o.id);
    }
}

