/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.data.sequence;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava3.data.sequence.FastaSequence;

public final class SequenceUtil {
    public static final Pattern WHITE_SPACE = Pattern.compile("\\s");
    public static final Pattern DIGIT = Pattern.compile("\\d");
    public static final Pattern NONWORD = Pattern.compile("\\W");
    public static final Pattern AA = Pattern.compile("[ARNDCQEGHILKMFPSTWYV]+", 2);
    public static final Pattern NON_AA = Pattern.compile("[^ARNDCQEGHILKMFPSTWYV]+", 2);
    public static final Pattern AMBIGUOUS_AA = Pattern.compile("[ARNDCQEGHILKMFPSTWYVXU]+", 2);
    public static final Pattern NUCLEOTIDE = Pattern.compile("[AGTCU]+", 2);
    public static final Pattern AMBIGUOUS_NUCLEOTIDE = Pattern.compile("[AGTCRYMKSWHBVDNU]+", 2);
    public static final Pattern NON_NUCLEOTIDE = Pattern.compile("[^AGTCU]+", 2);

    private SequenceUtil() {
    }

    public static boolean isNucleotideSequence(FastaSequence s) {
        return SequenceUtil.isNonAmbNucleotideSequence(s.getSequence());
    }

    public static boolean isNonAmbNucleotideSequence(String sequence) {
        if (DIGIT.matcher(sequence = SequenceUtil.cleanSequence(sequence)).find()) {
            return false;
        }
        if (NON_NUCLEOTIDE.matcher(sequence).find()) {
            return false;
        }
        Matcher DNAmatcher = NUCLEOTIDE.matcher(sequence);
        return DNAmatcher.find();
    }

    public static String cleanSequence(String sequence) {
        assert (sequence != null);
        Matcher m = WHITE_SPACE.matcher(sequence);
        sequence = m.replaceAll("").toUpperCase();
        return sequence;
    }

    public static String deepCleanSequence(String sequence) {
        sequence = SequenceUtil.cleanSequence(sequence);
        sequence = DIGIT.matcher(sequence).replaceAll("");
        sequence = NONWORD.matcher(sequence).replaceAll("");
        Pattern othernonSeqChars = Pattern.compile("[_-]+");
        sequence = othernonSeqChars.matcher(sequence).replaceAll("");
        return sequence;
    }

    public static boolean isProteinSequence(String sequence) {
        if (SequenceUtil.isNonAmbNucleotideSequence(sequence = SequenceUtil.cleanSequence(sequence))) {
            return false;
        }
        if (DIGIT.matcher(sequence).find()) {
            return false;
        }
        if (NON_AA.matcher(sequence).find()) {
            return false;
        }
        Matcher protmatcher = AA.matcher(sequence);
        return protmatcher.find();
    }

    public static boolean isAmbiguosProtein(String sequence) {
        if (SequenceUtil.isNonAmbNucleotideSequence(sequence = SequenceUtil.cleanSequence(sequence))) {
            return false;
        }
        if (DIGIT.matcher(sequence).find()) {
            return false;
        }
        if (NON_AA.matcher(sequence).find()) {
            return false;
        }
        if (AA.matcher(sequence).find()) {
            return false;
        }
        Matcher amb_prot = AMBIGUOUS_AA.matcher(sequence);
        return amb_prot.find();
    }

    public static void writeFasta(OutputStream outstream, List<FastaSequence> sequences, int width) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outstream);
        BufferedWriter fastawriter = new BufferedWriter(writer);
        for (FastaSequence fs : sequences) {
            fastawriter.write(fs.getFormatedSequence(width));
        }
        outstream.flush();
        fastawriter.close();
        writer.close();
    }

    public static List<FastaSequence> readFasta(InputStream inStream) throws IOException {
        String line;
        ArrayList<FastaSequence> seqs = new ArrayList<FastaSequence>();
        BufferedReader infasta = new BufferedReader(new InputStreamReader(inStream, "UTF8"), 16000);
        Pattern pattern = Pattern.compile("//s+");
        String sname = "";
        String seqstr = null;
        do {
            if ((line = infasta.readLine()) == null || line.startsWith(">")) {
                if (seqstr != null) {
                    seqs.add(new FastaSequence(sname.substring(1), seqstr));
                }
                sname = line;
                seqstr = "";
                continue;
            }
            String subseq = pattern.matcher(line).replaceAll("");
            seqstr = String.valueOf(seqstr) + subseq;
        } while (line != null);
        infasta.close();
        return seqs;
    }

    public static void writeFasta(OutputStream os, List<FastaSequence> sequences) throws IOException {
        OutputStreamWriter outWriter = new OutputStreamWriter(os);
        BufferedWriter fasta_out = new BufferedWriter(outWriter);
        for (FastaSequence fs : sequences) {
            fasta_out.write(fs.getOnelineFasta());
        }
        fasta_out.close();
        outWriter.close();
    }
}

