/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.ronn;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.biojava3.ronn.NullOutputStream;
import org.biojava3.ronn.ORonn;

final class InputParameters {
    static final String inputKey = "-i=";
    static final String outputKey = "-o=";
    static final String statKey = "-s=";
    static final String disorderKey = "-d=";
    static final String formatKey = "-f=";
    static final String threadKey = "-n=";
    private File input;
    private File output;
    private File statistics;
    private ORonn.ResultLayout format;
    private float disorder = 0.53f;
    private int threadNum = Runtime.getRuntime().availableProcessors();
    private volatile PrintWriter outWriter;
    private volatile PrintWriter statWriter;

    InputParameters() {
    }

    File setFilePrm(String filename, String key) throws IOException {
        File file = null;
        if (filename == null) {
            throw new IllegalArgumentException("File name is not provided! ");
        }
        if ((filename = filename.trim()).toLowerCase().startsWith(key)) {
            file = new File(filename.substring(key.length()));
            if (!file.exists()) {
                file.createNewFile();
            }
            if (key.equals(inputKey)) {
                this.input = file;
            }
            if (key.equals(outputKey)) {
                this.output = file;
            }
            if (key.equals(statKey)) {
                this.statistics = file;
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrintWriter getOutputWriter() throws FileNotFoundException {
        if (this.outWriter == null) {
            InputParameters inputParameters = this;
            synchronized (inputParameters) {
                if (this.outWriter == null) {
                    this.outWriter = this.output != null ? new PrintWriter(this.output) : new PrintWriter(System.out);
                }
            }
        }
        return this.outWriter;
    }

    ORonn.ResultLayout parseFormat(String format) {
        if (format == null) {
            return ORonn.ResultLayout.VERTICAL;
        }
        if ((format = format.trim().substring(formatKey.length())).toUpperCase().equals("V")) {
            return ORonn.ResultLayout.VERTICAL;
        }
        if (format.toUpperCase().equals("H")) {
            return ORonn.ResultLayout.HORIZONTAL;
        }
        throw new IllegalArgumentException("Unrecognised format: '" + format + "' Output format for results must be either H or V.");
    }

    int parseThreadNum(String key) {
        key = key.trim().substring(threadKey.length());
        int nthreads = Integer.parseInt(key);
        return nthreads;
    }

    public String toString() {
        String def = " [default]";
        String newLine = System.getProperty("line.separator");
        String value = "input=" + this.input + newLine;
        value = this.output != null ? String.valueOf(value) + "output=" + this.output + newLine : String.valueOf(value) + "output= standard out" + newLine;
        value = this.statistics != null ? String.valueOf(value) + "statistics=" + this.statistics + newLine : String.valueOf(value) + "statistics= not kept" + newLine;
        value = String.valueOf(value) + "disorder=" + this.getDisorder();
        if (this.disorder == 0.53f) {
            value = String.valueOf(value) + " [default]";
        }
        value = String.valueOf(value) + newLine;
        value = String.valueOf(value) + "thread number=" + this.getThreadNum() + newLine;
        value = String.valueOf(value) + "format=" + (Object)((Object)this.getFormat());
        if (this.format == null) {
            value = String.valueOf(value) + " [default]";
        }
        return value;
    }

    ORonn.ResultLayout getFormat() {
        return this.format == null ? ORonn.ResultLayout.VERTICAL : this.format;
    }

    float getDisorder() {
        return this.disorder;
    }

    void setDisorder(String prm) {
        float disorder = Float.parseFloat(prm.substring(disorderKey.length()));
        if (disorder > 0.0f || disorder <= 1.0f) {
            this.disorder = disorder;
        }
    }

    void setFormat(String prm) {
        this.format = this.parseFormat(prm);
    }

    void setThreadNum(String prm) {
        int procNum = this.threadNum;
        int tnum = this.parseThreadNum(prm);
        if (tnum != 0) {
            if (tnum < 1 || tnum > procNum * 2) {
                throw new IllegalArgumentException("Number of threads must be between 1 and 2 x number of cores available on the executing machine");
            }
            this.threadNum = tnum;
        }
    }

    private void initStatWriter() throws IOException {
        this.statWriter = this.statistics != null ? new PrintWriter((Writer)new FileWriter(this.statistics), true) : new PrintWriter(new NullOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintWriter getStatWriter() throws IOException {
        if (this.statWriter == null) {
            InputParameters inputParameters = this;
            synchronized (inputParameters) {
                if (this.statWriter == null) {
                    this.initStatWriter();
                }
            }
        }
        return this.statWriter;
    }

    File getInput() {
        return this.input;
    }

    int getThreadNum() {
        return this.threadNum;
    }
}

