/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.ronn;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.biojava3.data.sequence.FastaSequence;
import org.biojava3.data.sequence.SequenceUtil;
import org.biojava3.ronn.ModelLoader;
import org.biojava3.ronn.ORonn;

public class Jronn {
    private static final ModelLoader loader = new ModelLoader();

    static {
        try {
            loader.loadModels();
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Fails to load models!" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Fails to load models!" + e.getMessage(), e);
        }
    }

    public static float[] getDisorderScores(FastaSequence sequence) {
        return Jronn.predictSerial(sequence);
    }

    private static float[] predictSerial(FastaSequence fsequence) {
        ORonn.validateSequenceForRonn(fsequence);
        float[] disorder = null;
        try {
            ORonn ronn = new ORonn(fsequence, loader);
            disorder = ronn.call().getMeanScores();
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Jronn fails to load models " + e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Jronn fails to load models " + e.getLocalizedMessage(), e);
        }
        return disorder;
    }

    public static Range[] getDisorder(FastaSequence sequence) {
        float[] scores = Jronn.getDisorderScores(sequence);
        return Jronn.scoresToRanges(scores, 0.5f);
    }

    public static Range[] scoresToRanges(float[] scores, float probability) {
        assert (scores != null && scores.length > 0);
        assert (probability > 0.0f && probability < 1.0f);
        int count = 0;
        int regionLen = 0;
        ArrayList<Range> ranges = new ArrayList<Range>();
        float[] fArray = scores;
        int n = scores.length;
        int n2 = 0;
        while (n2 < n) {
            float score = fArray[n2];
            ++count;
            if ((score = (float)((double)Math.round((double)score * 100.0) / 100.0)) > probability) {
                ++regionLen;
            } else {
                if (regionLen > 0) {
                    ranges.add(new Range(count - regionLen, count - 1));
                }
                regionLen = 0;
            }
            ++n2;
        }
        if (regionLen > 1) {
            ranges.add(new Range(count - regionLen + 1, count));
        }
        return ranges.toArray(new Range[ranges.size()]);
    }

    public static Map<FastaSequence, float[]> getDisorderScores(List<FastaSequence> sequences) {
        TreeMap<FastaSequence, float[]> results = new TreeMap<FastaSequence, float[]>();
        for (FastaSequence fsequence : sequences) {
            results.put(fsequence, Jronn.predictSerial(fsequence));
        }
        return results;
    }

    public static Map<FastaSequence, Range[]> getDisorder(List<FastaSequence> sequences) {
        TreeMap<FastaSequence, Range[]> disorderRanges = new TreeMap<FastaSequence, Range[]>();
        for (FastaSequence fs : sequences) {
            disorderRanges.put(fs, Jronn.getDisorder(fs));
        }
        return disorderRanges;
    }

    public static Map<FastaSequence, Range[]> getDisorder(String fastaFile) throws FileNotFoundException, IOException {
        List<FastaSequence> sequences = SequenceUtil.readFasta(new FileInputStream(fastaFile));
        return Jronn.getDisorder(sequences);
    }

    public static class Range {
        final int from;
        final int to;

        public Range(int from, int to) {
            assert (from >= 0);
            assert (from < to);
            this.from = from;
            this.to = to;
        }

        public String toString() {
            return "Range From:" + this.from + "\t" + "to: " + this.to + "\n";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.from;
            result = 31 * result + this.to;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Range other = (Range)obj;
            if (this.from != other.from) {
                return false;
            }
            return this.to == other.to;
        }
    }
}

