/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.ronn;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.biojava3.ronn.RonnConstraint;

public final class ModelLoader {
    private static final Map<Integer, Model> models = new HashMap<Integer, Model>();

    public Model getModel(int modelNum) {
        return models.get(modelNum);
    }

    void loadModels() throws NumberFormatException, IOException {
        int i = 0;
        while (i < 10) {
            BufferedReader bfr = new BufferedReader(new InputStreamReader(ModelLoader.class.getResourceAsStream("model" + i + ".rec"), "ISO-8859-1"));
            String line = null;
            Scanner scan = new Scanner(bfr);
            scan.useDelimiter("\n");
            int numberOfSeqs = scan.nextInt();
            Model model = new Model(i, numberOfSeqs);
            scan.nextInt();
            int j = 0;
            while (j < numberOfSeqs) {
                line = scan.next();
                char[] dbseq = line.trim().toCharArray();
                assert (dbseq.length < Short.MAX_VALUE);
                model.Length[j] = (short)dbseq.length;
                int dResidue = 0;
                while (dResidue < dbseq.length) {
                    model.dbAA[j][dResidue] = RonnConstraint.INDEX[dbseq[dResidue] - 65];
                    assert (model.dbAA[j][dResidue] >= 0 && model.dbAA[j][dResidue] <= 19);
                    ++dResidue;
                }
                model.W[j] = scan.nextFloat();
                ++j;
            }
            models.put(model.modelNum, model);
            bfr.close();
            ++i;
        }
    }

    public static void main(String[] args) throws NumberFormatException, IOException {
        ModelLoader loader = new ModelLoader();
        loader.loadModels();
        System.out.println(models.get(0));
        System.out.println(models.get(9));
        System.out.println(models.size());
    }

    public static class Model {
        final short[][] dbAA;
        final short[] Length;
        final float[] W;
        int numOfDBAAseq;
        int modelNum = -1;

        public Model(int modelNum, int numberofSequence) {
            this.modelNum = modelNum;
            this.numOfDBAAseq = numberofSequence;
            this.dbAA = new short[numberofSequence][190];
            this.Length = new short[numberofSequence];
            this.W = new float[numberofSequence];
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.Length);
            result = 31 * result + Arrays.hashCode(this.W);
            result = 31 * result + Arrays.hashCode((Object[])this.dbAA);
            result = 31 * result + this.modelNum;
            result = 31 * result + this.numOfDBAAseq;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Model other = (Model)obj;
            if (!Arrays.equals(this.Length, other.Length)) {
                return false;
            }
            if (!Arrays.equals(this.W, other.W)) {
                return false;
            }
            if (!Arrays.equals((Object[])this.dbAA, (Object[])other.dbAA)) {
                return false;
            }
            if (this.modelNum != other.modelNum) {
                return false;
            }
            return this.numOfDBAAseq == other.numOfDBAAseq;
        }

        public String toString() {
            return "Model [modelNum=" + this.modelNum + ", numOfDBAAseq=" + this.numOfDBAAseq + "]";
        }
    }

    public static final class Threshold {
        final float mu0;
        final float mu1;
        final float sigma0;
        final float sigma1;

        public Threshold(int modelNum) {
            float[] values = RonnConstraint.Threshold.getTreshold(modelNum);
            this.mu0 = values[0];
            this.mu1 = values[1];
            this.sigma0 = values[2];
            this.sigma1 = values[3];
        }
    }
}

