/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.ronn;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import org.biojava3.ronn.ModelLoader;
import org.biojava3.ronn.RonnConstraint;

public final class ORonnModel {
    private final float disorder_weight;
    private static final int AA_ALPHABET = 19;
    private static final int maxR = 110;
    private static final float coef = 1.0f;
    private final short[] seqAA;
    private final char[] query;
    private final ModelLoader.Model model;
    private float[] scores = null;

    final float[] detect() {
        int r;
        float est;
        this.scores = new float[this.query.length];
        float[][] Z = new float[this.seqAA.length][110];
        int[] Q = new int[this.seqAA.length];
        ModelLoader.Threshold thold = new ModelLoader.Threshold(this.model.modelNum);
        int sResidue = 0;
        while (sResidue <= this.query.length - 19) {
            est = 0.0f;
            int dIndex = 0;
            while (dIndex < this.model.numOfDBAAseq) {
                float[] rho = this.align(sResidue, dIndex);
                est = (float)((double)est + (double)this.model.W[dIndex] * Math.exp((rho[1] - rho[0]) / rho[0]));
                ++dIndex;
            }
            float fOrder = (float)(Math.exp(-0.5 * Math.pow(est - thold.mu0, 2.0) / (double)thold.sigma0) / (Math.sqrt(6.28) * (double)thold.sigma0));
            float fDisor = (float)(Math.exp(-0.5 * Math.pow(est - thold.mu1, 2.0) / (double)thold.sigma1) / (Math.sqrt(6.28) * (double)thold.sigma1));
            float pDisor = (float)((double)(this.disorder_weight * fDisor) / ((1.0 - (double)this.disorder_weight) * (double)fOrder + (double)(this.disorder_weight * fDisor)));
            r = sResidue;
            while (r < sResidue + 19) {
                Z[r][Q[r]] = pDisor;
                int n = r++;
                Q[n] = Q[n] + 1;
            }
            ++sResidue;
        }
        sResidue = 0;
        while (sResidue < this.query.length) {
            est = 0.0f;
            float[] zRow = Z[sResidue];
            int numOfIterations = Q[sResidue];
            r = 0;
            while (r < numOfIterations) {
                est += zRow[r];
                ++r;
            }
            this.scores[sResidue] = est / (float)numOfIterations;
            ++sResidue;
        }
        return this.scores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getScores(File outfile) throws FileNotFoundException {
        PrintWriter output = new PrintWriter(outfile);
        if (this.scores == null) {
            ORonnModel oRonnModel = this;
            synchronized (oRonnModel) {
                if (this.scores == null) {
                    this.detect();
                }
            }
        }
        int i = 0;
        while (i < this.scores.length) {
            output.printf("%c\t%f\n", Character.valueOf(this.query[i]), Float.valueOf(this.scores[i]));
            ++i;
        }
        output.close();
    }

    private final float[] align(int sResidue, int dIndex) {
        int r;
        float maxScore = -1000000.0f;
        float rho1 = 0.0f;
        int maxIdx = 0;
        float rho0 = 0.0f;
        short[] dbAARow = this.model.dbAA[dIndex];
        int numOfIterations = this.model.Length[dIndex] - 19;
        int dResidue = 0;
        while (dResidue <= numOfIterations) {
            rho1 = 0.0f;
            r = 0;
            while (r < 19) {
                rho1 += (float)RonnConstraint.Blosum62[this.seqAA[sResidue + r]][dbAARow[dResidue + r]];
                ++r;
            }
            if (rho1 > maxScore) {
                maxScore = rho1;
                maxIdx = dResidue;
            }
            ++dResidue;
        }
        r = 0;
        while (r < 19) {
            rho0 += (float)RonnConstraint.Blosum62[dbAARow[maxIdx + r]][dbAARow[maxIdx + r]];
            ++r;
        }
        return new float[]{rho0, maxScore};
    }

    public ORonnModel(String sequence, ModelLoader.Model model, float disorder) throws NumberFormatException {
        this.disorder_weight = disorder;
        this.model = model;
        this.query = sequence.toCharArray();
        this.seqAA = new short[this.query.length];
        assert (model != null);
        assert (model.numOfDBAAseq > 0);
        int sResidue = 0;
        while (sResidue < sequence.length()) {
            this.seqAA[sResidue] = RonnConstraint.INDEX[this.query[sResidue] - 65];
            if (this.seqAA[sResidue] < 0 || this.seqAA[sResidue] > 19) {
                System.err.printf("seqAA[sResidue]=%d(%c)\n", this.seqAA[sResidue], Character.valueOf(this.query[sResidue]));
                System.exit(1);
            }
            ++sResidue;
        }
    }
}

