/////////////////////////////////////////////////////////////////
//  Matrix.h
//
//  Specifies scoring matrices and their structure
//  
//
//
/////////////////////////////////////////////////////////////////

#ifndef _MSA_READ_MATRIX_H
#define _MSA_READ_MATRIX_H

typedef struct {
	char monomers[26]; /* amino or nucleic acid order */
	float matrix[676]; /* entries of the score matix, 26*26=676 */
} score_matrix;

//default protein sequence scoring matrix as well as default scoring matrix of the PROBALIGN
//also used when -prot option is used

score_matrix gonnet_160 = { "ABCDEFGHIKLMNPQRSTVWXYZ",

{ 4.6, 0.0, 0.0, 0.3, 0.0, 13.5, -1.1, 0.0, -5.3, 7.0, -0.4, 0.0, -5.2, 3.4,
		5.9, -3.8, 0.0, -1.8, -7.0, -6.2, 9.1, 0.2, 0.0, -3.4, -0.7, -2.1, -7.6,
		8.2, -1.8, 0.0, -2.3, -0.1, -0.1, -0.7, -2.7, 9.3, -1.8, 0.0, -2.5,
		-6.2, -4.3, 0.3, -7.0, -3.7, 5.9, -1.2, 0.0, -4.8, -0.1, 1.3, -5.3,
		-2.4, 0.2, -3.5, 5.5, -2.2, 0.0, -2.9, -6.5, -4.5, 1.9, -6.7, -3.2, 3.0,
		-3.4, 5.7, -1.2, 0.0, -1.9, -5.0, -3.1, 1.4, -5.2, -2.1, 2.9, -2.1, 3.4,
		7.6, -1.2, 0.0, -3.1, 2.6, 0.5, -4.7, -0.2, 1.5, -4.4, 0.8, -4.8, -3.6,
		6.5, -0.1, 0.0, -5.2, -1.9, -1.4, -5.8, -3.0, -2.2, -4.3, -1.6, -3.5,
		-4.2, -2.2, 9.6, -0.7, 0.0, -4.2, 0.6, 2.3, -4.1, -2.1, 1.7, -3.2, 2.0,
		-2.4, -1.2, 0.5, -0.8, 5.6, -1.6, 0.0, -3.5, -1.6, -0.3, -5.3, -2.1,
		0.3, -4.1, 3.5, -3.5, -2.9, -0.4, -2.1, 1.7, 7.1, 1.6, 0.0, -0.2, 0.0,
		-0.3, -4.5, -0.1, -0.8, -3.3, -0.4, -3.6, -2.3, 1.1, 0.0, -0.2, -0.9,
		4.4, 0.5, 0.0, -1.4, -0.6, -0.8, -3.6, -2.4, -0.8, -1.2, -0.2, -2.4,
		-1.1, 0.3, -0.4, -0.4, -0.9, 2.3, 5.0, 0.1, 0.0, -0.6, -4.9, -3.0, -0.8,
		-5.2, -3.5, 4.0, -3.0, 1.7, 1.4, -3.8, -3.2, -2.7, -3.4, -2.0, 0.0, 5.3,
		-5.5, 0.0, -2.1, -7.8, -6.4, 3.2, -5.5, -1.9, -3.4, -5.4, -2.0, -2.2,
		-5.5, -7.4, -4.0, -2.4, -4.7, -5.4, -4.5, 15.8, 0.0, 0.0, 0.0, 0.0, 0.0,
		0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
		0.0, 0.0, -3.7, 0.0, -1.3, -4.2, -4.4, 5.6, -6.0, 2.7, -2.0, -3.5, -1.1,
		-1.3, -2.2, -4.8, -2.9, -2.9, -2.8, -3.2, -2.4, 3.8, 0.0, 10.0, 0.0,
		0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
		0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 }

};

//normalized blosum_62 scoring matrix for computing protein sequence similarity
score_matrix normalized_blosum_62 = {

"ABCDEFGHIKLMNPQRSTVWXYZ",
{
0.533333333,																																											
0.133333333,0.533333333,																																									
0.266666667,0.066666667,0.866666667,																																							
0.133333333,0.533333333,0.066666667,0.666666667,																																					
0.2,0.333333333,0,0.4,0.6,																																			
0.133333333,0.066666667	,0.133333333,0.066666667,0.066666667,0.666666667,																																	
0.266666667,0.2	,0.066666667,0.2,0.133333333,0.066666667,0.666666667,																															
0.133333333,0.266666667	,0.066666667,0.2,0.266666667,0.2,0.133333333,0.8,																												
0.2,0.066666667	,0.2,0.066666667,0.066666667,0.266666667,0,0.066666667,0.533333333,																											
0.2,0.266666667	,0.066666667,0.2,0.333333333,0.066666667,0.133333333,0.2,0.066666667,0.6,																									
0.2,0,0.2,0,0.066666667,0.266666667	,0,0.066666667	,0.4,0.133333333,0.533333333,																				
0.2,0.066666667	,0.2,0.066666667,0.133333333,0.266666667,0.066666667	,0.133333333,0.333333333,0.2,0.4,0.6,																
0.133333333,0.466666667	,0.066666667,0.333333333,0.266666667,0.066666667,0.266666667,0.333333333,0.066666667,	0.266666667,0.066666667	,0.133333333,0.666666667,																
0.2,0.133333333	,0.066666667,0.2,0.2,	0,0.133333333,	0.133333333,0.066666667	,0.2,0.066666667,0.133333333,	0.133333333,0.733333333	,																
0.2,0.266666667	,0.066666667,0.266666667,0.4,0.066666667,0.133333333,	0.266666667,0.066666667	,0.333333333,	0.133333333,0.266666667	,0.266666667,0.2,0.6,										
0.2,0.2	,0.066666667,0.133333333,0.266666667,0.066666667,0.133333333,0.266666667,0.066666667,0.4,	0.133333333,0.2,0.266666667,0.133333333,0.333333333,0.6	,											
0.333333333,0.266666667	,0.2,0.266666667,0.266666667,0.133333333,0.266666667,0.2,0.133333333,	0.266666667,0.133333333	,0.2,0.333333333,0.2,0.266666667,0.2,0.533333333,										
0.266666667,	0.2,0.2,0.2,	0.2,	0.133333333,0.133333333,0.133333333,0.2	,0.2,0.2,0.2,0.266666667,0.2,	0.2,0.2	,0.333333333,0.6,		
0.266666667,0.066666667	,0.2,0.066666667,0.133333333,0.2,0.066666667,0.066666667,0.466666667,0.133333333,	0.333333333,0.333333333,	0.066666667,0.133333333,0.133333333	,0.066666667,	0.133333333,	0.266666667,	0.533333333,
0.066666667,0,0.133333333,0,0.066666667	,0.333333333	,	0.133333333,	0.133333333,0.066666667	,	0.066666667,	0.133333333	,0.2	,	0,	0,0.133333333	,0.066666667	,	0.066666667	,	0.133333333	,	0.066666667	,	1,			
0.266666667,0.2	,0.133333333	,	0.2	,	0.2	,	0.2	,	0.2,0.2	,	0.2,0.2	,0.2	,	0.2	,	0.2	,	0.133333333,	0.2	,0.2	,	0.266666667	,	0.266666667,0.2	,0.133333333,	0.2	,			
0.133333333,0.066666667	,	0.133333333	,	0.066666667	,	0.133333333	,	0.466666667,	0.066666667,0.4	,0.2,	0.133333333	,	0.2	,	0.2,	0.133333333	,	0.066666667,	0.2,	0.133333333,0.133333333	,0.133333333	,	0.2	,	0.4,0.2	,	0.733333333,
0.2,0.333333333	,0.066666667	,0.333333333	,	0.533333333	,	0.066666667,	0.133333333,	0.266666667,0.066666667	,0.333333333	,	0.066666667,	0.2,	0.266666667,	0.2	,	0.466666667,0.266666667	,0.266666667,	0.2	,	0.133333333,	0.066666667	,	0.2,0.133333333	,0.533333333

}
};

//normalized blosum_30 scoring matrix for computing protein sequence similarity
score_matrix normalized_blosum_30 = {

"ABCDEFGHIKLMNPQRSTVWXYZ",
{
0.407407407	,																																											
0.259259259	,	0.444444444	,																																									
0.148148148	,	0.185185185	,	0.888888889	,																																							
0.259259259	,	0.444444444	,	0.148148148	,	0.592592593	,																																					
0.259259259	,	0.259259259	,	0.296296296	,	0.296296296	,	0.481481481	,																																			
0.185185185	,	0.148148148	,	0.148148148	,	0.074074074	,	0.111111111	,	0.62962963	,																																	
0.259259259	,	0.259259259	,	0.111111111	,	0.222222222	,	0.185185185	,	0.148148148	,	0.555555556	,																															
0.185185185	,	0.185185185	,	0.074074074	,	0.185185185	,	0.259259259	,	0.148148148	,	0.148148148	,	0.777777778	,																													
0.259259259	,	0.185185185	,	0.185185185	,	0.111111111	,	0.148148148	,	0.259259259	,	0.222222222	,	0.185185185	,	0.481481481	,																											
0.259259259	,	0.259259259	,	0.148148148	,	0.259259259	,	0.333333333	,	0.222222222	,	0.222222222	,	0.185185185	,	0.185185185	,	0.407407407	,																									
0.222222222	,	0.222222222	,	0.259259259	,	0.222222222	,	0.222222222	,	0.333333333	,	0.185185185	,	0.222222222	,	0.333333333	,	0.185185185	,	0.407407407	,																							
0.296296296	,	0.185185185	,	0.185185185	,	0.148148148	,	0.222222222	,	0.185185185	,	0.185185185	,	0.333333333	,	0.296296296	,	0.333333333	,	0.333333333	,	0.481481481	,																					
0.259259259	,	0.407407407	,	0.222222222	,	0.296296296	,	0.222222222	,	0.222222222	,	0.259259259	,	0.222222222	,	0.259259259	,	0.259259259	,	0.185185185	,	0.259259259	,	0.555555556	,																			
0.222222222	,	0.185185185	,	0.148148148	,	0.222222222	,	0.296296296	,	0.111111111	,	0.222222222	,	0.296296296	,	0.148148148	,	0.296296296	,	0.148148148	,	0.111111111	,	0.148148148	,	0.666666667	,																	
0.296296296	,	0.222222222	,	0.185185185	,	0.222222222	,	0.333333333	,	0.148148148	,	0.185185185	,	0.259259259	,	0.185185185	,	0.259259259	,	0.185185185	,	0.222222222	,	0.222222222	,	0.259259259	,	0.555555556	,															
0.222222222	,	0.185185185	,	0.185185185	,	0.222222222	,	0.222222222	,	0.222222222	,	0.185185185	,	0.222222222	,	0.148148148	,	0.296296296	,	0.185185185	,	0.259259259	,	0.185185185	,	0.222222222	,	0.37037037	,	0.555555556	,													
0.296296296	,	0.259259259	,	0.185185185	,	0.259259259	,	0.259259259	,	0.222222222	,	0.259259259	,	0.222222222	,	0.222222222	,	0.259259259	,	0.185185185	,	0.185185185	,	0.259259259	,	0.222222222	,	0.222222222	,	0.222222222	,	0.407407407	,											
0.296296296	,	0.259259259	,	0.185185185	,	0.222222222	,	0.185185185	,	0.185185185	,	0.185185185	,	0.185185185	,	0.259259259	,	0.222222222	,	0.259259259	,	0.259259259	,	0.296296296	,	0.259259259	,	0.259259259	,	0.148148148	,	0.333333333	,	0.444444444	,									
0.296296296	,	0.185185185	,	0.185185185	,	0.185185185	,	0.148148148	,	0.296296296	,	0.148148148	,	0.148148148	,	0.407407407	,	0.185185185	,	0.296296296	,	0.259259259	,	0.185185185	,	0.111111111	,	0.148148148	,	0.222222222	,	0.222222222	,	0.296296296	,	0.444444444	,							
0.074074074	,	0.074074074	,	0.185185185	,	0.111111111	,	0.222222222	,	0.296296296	,	0.296296296	,	0.074074074	,	0.148148148	,	0.185185185	,	0.185185185	,	0.148148148	,	0	,	0.148148148	,	0.222222222	,	0.259259259	,	0.148148148	,	0.074074074	,	0.148148148	,	1	,					
0.259259259	,	0.222222222	,	0.185185185	,	0.222222222	,	0.222222222	,	0.222222222	,	0.222222222	,	0.222222222	,	0.259259259	,	0.259259259	,	0.259259259	,	0.259259259	,	0.259259259	,	0.222222222	,	0.259259259	,	0.222222222	,	0.259259259	,	0.259259259	,	0.259259259	,	0.185185185	,	0.222222222	,			
0.111111111	,	0.148148148	,	0.037037037	,	0.222222222	,	0.185185185	,	0.37037037	,	0.148148148	,	0.259259259	,	0.222222222	,	0.222222222	,	0.37037037	,	0.222222222	,	0.111111111	,	0.185185185	,	0.222222222	,	0.259259259	,	0.185185185	,	0.222222222	,	0.296296296	,	0.444444444	,	0.222222222	,	0.592592593	,	
0.259259259	,	0.259259259	,	0.259259259	,	0.259259259	,	0.444444444	,	0.111111111	,	0.185185185	,	0.259259259	,	0.148148148	,	0.296296296	,	0.222222222	,	0.222222222	,	0.222222222	,	0.259259259	,	0.407407407	,	0.259259259	,	0.222222222	,	0.222222222	,	0.148148148	,	0.222222222	,	0.259259259	,	0.185185185	,	0.407407407

}
};

//default nucleotide sequence scoring matrix
//used when -nuc option is used
score_matrix nuc_simple = {

"ABCDGHKMNRSTUVWXY",

{ 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0 }

//Ribosum85-60
		/*
		 {
		 2.22,
		 0,  0,
		 -1.86,  0,  1.16,
		 0,  0,  0,  0,
		 -1.46,  0,  -2.48,  0,  1.03,
		 0,  0,  0,  0,  0,  0,
		 0,  0,  0,  0,  0,  0,  0,
		 0,  0,  0,  0,  0,  0,  0,  0,
		 0,  0,  0,  0,  0,  0,  0,  0,  0,
		 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
		 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
		 -1.39,  0,  -1.05,  0,  -1.74,  0,  0,  0,  0,  0,  0,  1.65,
		 -1.39,  0,  -1.05,  0,  -1.74,  0,  0,  0,  0,  0,  0,  0,  1.65,
		 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
		 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
		 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
		 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
		 }
		 */

		};

#endif
