/*
  File autogenerated by gengetopt version 2.22.5
  generated with the following command:
  gengetopt -i RNAsubopt.ggo --file-name=RNAsubopt_cmdl --include-getopt --default-optional --func-name=RNAsubopt_cmdline_parser --arg-struct-name=RNAsubopt_args_info

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif


#include "RNAsubopt_cmdl.h"

const char *RNAsubopt_args_info_purpose = "calculate suboptimal secondary structures of RNAs";

const char *RNAsubopt_args_info_usage = "Usage: RNAsubopt [OPTIONS]...";

const char *RNAsubopt_args_info_description = "reads RNA sequences from stdin and (in the default -e mode) calculates all \nsuboptimal secondary structures within a user defined energy range above the \nminimum free energy (mfe). It prints the suboptimal structures in dot-bracket \nnotation followed by the energy in kcal/mol to stdout. Be careful, the number \nof structures returned grows exponentially with both sequence length and energy \nrange.\n\nAlternatively, when used with the -p option, RNAsubopt produces Boltzmann \nweighted samples of secondary structures.\n";

const char *RNAsubopt_args_info_detailed_help[] = {
  "  -h, --help                    Print help and exit",
  "      --detailed-help           Print help, including all details and hidden \n                                  options, and exit",
  "      --full-help               Print help, including hidden options, and exit",
  "  -V, --version                 Print version and exit",
  "\nGeneral Options:",
  "  Below are command line options which alter the general behavior of this \n  program\n",
  "  -C, --constraint              Calculate structures subject to constraints.\n                                    (default=off)",
  "  The program reads first the sequence, then a string containing constraints on \n  the structure encoded with the symbols:\n\n  . (no constraint for this base)\n\n  | (the corresponding base has to be paired\n\n  x (the base is unpaired)\n\n  < (base i is paired with a base j>i)\n\n  > (base i is paired with a base j<i)\n\n  and matching brackets ( ) (base i pairs base j)\n\n  With the exception of \"|\", constraints will disallow all pairs conflicting \n  with the constraint. This is usually sufficient to enforce the constraint, \n  but occasionally a base may stay unpaired in spite of constraints. PF folding \n  ignores constraints of type \"|\".\n\n",
  "      --noconv                  Do not automatically substitude nucleotide \n                                  \"T\" with \"U\"\n\n                                    (default=off)",
  "\nAlgorithms:",
  "  Select the algorithms which should be applied to the given RNA sequence.\n",
  "  -e, --deltaEnergy=range       Compute suboptimal structures with energy in a \n                                  certain range of the optimum (kcal/mol). \n                                  Default is calculation of mfe structure only.\n\n",
  "      --deltaEnergyPost=range   Only print structures with energy within range \n                                  of the mfe after post reevaluation of \n                                  energies.\n",
  "  Useful in conjunction with -logML, -d1 or -d3: while the -e option specifies \n  the range before energies are re-evaluated, this option specifies the maximum \n  energy after re-evaluation.\n\n",
  "  -s, --sorted                  Sort the suboptimal structures by energy.\n                                    (default=off)",
  "  Since the sort in is done in memory, this becomes impractical when the number \n  of structures produced goes into millions. In such cases better pipe the \n  output through \"sort +1n\".\n\n",
  "  -p, --stochBT=number          Instead of producing all suboptimals in an \n                                  energy range, produce a random sample of \n                                  suboptimal structures, drawn with \n                                  probabilities equal to their Boltzmann \n                                  weights via stochastic backtracking in the \n                                  partition function. The -e and -p options are \n                                  mutually exclusive.\n\n",
  "  -S, --pfScale=scaling factor  In the calculation of the pf use scale*mfe as \n                                  an estimate for the ensemble free energy \n                                  (used to avoid overflows). Needed by \n                                  stochastic backtracking\n",
  "  The default is 1.07, useful values are 1.0 to 1.2. Occasionally needed for \n  long sequences.\n  You can also recompile the program to use double precision (see the README \n  file).\n\n",
  "  -c, --circ                    Assume a circular (instead of linear) RNA \n                                  molecule.\n\n                                    (default=off)",
  "  -D, --dos                     Compute density of states instead of secondary \n                                  structures\n                                    (default=off)",
  "  This option enables the evaluation of the number of secondary structures in \n  certain energy bands arround the MFE.\n",
  "  -z, --zuker                   Compute Zuker suboptimals instead of all \n                                  suboptimal structures within an engery band \n                                  arround the MFE.\n\n                                    (default=off)",
  "\nModel Details:",
  "  -T, --temp=DOUBLE             Rescale energy parameters to a temperature of \n                                  temp C. Default is 37C.\n\n",
  "  -4, --noTetra                 Do not include special tabulated stabilizing \n                                  energies for tri-, tetra- and hexaloop \n                                  hairpins. Mostly for testing.\n\n                                    (default=off)",
  "  -d, --dangles=INT             How to treat \"dangling end\" energies for \n                                  bases adjacent to helices in free ends and \n                                  multi-loops\n                                    (default=`2')",
  "  \n  With -d1 only unpaired bases can participate in at most one dangling end, \n  this is the default for mfe folding but unsupported for the partition \n  function folding.\n\n  With -d2 this check is ignored, dangling energies will be added for the bases \n  adjacent to a helix on both sides in any case; this is the default for \n  partition function folding (-p).\n  The option -d0 ignores dangling ends altogether (mostly for debugging).\n  With -d3 mfe folding will allow coaxial stacking of adjacent helices in \n  multi-loops. At the moment the implementation will not allow coaxial stacking \n  of the two interior pairs in a loop of degree 3 and works only for mfe \n  folding.\n\n  Note that by default (as well as with -d1 and -d3) pf and mfe folding treat \n  dangling ends differently. Use -d2 in addition to -p to ensure that both \n  algorithms use the same energy model.\n\n",
  "      --noLP                    Produce structures without lonely pairs \n                                  (helices of length 1).\n                                    (default=off)",
  "  For partition function folding this only disallows pairs that can only occur \n  isolated. Other pairs may still occasionally occur as helices of length 1.\n\n",
  "      --noGU                    Do not allow GU pairs\n\n                                    (default=off)",
  "      --noClosingGU             Do not allow GU pairs at the end of helices\n\n                                    (default=off)",
  "      --logML                   Recalculate energies of structures using a \n                                  logarithmic energy function for multi-loops \n                                  before output.  (default=off)",
  "  This option does not effect structure generation, only the energies that are \n  printed out. Since logML lowers energies somewhat, some structures may be \n  missing.\n\n",
  "      --betaScale=DOUBLE        Set the scaling of the Boltzmann factors\n                                    (default=`1.')",
  "  The argument provided with this option enables to scale the thermodynamic \n  temperature used in the Boltzmann factors independently from the temperature \n  used to scale the individual energy contributions of the loop types. The \n  Boltzmann factors then become exp(-dG/(kT*betaScale)) where k is the \n  Boltzmann constant, dG the free energy contribution of the state and T the \n  absolute temperature.\n\n",
  "  -P, --paramFile=paramfile     Read energy parameters from paramfile, instead \n                                  of using the default parameter set.\n",
  "  A sample parameter file should accompany your distribution.\n  See the RNAlib documentation for details on the file format.\n\n",
  "      --nsp=STRING              Allow other pairs in addition to the usual \n                                  AU,GC,and GU pairs.\n",
  "  Its argument is a comma separated list of additionally allowed pairs. If the \n  first character is a \"-\" then AB will imply that AB and BA are allowed \n  pairs.\n  e.g. RNAfold -nsp -GA  will allow GA and AG pairs. Nonstandard pairs are \n  given 0 stacking energy.\n\n",
  "\nIf in doubt our program is right, nature is at fault.\nComments should be sent to rna@tbi.univie.ac.at.\n",
    0
};
static void
init_full_help_array(void)
{
  RNAsubopt_args_info_full_help[0] = RNAsubopt_args_info_detailed_help[0];
  RNAsubopt_args_info_full_help[1] = RNAsubopt_args_info_detailed_help[1];
  RNAsubopt_args_info_full_help[2] = RNAsubopt_args_info_detailed_help[2];
  RNAsubopt_args_info_full_help[3] = RNAsubopt_args_info_detailed_help[3];
  RNAsubopt_args_info_full_help[4] = RNAsubopt_args_info_detailed_help[4];
  RNAsubopt_args_info_full_help[5] = RNAsubopt_args_info_detailed_help[5];
  RNAsubopt_args_info_full_help[6] = RNAsubopt_args_info_detailed_help[6];
  RNAsubopt_args_info_full_help[7] = RNAsubopt_args_info_detailed_help[8];
  RNAsubopt_args_info_full_help[8] = RNAsubopt_args_info_detailed_help[9];
  RNAsubopt_args_info_full_help[9] = RNAsubopt_args_info_detailed_help[10];
  RNAsubopt_args_info_full_help[10] = RNAsubopt_args_info_detailed_help[11];
  RNAsubopt_args_info_full_help[11] = RNAsubopt_args_info_detailed_help[12];
  RNAsubopt_args_info_full_help[12] = RNAsubopt_args_info_detailed_help[14];
  RNAsubopt_args_info_full_help[13] = RNAsubopt_args_info_detailed_help[16];
  RNAsubopt_args_info_full_help[14] = RNAsubopt_args_info_detailed_help[17];
  RNAsubopt_args_info_full_help[15] = RNAsubopt_args_info_detailed_help[19];
  RNAsubopt_args_info_full_help[16] = RNAsubopt_args_info_detailed_help[20];
  RNAsubopt_args_info_full_help[17] = RNAsubopt_args_info_detailed_help[22];
  RNAsubopt_args_info_full_help[18] = RNAsubopt_args_info_detailed_help[23];
  RNAsubopt_args_info_full_help[19] = RNAsubopt_args_info_detailed_help[24];
  RNAsubopt_args_info_full_help[20] = RNAsubopt_args_info_detailed_help[25];
  RNAsubopt_args_info_full_help[21] = RNAsubopt_args_info_detailed_help[26];
  RNAsubopt_args_info_full_help[22] = RNAsubopt_args_info_detailed_help[28];
  RNAsubopt_args_info_full_help[23] = RNAsubopt_args_info_detailed_help[30];
  RNAsubopt_args_info_full_help[24] = RNAsubopt_args_info_detailed_help[31];
  RNAsubopt_args_info_full_help[25] = RNAsubopt_args_info_detailed_help[32];
  RNAsubopt_args_info_full_help[26] = RNAsubopt_args_info_detailed_help[34];
  RNAsubopt_args_info_full_help[27] = RNAsubopt_args_info_detailed_help[36];
  RNAsubopt_args_info_full_help[28] = RNAsubopt_args_info_detailed_help[38];
  RNAsubopt_args_info_full_help[29] = RNAsubopt_args_info_detailed_help[40];
  RNAsubopt_args_info_full_help[30] = 0; 
  
}

const char *RNAsubopt_args_info_full_help[31];

static void
init_help_array(void)
{
  RNAsubopt_args_info_help[0] = RNAsubopt_args_info_detailed_help[0];
  RNAsubopt_args_info_help[1] = RNAsubopt_args_info_detailed_help[1];
  RNAsubopt_args_info_help[2] = RNAsubopt_args_info_detailed_help[2];
  RNAsubopt_args_info_help[3] = RNAsubopt_args_info_detailed_help[3];
  RNAsubopt_args_info_help[4] = RNAsubopt_args_info_detailed_help[4];
  RNAsubopt_args_info_help[5] = RNAsubopt_args_info_detailed_help[5];
  RNAsubopt_args_info_help[6] = RNAsubopt_args_info_detailed_help[6];
  RNAsubopt_args_info_help[7] = RNAsubopt_args_info_detailed_help[8];
  RNAsubopt_args_info_help[8] = RNAsubopt_args_info_detailed_help[9];
  RNAsubopt_args_info_help[9] = RNAsubopt_args_info_detailed_help[10];
  RNAsubopt_args_info_help[10] = RNAsubopt_args_info_detailed_help[11];
  RNAsubopt_args_info_help[11] = RNAsubopt_args_info_detailed_help[12];
  RNAsubopt_args_info_help[12] = RNAsubopt_args_info_detailed_help[14];
  RNAsubopt_args_info_help[13] = RNAsubopt_args_info_detailed_help[16];
  RNAsubopt_args_info_help[14] = RNAsubopt_args_info_detailed_help[19];
  RNAsubopt_args_info_help[15] = RNAsubopt_args_info_detailed_help[20];
  RNAsubopt_args_info_help[16] = RNAsubopt_args_info_detailed_help[22];
  RNAsubopt_args_info_help[17] = RNAsubopt_args_info_detailed_help[23];
  RNAsubopt_args_info_help[18] = RNAsubopt_args_info_detailed_help[24];
  RNAsubopt_args_info_help[19] = RNAsubopt_args_info_detailed_help[25];
  RNAsubopt_args_info_help[20] = RNAsubopt_args_info_detailed_help[26];
  RNAsubopt_args_info_help[21] = RNAsubopt_args_info_detailed_help[28];
  RNAsubopt_args_info_help[22] = RNAsubopt_args_info_detailed_help[30];
  RNAsubopt_args_info_help[23] = RNAsubopt_args_info_detailed_help[31];
  RNAsubopt_args_info_help[24] = RNAsubopt_args_info_detailed_help[32];
  RNAsubopt_args_info_help[25] = RNAsubopt_args_info_detailed_help[36];
  RNAsubopt_args_info_help[26] = RNAsubopt_args_info_detailed_help[40];
  RNAsubopt_args_info_help[27] = 0; 
  
}

const char *RNAsubopt_args_info_help[28];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_FLOAT
  , ARG_DOUBLE
} RNAsubopt_cmdline_parser_arg_type;

static
void clear_given (struct RNAsubopt_args_info *args_info);
static
void clear_args (struct RNAsubopt_args_info *args_info);

static int
RNAsubopt_cmdline_parser_internal (int argc, char **argv, struct RNAsubopt_args_info *args_info,
                        struct RNAsubopt_cmdline_parser_params *params, const char *additional_error);

static int
RNAsubopt_cmdline_parser_required2 (struct RNAsubopt_args_info *args_info, const char *prog_name, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct RNAsubopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->detailed_help_given = 0 ;
  args_info->full_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->constraint_given = 0 ;
  args_info->noconv_given = 0 ;
  args_info->deltaEnergy_given = 0 ;
  args_info->deltaEnergyPost_given = 0 ;
  args_info->sorted_given = 0 ;
  args_info->stochBT_given = 0 ;
  args_info->pfScale_given = 0 ;
  args_info->circ_given = 0 ;
  args_info->dos_given = 0 ;
  args_info->zuker_given = 0 ;
  args_info->temp_given = 0 ;
  args_info->noTetra_given = 0 ;
  args_info->dangles_given = 0 ;
  args_info->noLP_given = 0 ;
  args_info->noGU_given = 0 ;
  args_info->noClosingGU_given = 0 ;
  args_info->logML_given = 0 ;
  args_info->betaScale_given = 0 ;
  args_info->paramFile_given = 0 ;
  args_info->nsp_given = 0 ;
}

static
void clear_args (struct RNAsubopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->constraint_flag = 0;
  args_info->noconv_flag = 0;
  args_info->deltaEnergy_orig = NULL;
  args_info->deltaEnergyPost_orig = NULL;
  args_info->sorted_flag = 0;
  args_info->stochBT_orig = NULL;
  args_info->pfScale_orig = NULL;
  args_info->circ_flag = 0;
  args_info->dos_flag = 0;
  args_info->zuker_flag = 0;
  args_info->temp_orig = NULL;
  args_info->noTetra_flag = 0;
  args_info->dangles_arg = 2;
  args_info->dangles_orig = NULL;
  args_info->noLP_flag = 0;
  args_info->noGU_flag = 0;
  args_info->noClosingGU_flag = 0;
  args_info->logML_flag = 0;
  args_info->betaScale_arg = 1.;
  args_info->betaScale_orig = NULL;
  args_info->paramFile_arg = NULL;
  args_info->paramFile_orig = NULL;
  args_info->nsp_arg = NULL;
  args_info->nsp_orig = NULL;
  
}

static
void init_args_info(struct RNAsubopt_args_info *args_info)
{
  init_full_help_array(); 
  init_help_array(); 
  args_info->help_help = RNAsubopt_args_info_detailed_help[0] ;
  args_info->detailed_help_help = RNAsubopt_args_info_detailed_help[1] ;
  args_info->full_help_help = RNAsubopt_args_info_detailed_help[2] ;
  args_info->version_help = RNAsubopt_args_info_detailed_help[3] ;
  args_info->constraint_help = RNAsubopt_args_info_detailed_help[6] ;
  args_info->noconv_help = RNAsubopt_args_info_detailed_help[8] ;
  args_info->deltaEnergy_help = RNAsubopt_args_info_detailed_help[11] ;
  args_info->deltaEnergyPost_help = RNAsubopt_args_info_detailed_help[12] ;
  args_info->sorted_help = RNAsubopt_args_info_detailed_help[14] ;
  args_info->stochBT_help = RNAsubopt_args_info_detailed_help[16] ;
  args_info->pfScale_help = RNAsubopt_args_info_detailed_help[17] ;
  args_info->circ_help = RNAsubopt_args_info_detailed_help[19] ;
  args_info->dos_help = RNAsubopt_args_info_detailed_help[20] ;
  args_info->zuker_help = RNAsubopt_args_info_detailed_help[22] ;
  args_info->temp_help = RNAsubopt_args_info_detailed_help[24] ;
  args_info->noTetra_help = RNAsubopt_args_info_detailed_help[25] ;
  args_info->dangles_help = RNAsubopt_args_info_detailed_help[26] ;
  args_info->noLP_help = RNAsubopt_args_info_detailed_help[28] ;
  args_info->noGU_help = RNAsubopt_args_info_detailed_help[30] ;
  args_info->noClosingGU_help = RNAsubopt_args_info_detailed_help[31] ;
  args_info->logML_help = RNAsubopt_args_info_detailed_help[32] ;
  args_info->betaScale_help = RNAsubopt_args_info_detailed_help[34] ;
  args_info->paramFile_help = RNAsubopt_args_info_detailed_help[36] ;
  args_info->nsp_help = RNAsubopt_args_info_detailed_help[38] ;
  
}

void
RNAsubopt_cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(RNASUBOPT_CMDLINE_PARSER_PACKAGE_NAME) ? RNASUBOPT_CMDLINE_PARSER_PACKAGE_NAME : RNASUBOPT_CMDLINE_PARSER_PACKAGE),
     RNASUBOPT_CMDLINE_PARSER_VERSION);
}

static void print_help_common(void) {
  RNAsubopt_cmdline_parser_print_version ();

  if (strlen(RNAsubopt_args_info_purpose) > 0)
    printf("\n%s\n", RNAsubopt_args_info_purpose);

  if (strlen(RNAsubopt_args_info_usage) > 0)
    printf("\n%s\n", RNAsubopt_args_info_usage);

  printf("\n");

  if (strlen(RNAsubopt_args_info_description) > 0)
    printf("%s\n\n", RNAsubopt_args_info_description);
}

void
RNAsubopt_cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAsubopt_args_info_help[i])
    printf("%s\n", RNAsubopt_args_info_help[i++]);
}

void
RNAsubopt_cmdline_parser_print_full_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAsubopt_args_info_full_help[i])
    printf("%s\n", RNAsubopt_args_info_full_help[i++]);
}

void
RNAsubopt_cmdline_parser_print_detailed_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAsubopt_args_info_detailed_help[i])
    printf("%s\n", RNAsubopt_args_info_detailed_help[i++]);
}

void
RNAsubopt_cmdline_parser_init (struct RNAsubopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
RNAsubopt_cmdline_parser_params_init(struct RNAsubopt_cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct RNAsubopt_cmdline_parser_params *
RNAsubopt_cmdline_parser_params_create(void)
{
  struct RNAsubopt_cmdline_parser_params *params = 
    (struct RNAsubopt_cmdline_parser_params *)malloc(sizeof(struct RNAsubopt_cmdline_parser_params));
  RNAsubopt_cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
RNAsubopt_cmdline_parser_release (struct RNAsubopt_args_info *args_info)
{

  free_string_field (&(args_info->deltaEnergy_orig));
  free_string_field (&(args_info->deltaEnergyPost_orig));
  free_string_field (&(args_info->stochBT_orig));
  free_string_field (&(args_info->pfScale_orig));
  free_string_field (&(args_info->temp_orig));
  free_string_field (&(args_info->dangles_orig));
  free_string_field (&(args_info->betaScale_orig));
  free_string_field (&(args_info->paramFile_arg));
  free_string_field (&(args_info->paramFile_orig));
  free_string_field (&(args_info->nsp_arg));
  free_string_field (&(args_info->nsp_orig));
  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
RNAsubopt_cmdline_parser_dump(FILE *outfile, struct RNAsubopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", RNASUBOPT_CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->detailed_help_given)
    write_into_file(outfile, "detailed-help", 0, 0 );
  if (args_info->full_help_given)
    write_into_file(outfile, "full-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->constraint_given)
    write_into_file(outfile, "constraint", 0, 0 );
  if (args_info->noconv_given)
    write_into_file(outfile, "noconv", 0, 0 );
  if (args_info->deltaEnergy_given)
    write_into_file(outfile, "deltaEnergy", args_info->deltaEnergy_orig, 0);
  if (args_info->deltaEnergyPost_given)
    write_into_file(outfile, "deltaEnergyPost", args_info->deltaEnergyPost_orig, 0);
  if (args_info->sorted_given)
    write_into_file(outfile, "sorted", 0, 0 );
  if (args_info->stochBT_given)
    write_into_file(outfile, "stochBT", args_info->stochBT_orig, 0);
  if (args_info->pfScale_given)
    write_into_file(outfile, "pfScale", args_info->pfScale_orig, 0);
  if (args_info->circ_given)
    write_into_file(outfile, "circ", 0, 0 );
  if (args_info->dos_given)
    write_into_file(outfile, "dos", 0, 0 );
  if (args_info->zuker_given)
    write_into_file(outfile, "zuker", 0, 0 );
  if (args_info->temp_given)
    write_into_file(outfile, "temp", args_info->temp_orig, 0);
  if (args_info->noTetra_given)
    write_into_file(outfile, "noTetra", 0, 0 );
  if (args_info->dangles_given)
    write_into_file(outfile, "dangles", args_info->dangles_orig, 0);
  if (args_info->noLP_given)
    write_into_file(outfile, "noLP", 0, 0 );
  if (args_info->noGU_given)
    write_into_file(outfile, "noGU", 0, 0 );
  if (args_info->noClosingGU_given)
    write_into_file(outfile, "noClosingGU", 0, 0 );
  if (args_info->logML_given)
    write_into_file(outfile, "logML", 0, 0 );
  if (args_info->betaScale_given)
    write_into_file(outfile, "betaScale", args_info->betaScale_orig, 0);
  if (args_info->paramFile_given)
    write_into_file(outfile, "paramFile", args_info->paramFile_orig, 0);
  if (args_info->nsp_given)
    write_into_file(outfile, "nsp", args_info->nsp_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
RNAsubopt_cmdline_parser_file_save(const char *filename, struct RNAsubopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", RNASUBOPT_CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = RNAsubopt_cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
RNAsubopt_cmdline_parser_free (struct RNAsubopt_args_info *args_info)
{
  RNAsubopt_cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
RNAsubopt_cmdline_parser (int argc, char **argv, struct RNAsubopt_args_info *args_info)
{
  return RNAsubopt_cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
RNAsubopt_cmdline_parser_ext (int argc, char **argv, struct RNAsubopt_args_info *args_info,
                   struct RNAsubopt_cmdline_parser_params *params)
{
  int result;
  result = RNAsubopt_cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      RNAsubopt_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAsubopt_cmdline_parser2 (int argc, char **argv, struct RNAsubopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct RNAsubopt_cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = RNAsubopt_cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      RNAsubopt_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAsubopt_cmdline_parser_required (struct RNAsubopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (RNAsubopt_cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      RNAsubopt_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAsubopt_cmdline_parser_required2 (struct RNAsubopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  
  /* checks for dependences among options */
  if (args_info->betaScale_given && ! args_info->stochBT_given)
    {
      fprintf (stderr, "%s: '--betaScale' option depends on option 'stochBT'%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }

  return error;
}

/*
 * Extracted from the glibc source tree, version 2.3.6
 *
 * Licensed under the GPL as per the whole glibc source tree.
 *
 * This file was modified so that getopt_long can be called
 * many times without risking previous memory to be spoiled.
 *
 * Modified by Andre Noll and Lorenzo Bettini for use in
 * GNU gengetopt generated files.
 *
 */

/* 
 * we must include anything we need since this file is not thought to be
 * inserted in a file already using getopt.h
 *
 * Lorenzo
 */

struct option
{
  const char *name;
  /* has_arg can't be an enum because some compilers complain about
     type mismatches in all the code that assumes it is an int.  */
  int has_arg;
  int *flag;
  int val;
};

/* This version of `getopt' appears to the caller like standard Unix `getopt'
   but it behaves differently for the user, since it allows the user
   to intersperse the options with the other arguments.

   As `getopt' works, it permutes the elements of ARGV so that,
   when it is done, all the options precede everything else.  Thus
   all application programs are extended to handle flexible argument order.
*/
/*
   If the field `flag' is not NULL, it points to a variable that is set
   to the value given in the field `val' when the option is found, but
   left unchanged if the option is not found.

   To have a long-named option do something other than set an `int' to
   a compiled-in constant, such as set a value from `custom_optarg', set the
   option's `flag' field to zero and its `val' field to a nonzero
   value (the equivalent single-letter option character, if there is
   one).  For long options that have a zero `flag' field, `getopt'
   returns the contents of the `val' field.  */

/* Names for the values of the `has_arg' field of `struct option'.  */
#ifndef no_argument
#define no_argument		0
#endif

#ifndef required_argument
#define required_argument	1
#endif

#ifndef optional_argument
#define optional_argument	2
#endif

struct custom_getopt_data {
	/*
	 * These have exactly the same meaning as the corresponding global variables,
	 * except that they are used for the reentrant versions of getopt.
	 */
	int custom_optind;
	int custom_opterr;
	int custom_optopt;
	char *custom_optarg;

	/* True if the internal members have been initialized.  */
	int initialized;

	/*
	 * The next char to be scanned in the option-element in which the last option
	 * character we returned was found.  This allows us to pick up the scan where
	 * we left off.  If this is zero, or a null string, it means resume the scan by
	 * advancing to the next ARGV-element.
	 */
	char *nextchar;

	/*
	 * Describe the part of ARGV that contains non-options that have been skipped.
	 * `first_nonopt' is the index in ARGV of the first of them; `last_nonopt' is
	 * the index after the last of them.
	 */
	int first_nonopt;
	int last_nonopt;
};

/*
 * the variables optarg, optind, opterr and optopt are renamed with
 * the custom_ prefix so that they don't interfere with getopt ones.
 *
 * Moreover they're static so they are visible only from within the
 * file where this very file will be included.
 */

/*
 * For communication from `custom_getopt' to the caller.  When `custom_getopt' finds an
 * option that takes an argument, the argument value is returned here.
 */
static char *custom_optarg;

/*
 * Index in ARGV of the next element to be scanned.  This is used for
 * communication to and from the caller and for communication between
 * successive calls to `custom_getopt'.
 *
 * On entry to `custom_getopt', 1 means this is the first call; initialize.
 *
 * When `custom_getopt' returns -1, this is the index of the first of the non-option
 * elements that the caller should itself scan.
 *
 * Otherwise, `custom_optind' communicates from one call to the next how much of ARGV
 * has been scanned so far.
 *
 * 1003.2 says this must be 1 before any call.
 */
static int custom_optind = 1;

/*
 * Callers store zero here to inhibit the error message for unrecognized
 * options.
 */
static int custom_opterr = 1;

/*
 * Set to an option character which was unrecognized.  This must be initialized
 * on some systems to avoid linking in the system's own getopt implementation.
 */
static int custom_optopt = '?';

/*
 * Exchange two adjacent subsequences of ARGV.  One subsequence is elements
 * [first_nonopt,last_nonopt) which contains all the non-options that have been
 * skipped so far.  The other is elements [last_nonopt,custom_optind), which contains
 * all the options processed since those non-options were skipped.
 * `first_nonopt' and `last_nonopt' are relocated so that they describe the new
 * indices of the non-options in ARGV after they are moved.
 */
static void exchange(char **argv, struct custom_getopt_data *d)
{
	int bottom = d->first_nonopt;
	int middle = d->last_nonopt;
	int top = d->custom_optind;
	char *tem;

	/*
	 * Exchange the shorter segment with the far end of the longer segment.
	 * That puts the shorter segment into the right place.  It leaves the
	 * longer segment in the right place overall, but it consists of two
	 * parts that need to be swapped next.
	 */
	while (top > middle && middle > bottom) {
		if (top - middle > middle - bottom) {
			/* Bottom segment is the short one.  */
			int len = middle - bottom;
			int i;

			/* Swap it with the top part of the top segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] =
					argv[top - (middle - bottom) + i];
				argv[top - (middle - bottom) + i] = tem;
			}
			/* Exclude the moved bottom segment from further swapping.  */
			top -= len;
		} else {
			/* Top segment is the short one.  */
			int len = top - middle;
			int i;

			/* Swap it with the bottom part of the bottom segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] = argv[middle + i];
				argv[middle + i] = tem;
			}
			/* Exclude the moved top segment from further swapping.  */
			bottom += len;
		}
	}
	/* Update records for the slots the non-options now occupy.  */
	d->first_nonopt += (d->custom_optind - d->last_nonopt);
	d->last_nonopt = d->custom_optind;
}

/* Initialize the internal data when the first call is made.  */
static void custom_getopt_initialize(struct custom_getopt_data *d)
{
	/*
	 * Start processing options with ARGV-element 1 (since ARGV-element 0
	 * is the program name); the sequence of previously skipped non-option
	 * ARGV-elements is empty.
	 */
	d->first_nonopt = d->last_nonopt = d->custom_optind;
	d->nextchar = NULL;
	d->initialized = 1;
}

#define NONOPTION_P (argv[d->custom_optind][0] != '-' || argv[d->custom_optind][1] == '\0')

/* return: zero: continue, nonzero: return given value to user */
static int shuffle_argv(int argc, char *const *argv,const struct option *longopts,
	struct custom_getopt_data *d)
{
	/*
	 * Give FIRST_NONOPT & LAST_NONOPT rational values if CUSTOM_OPTIND has been
	 * moved back by the user (who may also have changed the arguments).
	 */
	if (d->last_nonopt > d->custom_optind)
		d->last_nonopt = d->custom_optind;
	if (d->first_nonopt > d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * If we have just processed some options following some
	 * non-options, exchange them so that the options come first.
	 */
	if (d->first_nonopt != d->last_nonopt &&
			d->last_nonopt != d->custom_optind)
		exchange((char **) argv, d);
	else if (d->last_nonopt != d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * Skip any additional non-options and extend the range of
	 * non-options previously skipped.
	 */
	while (d->custom_optind < argc && NONOPTION_P)
		d->custom_optind++;
	d->last_nonopt = d->custom_optind;
	/*
	 * The special ARGV-element `--' means premature end of options.  Skip
	 * it like a null option, then exchange with previous non-options as if
	 * it were an option, then skip everything else like a non-option.
	 */
	if (d->custom_optind != argc && !strcmp(argv[d->custom_optind], "--")) {
		d->custom_optind++;
		if (d->first_nonopt != d->last_nonopt
				&& d->last_nonopt != d->custom_optind)
			exchange((char **) argv, d);
		else if (d->first_nonopt == d->last_nonopt)
			d->first_nonopt = d->custom_optind;
		d->last_nonopt = argc;
		d->custom_optind = argc;
	}
	/*
	 * If we have done all the ARGV-elements, stop the scan and back over
	 * any non-options that we skipped and permuted.
	 */
	if (d->custom_optind == argc) {
		/*
		 * Set the next-arg-index to point at the non-options that we
		 * previously skipped, so the caller will digest them.
		 */
		if (d->first_nonopt != d->last_nonopt)
			d->custom_optind = d->first_nonopt;
		return -1;
	}
	/*
	 * If we have come to a non-option and did not permute it, either stop
	 * the scan or describe it to the caller and pass it by.
	 */
	if (NONOPTION_P) {
		d->custom_optarg = argv[d->custom_optind++];
		return 1;
	}
	/*
	 * We have found another option-ARGV-element. Skip the initial
	 * punctuation.
	 */
	d->nextchar = (argv[d->custom_optind] + 1 + (longopts != NULL && argv[d->custom_optind][1] == '-'));
	return 0;
}

/*
 * Check whether the ARGV-element is a long option.
 *
 * If there's a long option "fubar" and the ARGV-element is "-fu", consider
 * that an abbreviation of the long option, just like "--fu", and not "-f" with
 * arg "u".
 *
 * This distinction seems to be the most useful approach.
 *
 */
static int check_long_opt(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		int print_errors, struct custom_getopt_data *d)
{
	char *nameend;
	const struct option *p;
	const struct option *pfound = NULL;
	int exact = 0;
	int ambig = 0;
	int indfound = -1;
	int option_index;

	for (nameend = d->nextchar; *nameend && *nameend != '='; nameend++)
		/* Do nothing.  */ ;

	/* Test all long options for either exact match or abbreviated matches */
	for (p = longopts, option_index = 0; p->name; p++, option_index++)
		if (!strncmp(p->name, d->nextchar, nameend - d->nextchar)) {
			if ((unsigned int) (nameend - d->nextchar)
					== (unsigned int) strlen(p->name)) {
				/* Exact match found.  */
				pfound = p;
				indfound = option_index;
				exact = 1;
				break;
			} else if (pfound == NULL) {
				/* First nonexact match found.  */
				pfound = p;
				indfound = option_index;
			} else if (pfound->has_arg != p->has_arg
					|| pfound->flag != p->flag
					|| pfound->val != p->val)
				/* Second or later nonexact match found.  */
				ambig = 1;
		}
	if (ambig && !exact) {
		if (print_errors) {
			fprintf(stderr,
				"%s: option `%s' is ambiguous\n",
				argv[0], argv[d->custom_optind]);
		}
		d->nextchar += strlen(d->nextchar);
		d->custom_optind++;
		d->custom_optopt = 0;
		return '?';
	}
	if (pfound) {
		option_index = indfound;
		d->custom_optind++;
		if (*nameend) {
			if (pfound->has_arg != no_argument)
				d->custom_optarg = nameend + 1;
			else {
				if (print_errors) {
					if (argv[d->custom_optind - 1][1] == '-') {
						/* --option */
						fprintf(stderr, "%s: option `--%s' doesn't allow an argument\n",
							argv[0], pfound->name);
					} else {
						/* +option or -option */
						fprintf(stderr, "%s: option `%c%s' doesn't allow an argument\n",
							argv[0], argv[d->custom_optind - 1][0], pfound->name);
					}

				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return '?';
			}
		} else if (pfound->has_arg == required_argument) {
			if (d->custom_optind < argc)
				d->custom_optarg = argv[d->custom_optind++];
			else {
				if (print_errors) {
					fprintf(stderr,
						"%s: option `%s' requires an argument\n",
						argv[0],
						argv[d->custom_optind - 1]);
				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return optstring[0] == ':' ? ':' : '?';
			}
		}
		d->nextchar += strlen(d->nextchar);
		if (longind != NULL)
			*longind = option_index;
		if (pfound->flag) {
			*(pfound->flag) = pfound->val;
			return 0;
		}
		return pfound->val;
	}
	/*
	 * Can't find it as a long option.  If this is not getopt_long_only, or
	 * the option starts with '--' or is not a valid short option, then
	 * it's an error.  Otherwise interpret it as a short option.
	 */
	if (print_errors) {
		if (argv[d->custom_optind][1] == '-') {
			/* --option */
			fprintf(stderr,
				"%s: unrecognized option `--%s'\n",
				argv[0], d->nextchar);
		} else {
			/* +option or -option */
			fprintf(stderr,
				"%s: unrecognized option `%c%s'\n",
				argv[0], argv[d->custom_optind][0],
				d->nextchar);
		}
	}
	d->nextchar = (char *) "";
	d->custom_optind++;
	d->custom_optopt = 0;
	return '?';
}

static int check_short_opt(int argc, char *const *argv, const char *optstring,
		int print_errors, struct custom_getopt_data *d)
{
	char c = *d->nextchar++;
	const char *temp = strchr(optstring, c);

	/* Increment `custom_optind' when we start to process its last character.  */
	if (*d->nextchar == '\0')
		++d->custom_optind;
	if (!temp || c == ':') {
		if (print_errors)
			fprintf(stderr, "%s: invalid option -- %c\n", argv[0], c);

		d->custom_optopt = c;
		return '?';
	}
	if (temp[1] == ':') {
		if (temp[2] == ':') {
			/* This is an option that accepts an argument optionally.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				d->custom_optind++;
			} else
				d->custom_optarg = NULL;
			d->nextchar = NULL;
		} else {
			/* This is an option that requires an argument.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				/*
				 * If we end this ARGV-element by taking the
				 * rest as an arg, we must advance to the next
				 * element now.
				 */
				d->custom_optind++;
			} else if (d->custom_optind == argc) {
				if (print_errors) {
					fprintf(stderr,
						"%s: option requires an argument -- %c\n",
						argv[0], c);
				}
				d->custom_optopt = c;
				if (optstring[0] == ':')
					c = ':';
				else
					c = '?';
			} else
				/*
				 * We already incremented `custom_optind' once;
				 * increment it again when taking next ARGV-elt
				 * as argument.
				 */
				d->custom_optarg = argv[d->custom_optind++];
			d->nextchar = NULL;
		}
	}
	return c;
}

/*
 * Scan elements of ARGV for option characters given in OPTSTRING.
 *
 * If an element of ARGV starts with '-', and is not exactly "-" or "--",
 * then it is an option element.  The characters of this element
 * (aside from the initial '-') are option characters.  If `getopt'
 * is called repeatedly, it returns successively each of the option characters
 * from each of the option elements.
 *
 * If `getopt' finds another option character, it returns that character,
 * updating `custom_optind' and `nextchar' so that the next call to `getopt' can
 * resume the scan with the following option character or ARGV-element.
 *
 * If there are no more option characters, `getopt' returns -1.
 * Then `custom_optind' is the index in ARGV of the first ARGV-element
 * that is not an option.  (The ARGV-elements have been permuted
 * so that those that are not options now come last.)
 *
 * OPTSTRING is a string containing the legitimate option characters.
 * If an option character is seen that is not listed in OPTSTRING,
 * return '?' after printing an error message.  If you set `custom_opterr' to
 * zero, the error message is suppressed but we still return '?'.
 *
 * If a char in OPTSTRING is followed by a colon, that means it wants an arg,
 * so the following text in the same ARGV-element, or the text of the following
 * ARGV-element, is returned in `custom_optarg'.  Two colons mean an option that
 * wants an optional arg; if there is text in the current ARGV-element,
 * it is returned in `custom_optarg', otherwise `custom_optarg' is set to zero.
 *
 * If OPTSTRING starts with `-' or `+', it requests different methods of
 * handling the non-option ARGV-elements.
 * See the comments about RETURN_IN_ORDER and REQUIRE_ORDER, above.
 *
 * Long-named options begin with `--' instead of `-'.
 * Their names may be abbreviated as long as the abbreviation is unique
 * or is an exact match for some defined option.  If they have an
 * argument, it follows the option name in the same ARGV-element, separated
 * from the option name by a `=', or else the in next ARGV-element.
 * When `getopt' finds a long-named option, it returns 0 if that option's
 * `flag' field is nonzero, the value of the option's `val' field
 * if the `flag' field is zero.
 *
 * The elements of ARGV aren't really const, because we permute them.
 * But we pretend they're const in the prototype to be compatible
 * with other systems.
 *
 * LONGOPTS is a vector of `struct option' terminated by an
 * element containing a name which is zero.
 *
 * LONGIND returns the index in LONGOPT of the long-named option found.
 * It is only valid when a long-named option has been found by the most
 * recent call.
 *
 * Return the option character from OPTS just read.  Return -1 when there are
 * no more options.  For unrecognized options, or options missing arguments,
 * `custom_optopt' is set to the option letter, and '?' is returned.
 *
 * The OPTS string is a list of characters which are recognized option letters,
 * optionally followed by colons, specifying that that letter takes an
 * argument, to be placed in `custom_optarg'.
 *
 * If a letter in OPTS is followed by two colons, its argument is optional.
 * This behavior is specific to the GNU `getopt'.
 *
 * The argument `--' causes premature termination of argument scanning,
 * explicitly telling `getopt' that there are no more options.  If OPTS begins
 * with `--', then non-option arguments are treated as arguments to the option
 * '\0'.  This behavior is specific to the GNU `getopt'.
 */

static int getopt_internal_r(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		struct custom_getopt_data *d)
{
	int ret, print_errors = d->custom_opterr;

	if (optstring[0] == ':')
		print_errors = 0;
	if (argc < 1)
		return -1;
	d->custom_optarg = NULL;

	/* 
	 * This is a big difference with GNU getopt, since optind == 0
	 * means initialization while here 1 means first call.
	 */
	if (d->custom_optind == 0 || !d->initialized) {
		if (d->custom_optind == 0)
			d->custom_optind = 1;	/* Don't scan ARGV[0], the program name.  */
		custom_getopt_initialize(d);
	}
	if (d->nextchar == NULL || *d->nextchar == '\0') {
		ret = shuffle_argv(argc, argv, longopts, d);
		if (ret)
			return ret;
	}
	if (longopts && (argv[d->custom_optind][1] == '-' ))
		return check_long_opt(argc, argv, optstring, longopts,
			longind, print_errors, d);
	return check_short_opt(argc, argv, optstring, print_errors, d);
}

static int custom_getopt_internal(int argc, char *const *argv, const char *optstring,
	const struct option *longopts, int *longind)
{
	int result;
	/* Keep a global copy of all internal members of d */
	static struct custom_getopt_data d;

	d.custom_optind = custom_optind;
	d.custom_opterr = custom_opterr;
	result = getopt_internal_r(argc, argv, optstring, longopts,
		longind, &d);
	custom_optind = d.custom_optind;
	custom_optarg = d.custom_optarg;
	custom_optopt = d.custom_optopt;
	return result;
}

static int custom_getopt_long (int argc, char *const *argv, const char *options,
	const struct option *long_options, int *opt_index)
{
	return custom_getopt_internal(argc, argv, options, long_options,
		opt_index);
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see RNAsubopt_cmdline_parser_params.check_ambiguity
 * @param override @see RNAsubopt_cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               RNAsubopt_cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_FLOAT:
    if (val) *((float *)field) = (float)strtod (val, &stop_char);
    break;
  case ARG_DOUBLE:
    if (val) *((double *)field) = strtod (val, &stop_char);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_FLOAT:
  case ARG_DOUBLE:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
RNAsubopt_cmdline_parser_internal (
  int argc, char **argv, struct RNAsubopt_args_info *args_info,
                        struct RNAsubopt_cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct RNAsubopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;

  char *optarg;
  int optind;
  int opterr;
  int optopt;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    RNAsubopt_cmdline_parser_init (args_info);

  RNAsubopt_cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "detailed-help",	0, NULL, 0 },
        { "full-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "constraint",	0, NULL, 'C' },
        { "noconv",	0, NULL, 0 },
        { "deltaEnergy",	1, NULL, 'e' },
        { "deltaEnergyPost",	1, NULL, 0 },
        { "sorted",	0, NULL, 's' },
        { "stochBT",	1, NULL, 'p' },
        { "pfScale",	1, NULL, 'S' },
        { "circ",	0, NULL, 'c' },
        { "dos",	0, NULL, 'D' },
        { "zuker",	0, NULL, 'z' },
        { "temp",	1, NULL, 'T' },
        { "noTetra",	0, NULL, '4' },
        { "dangles",	1, NULL, 'd' },
        { "noLP",	0, NULL, 0 },
        { "noGU",	0, NULL, 0 },
        { "noClosingGU",	0, NULL, 0 },
        { "logML",	0, NULL, 0 },
        { "betaScale",	1, NULL, 0 },
        { "paramFile",	1, NULL, 'P' },
        { "nsp",	1, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      custom_optarg = optarg;
      custom_optind = optind;
      custom_opterr = opterr;
      custom_optopt = optopt;

      c = custom_getopt_long (argc, argv, "hVCe:sp:S:cDzT:4d:P:", long_options, &option_index);

      optarg = custom_optarg;
      optind = custom_optind;
      opterr = custom_opterr;
      optopt = custom_optopt;

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          RNAsubopt_cmdline_parser_print_help ();
          RNAsubopt_cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          RNAsubopt_cmdline_parser_print_version ();
          RNAsubopt_cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'C':	/* Calculate structures subject to constraints.
.  */
        
        
          if (update_arg((void *)&(args_info->constraint_flag), 0, &(args_info->constraint_given),
              &(local_args_info.constraint_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "constraint", 'C',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* Compute suboptimal structures with energy in a certain range of the optimum (kcal/mol). Default is calculation of mfe structure only.
        
.  */
        
        
          if (update_arg( (void *)&(args_info->deltaEnergy_arg), 
               &(args_info->deltaEnergy_orig), &(args_info->deltaEnergy_given),
              &(local_args_info.deltaEnergy_given), optarg, 0, 0, ARG_FLOAT,
              check_ambiguity, override, 0, 0,
              "deltaEnergy", 'e',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* Sort the suboptimal structures by energy.
.  */
        
        
          if (update_arg((void *)&(args_info->sorted_flag), 0, &(args_info->sorted_given),
              &(local_args_info.sorted_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "sorted", 's',
              additional_error))
            goto failure;
        
          break;
        case 'p':	/* Instead of producing all suboptimals in an energy range, produce a random sample of suboptimal structures, drawn with probabilities equal to their Boltzmann weights via stochastic backtracking in the partition function. The -e and -p options are mutually exclusive.
        
.  */
        
        
          if (update_arg( (void *)&(args_info->stochBT_arg), 
               &(args_info->stochBT_orig), &(args_info->stochBT_given),
              &(local_args_info.stochBT_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "stochBT", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'S':	/* In the calculation of the pf use scale*mfe as an estimate for the ensemble free energy (used to avoid overflows). Needed by stochastic backtracking
.  */
        
        
          if (update_arg( (void *)&(args_info->pfScale_arg), 
               &(args_info->pfScale_orig), &(args_info->pfScale_given),
              &(local_args_info.pfScale_given), optarg, 0, 0, ARG_DOUBLE,
              check_ambiguity, override, 0, 0,
              "pfScale", 'S',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Assume a circular (instead of linear) RNA molecule.
        
.  */
        
        
          if (update_arg((void *)&(args_info->circ_flag), 0, &(args_info->circ_given),
              &(local_args_info.circ_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "circ", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'D':	/* Compute density of states instead of secondary structures
.  */
        
        
          if (update_arg((void *)&(args_info->dos_flag), 0, &(args_info->dos_given),
              &(local_args_info.dos_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "dos", 'D',
              additional_error))
            goto failure;
        
          break;
        case 'z':	/* Compute Zuker suboptimals instead of all suboptimal structures within an engery band arround the MFE.
        
.  */
        
        
          if (update_arg((void *)&(args_info->zuker_flag), 0, &(args_info->zuker_given),
              &(local_args_info.zuker_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "zuker", 'z',
              additional_error))
            goto failure;
        
          break;
        case 'T':	/* Rescale energy parameters to a temperature of temp C. Default is 37C.
        
.  */
        
        
          if (update_arg( (void *)&(args_info->temp_arg), 
               &(args_info->temp_orig), &(args_info->temp_given),
              &(local_args_info.temp_given), optarg, 0, 0, ARG_DOUBLE,
              check_ambiguity, override, 0, 0,
              "temp", 'T',
              additional_error))
            goto failure;
        
          break;
        case '4':	/* Do not include special tabulated stabilizing energies for tri-, tetra- and hexaloop hairpins. Mostly for testing.
        
.  */
        
        
          if (update_arg((void *)&(args_info->noTetra_flag), 0, &(args_info->noTetra_given),
              &(local_args_info.noTetra_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "noTetra", '4',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops
.  */
        
        
          if (update_arg( (void *)&(args_info->dangles_arg), 
               &(args_info->dangles_orig), &(args_info->dangles_given),
              &(local_args_info.dangles_given), optarg, 0, "2", ARG_INT,
              check_ambiguity, override, 0, 0,
              "dangles", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'P':	/* Read energy parameters from paramfile, instead of using the default parameter set.
.  */
        
        
          if (update_arg( (void *)&(args_info->paramFile_arg), 
               &(args_info->paramFile_orig), &(args_info->paramFile_given),
              &(local_args_info.paramFile_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "paramFile", 'P',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "detailed-help") == 0) {
            RNAsubopt_cmdline_parser_print_detailed_help ();
            RNAsubopt_cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          if (strcmp (long_options[option_index].name, "full-help") == 0) {
            RNAsubopt_cmdline_parser_print_full_help ();
            RNAsubopt_cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          /* Do not automatically substitude nucleotide \"T\" with \"U\"
          
.  */
          if (strcmp (long_options[option_index].name, "noconv") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noconv_flag), 0, &(args_info->noconv_given),
                &(local_args_info.noconv_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noconv", '-',
                additional_error))
              goto failure;
          
          }
          /* Only print structures with energy within range of the mfe after post reevaluation of energies.
.  */
          else if (strcmp (long_options[option_index].name, "deltaEnergyPost") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->deltaEnergyPost_arg), 
                 &(args_info->deltaEnergyPost_orig), &(args_info->deltaEnergyPost_given),
                &(local_args_info.deltaEnergyPost_given), optarg, 0, 0, ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "deltaEnergyPost", '-',
                additional_error))
              goto failure;
          
          }
          /* Produce structures without lonely pairs (helices of length 1).
.  */
          else if (strcmp (long_options[option_index].name, "noLP") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noLP_flag), 0, &(args_info->noLP_given),
                &(local_args_info.noLP_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noLP", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not allow GU pairs
          
.  */
          else if (strcmp (long_options[option_index].name, "noGU") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noGU_flag), 0, &(args_info->noGU_given),
                &(local_args_info.noGU_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noGU", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not allow GU pairs at the end of helices
          
.  */
          else if (strcmp (long_options[option_index].name, "noClosingGU") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noClosingGU_flag), 0, &(args_info->noClosingGU_given),
                &(local_args_info.noClosingGU_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noClosingGU", '-',
                additional_error))
              goto failure;
          
          }
          /* Recalculate energies of structures using a logarithmic energy function for multi-loops before output..  */
          else if (strcmp (long_options[option_index].name, "logML") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->logML_flag), 0, &(args_info->logML_given),
                &(local_args_info.logML_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "logML", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the scaling of the Boltzmann factors
.  */
          else if (strcmp (long_options[option_index].name, "betaScale") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->betaScale_arg), 
                 &(args_info->betaScale_orig), &(args_info->betaScale_given),
                &(local_args_info.betaScale_given), optarg, 0, "1.", ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "betaScale", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow other pairs in addition to the usual AU,GC,and GU pairs.
.  */
          else if (strcmp (long_options[option_index].name, "nsp") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->nsp_arg), 
                 &(args_info->nsp_orig), &(args_info->nsp_given),
                &(local_args_info.nsp_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "nsp", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", RNASUBOPT_CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
      error += RNAsubopt_cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  RNAsubopt_cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  RNAsubopt_cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
