/********************************************************/
/*  ____  _     _____ __  __ ____  _       _   _____    */
/* |  _ \(_)___| ____|  \/  | __ )| |     / | |___ /    */
/* | | | | / __|  _| | |\/| |  _ \| |     | |   |_ \    */
/* | |_| | \__ \ |___| |  | | |_) | |___  | |_ ___) |   */
/* |____/|_|___/_____|_|  |_|____/|_____| |_(_)____/    */
/* DisEMBL is Copyright (C) 2003                        */
/* Lars Juhl Jensen & Rune Linding - EMBL               */
/* Licensed under GPL                                   */
/********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Define size of the alphabet */
#define na 21

/* Define max number of neurons */
#define mw 41
#define mh 30

#include "russel.h"
#include "bfactor.h"
#include "missing.h"

float sigmoid[256] = {
  0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
  0.000000, 0.000000, 0.000000, 0.000000, 0.000001, 0.000001, 0.000001, 0.000001,
  0.000001, 0.000001, 0.000001, 0.000001, 0.000001, 0.000002, 0.000002, 0.000002,
  0.000002, 0.000003, 0.000003, 0.000003, 0.000004, 0.000004, 0.000005, 0.000005,
  0.000006, 0.000007, 0.000008, 0.000009, 0.000010, 0.000011, 0.000013, 0.000015,
  0.000017, 0.000019, 0.000021, 0.000024, 0.000028, 0.000031, 0.000035, 0.000040,
  0.000045, 0.000051, 0.000058, 0.000066, 0.000075, 0.000085, 0.000096, 0.000109,
  0.000123, 0.000140, 0.000158, 0.000180, 0.000203, 0.000231, 0.000261, 0.000296,
  0.000335, 0.000380, 0.000431, 0.000488, 0.000553, 0.000626, 0.000710, 0.000804,
  0.000911, 0.001032, 0.001170, 0.001325, 0.001501, 0.001701, 0.001927, 0.002183,
  0.002473, 0.002801, 0.003173, 0.003594, 0.004070, 0.004610, 0.005220, 0.005911,
  0.006693, 0.007577, 0.008577, 0.009708, 0.010987, 0.012432, 0.014064, 0.015906,
  0.017986, 0.020332, 0.022977, 0.025957, 0.029312, 0.033086, 0.037327, 0.042088,
  0.047426, 0.053403, 0.060087, 0.067547, 0.075858, 0.085099, 0.095349, 0.106691,
  0.119203, 0.132964, 0.148047, 0.164516, 0.182426, 0.201813, 0.222700, 0.245085,
  0.268941, 0.294215, 0.320821, 0.348645, 0.377541, 0.407333, 0.437823, 0.468791,
  0.500000, 0.531209, 0.562177, 0.592667, 0.622459, 0.651355, 0.679179, 0.705785,
  0.731059, 0.754915, 0.777300, 0.798187, 0.817574, 0.835484, 0.851953, 0.867036,
  0.880797, 0.893309, 0.904651, 0.914901, 0.924142, 0.932453, 0.939913, 0.946597,
  0.952574, 0.957912, 0.962673, 0.966914, 0.970688, 0.974043, 0.977023, 0.979668,
  0.982014, 0.984094, 0.985936, 0.987568, 0.989013, 0.990292, 0.991423, 0.992423,
  0.993307, 0.994089, 0.994780, 0.995390, 0.995930, 0.996406, 0.996827, 0.997199,
  0.997527, 0.997817, 0.998073, 0.998299, 0.998499, 0.998675, 0.998830, 0.998968,
  0.999089, 0.999196, 0.999290, 0.999374, 0.999447, 0.999512, 0.999569, 0.999620,
  0.999665, 0.999704, 0.999739, 0.999769, 0.999797, 0.999820, 0.999842, 0.999860,
  0.999877, 0.999891, 0.999904, 0.999915, 0.999925, 0.999934, 0.999942, 0.999949,
  0.999955, 0.999960, 0.999965, 0.999969, 0.999972, 0.999976, 0.999979, 0.999981,
  0.999983, 0.999985, 0.999987, 0.999989, 0.999990, 0.999991, 0.999992, 0.999993,
  0.999994, 0.999995, 0.999995, 0.999996, 0.999996, 0.999997, 0.999997, 0.999997,
  0.999998, 0.999998, 0.999998, 0.999998, 0.999999, 0.999999, 0.999999, 0.999999,
  0.999999, 0.999999, 0.999999, 0.999999, 0.999999, 1.000000, 1.000000, 1.000000,
  1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000, 1.000000
};




/*
 *  Perform feed forward evaluation of a neural network on a sequence window.
 */

float feed_forward(int const *s, float const w[], int nw, int nh) {

  float h[mh], o[2], x;
  int i, j;

  /* Shift input window to match network window size */
  s += (mw-nw)/2;

  /* Feed input values to hidden layer making use of sparse encoding */
  for (i = 0; i < nh; ++i) {
    x = w[(na*nw+1)*(i+1)-1];
    for (j = 0; j < nw; ++j) {
      x += w[(na*nw+1)*i+na*j+s[j]];
    }
    if (x <= -16) {
      h[i] = 0;
    } else if (x >= 16) {
      h[i] = 1;
    } else {
      h[i] = sigmoid[(int)(8*x+128)];
    }
  }

  /* Feed hidden layer values to output layer */
  for (i = 0; i <= 1; ++i) {
    x = w[(na*nw+1)*nh+(nh+1)*(i+1)-1];
    for (j = 0; j < nh; ++j) {
      x += w[(na*nw+1)*nh+(nh+1)*i+j]*h[j];
    }
    if (x <= -16) {
      o[i] = 0;
    } else if (x >= 16) {
      o[i] = 1;
    } else {
      o[i] = sigmoid[(int)(8*x+128)];
    }
  }

  /* Combine the scores from the two output neurons */
  return((o[0]+1-o[1])/2);

}




/*
 *  Calculate and print scores for a sequence window.
 */

void predict(int const *s) {

  float sm, sb, sr;

  if (s[(mw-1)/2] == na-1) {
    return;
  }

  sr = 0;
  sr += feed_forward(s, r19_1, 19, 30);
  sr += feed_forward(s, r19_2, 19, 30);
  sr += feed_forward(s, r19_3, 19, 30);
  sr += feed_forward(s, r19_4, 19, 30);
  sr += feed_forward(s, r19_5, 19, 30);
  sr /= 5;
  sr = 0.07387214+0.8020778*sr;

  sb = 0;
  sb += feed_forward(s, b41_1, 41, 5);
  sb += feed_forward(s, b41_2, 41, 5);
  sb += feed_forward(s, b41_3, 41, 5);
  sb += feed_forward(s, b41_4, 41, 5);
  sb += feed_forward(s, b41_5, 41, 5);
  sb /= 5;
  sb = 0.08016882+0.6282424*sb;

  sm = 0;
  sm += feed_forward(s, m9_1, 9, 30);
  sm += feed_forward(s, m9_2, 9, 30);
  sm += feed_forward(s, m9_3, 9, 30);
  sm += feed_forward(s, m9_4, 9, 30);
  sm += feed_forward(s, m9_5, 9, 30);
  sm += feed_forward(s, m21_1, 21, 30);
  sm += feed_forward(s, m21_2, 21, 30);
  sm += feed_forward(s, m21_3, 21, 30);
  sm += feed_forward(s, m21_4, 21, 30);
  sm += feed_forward(s, m21_5, 21, 30);
  sm /= 10;

  printf("%f\t%f\t%f\n", sr, sr*sb, sm);

}

int main(int ARGC, char *ARGV[]) {

  char *alphabet = strdup("FIVWMLCHYAGNRTPDEQSK");

  char *p;
  int c, i, j, s[mw];

  for (i = 0; i < mw; ++i) {
    s[i] = na-1;
  }

  while (!feof(stdin)) {

    c = fgetc(stdin);
    p = strchr(alphabet, c);
    if (p != NULL) {
      for (i = 1; i < mw; ++i) {
        s[mw-i] = s[mw-i-1];
      }
      s[0] = p-alphabet;
      predict(s);
    } else if ((char)c == '\n') {
      for (i = 0; i < (mw-1)/2; i++) {
        for (j = 1; j < mw; ++j) {
          s[mw-j] = s[mw-j-1];
        }
        s[0] = na-1;
        predict(s);
      }
    }

  }

  return(0);

}
