/* Concurrent read version */
/*	20-June-1986	universal pam file */

/* $Name: fa_34_26_5 $ - $Id: upam.h,v 1.19 2006/02/07 17:58:19 wrp Exp $ */

/* modified to accomodate both lower and upper case amino acid numbers
   as a result MAXSQ = 50
*/

#ifndef UPAM_GBL_DEF
#define UPAM_GBL_DEF

#define EOSEQ 0
#define MAXSQ 50
#define MAXUC 24
#define MAXLC 48

#define MAXHASH 32
#define NMAP MAXHASH+1

#ifndef XTERNAL

int pamoff=0;

/*extern int gdelval, ggapval;*/

/* char sqnam[]="aa"; */
/* char sqtype[]="protein"; */

char aa[MAXSQ+1]  = {"\0ARNDCQEGHILKMFPSTWYVBZX*ARNDCQEGHILKMFPSTWYVBZX*\0"};
char aax[MAXSQ+1] = {"\0ARNDCQEGHILKMFPSTWYVBZX*arndcqeghilkmfpstwyvbzx*\0"};

int naa = 24;	/* this should be calculated from aa[] */
int naax = 48;

/* haa[] used to map all valid amino acid codes into a hash value;
   now, there is an additional hash value - not-mapped - NM */

/* this has been expanded to accomodate '*' */
int haa[MAXSQ+1] = {
  NMAP,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,3,7,NMAP,NMAP,
       1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,3,7,NMAP,NMAP};

int haax[MAXSQ+1] = {
  NMAP,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,3,7,NMAP,
  NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,
  NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,
  NMAP};

/*
  PAM 250 substitution matrix, scale = ln(2)/3 = 0.231049
  Expected score = -0.844, Entropy = 0.354 bits
  Lowest score = -8, Highest score = 17
*/
int apam250[450] = {
 2,
-2, 6,
 0, 0, 2,
 0,-1, 2, 4,
-2,-4,-4,-5,12,
 0, 1, 1, 2,-5, 4,
 0,-1, 1, 3,-5, 2, 4,
 1,-3, 0, 1,-3,-1, 0, 5,
-1, 2, 2, 1,-3, 3, 1,-2, 6,
-1,-2,-2,-2,-2,-2,-2,-3,-2, 5,
-2,-3,-3,-4,-6,-2,-3,-4,-2, 2, 6,
-1, 3, 1, 0,-5, 1, 0,-2, 0,-2,-3, 5,
-1, 0,-2,-3,-5,-1,-2,-3,-2, 2, 4, 0, 6,
-4,-4,-4,-6,-4,-5,-5,-5,-2, 1, 2,-5, 0, 9,
 1, 0,-1,-1,-3, 0,-1,-1, 0,-2,-3,-1,-2,-5, 6,
 1, 0, 1, 0, 0,-1, 0, 1,-1,-1,-3, 0,-2,-3, 1, 2,
 1,-1, 0, 0,-2,-1, 0, 0,-1, 0,-2, 0,-1,-3, 0, 1, 3,
-6, 2,-4,-7,-8,-5,-7,-7,-3,-5,-2,-3,-4, 0,-6,-2,-5,17,
-3,-4,-2,-4, 0,-4,-4,-5, 0,-1,-1,-4,-2, 7,-5,-3,-3, 0,10,
 0,-2,-2,-2,-2,-2,-2,-1,-2, 4, 2,-2, 2,-1,-1,-1, 0,-6,-2, 4,
 0,-1, 2, 3,-4, 1, 2, 0, 1,-2,-3, 1,-2,-5,-1, 0, 0,-5,-3,-2, 2,
 0, 0, 1, 3,-5, 3, 3,-1, 2,-2,-3, 0,-2,-5, 0, 0,-1,-6,-4,-2, 2, 3,
 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-1,-1,-1,-2,-1, 0, 0,-4,-2,-1,-1,-1,-1,
 0,-1, 0,-1,-3,-1,-1,-1,-1,-1,-1,-1,-1,-2,-1, 0, 0,-4,-2,-1,-1,-1,-1, 8};

/*
 This matrix was produced by "pam" Version 1.0.6 [28-Jul-93]
 PAM 120 substitution matrix, scale = ln(2)/2 = 0.346574
 Expected score = -1.64, Entropy = 0.979 bits
 Lowest score = -8, Highest score = 12
*/
int apam120[450] = {
  3,
 -3, 6,
  0,-1, 4,
  0,-3, 2, 5,
 -3,-4,-5,-7, 9,
 -1, 1, 0, 1,-7, 6,
  0,-3, 1, 3,-7, 2, 5,
  1,-4, 0, 0,-5,-3,-1, 5,
 -3, 1, 2, 0,-4, 3,-1,-4, 7,
 -1,-2,-2,-3,-3,-3,-3,-4,-4, 6,
 -3,-4,-4,-5,-7,-2,-4,-5,-3, 1, 5,
 -2, 2, 1,-1,-7, 0,-1,-3,-2,-2,-4, 5,
 -2,-1,-3,-4,-6,-1,-4,-4,-4, 1, 3, 0, 8,
 -4,-4,-4,-7,-6,-6,-6,-5,-2, 0, 0,-6,-1, 8,
  1,-1,-2,-2,-3, 0,-1,-2,-1,-3,-3,-2,-3,-5, 6,
  1,-1, 1, 0,-1,-2,-1, 1,-2,-2,-4,-1,-2,-3, 1, 3,
  1,-2, 0,-1,-3,-2,-2,-1,-3, 0,-3,-1,-1,-4,-1, 2, 4,
 -7, 1,-5,-8,-8,-6,-8,-8,-5,-7,-5,-5,-7,-1,-7,-2,-6, 12,
 -4,-6,-2,-5,-1,-5,-4,-6,-1,-2,-3,-6,-4, 4,-6,-3,-3,-1, 8,
  0,-3,-3,-3,-2,-3,-3,-2,-3, 3, 1,-4, 1,-3,-2,-2, 0,-8,-3, 5,
  0,-2, 3, 4,-6, 0, 3, 0, 1,-3,-4, 0,-4,-5,-2, 0, 0,-6,-3,-3, 4,
 -1,-1, 0, 3,-7, 4, 4,-2, 1,-3,-3,-1,-2,-6,-1,-1,-2,-7,-5,-3, 2, 4,
 -1,-2,-1,-2,-4,-1,-1,-2,-2,-1,-2,-2,-2,-3,-2,-1,-1,-5,-3,-1,-1,-1,-2,
 -1,-2,-1,-2,-4,-1,-1,-2,-2,-1,-2,-2,-2,-3,-2,-1,-1,-5,-3,-1,-1,-1,-2, 6};

/*
#     VTML160
#
# This matrix was produced with scripts written by
# Tobias Mueller and Sven Rahmann [June-2001]. 
#
# VTML160 substitution matrix, Units = Third-Bits
# Expected Score = -1.297840 Third-Bits
# Lowest Score = -7, Highest Score = 16
#
# Entropy H = 0.562489 Bits
#
# 30-Jun-2001 
*/
int avt160[450] = {
  5,
  -2,  7,
  -1,  0,  7,
  -1, -3,  3,  7,
  1, -3, -3, -5, 13,
  -1,  2,  0,  1, -4,  6,
  -1, -1,  0,  3, -5,  2,  6,
  0, -3,  0, -1, -2, -3, -2,  8,
  -2,  1,  1,  0, -2,  2, -1, -3,  9,
  -1, -4, -4, -6, -1, -4, -5, -7, -4,  6,
  -2, -3, -4, -6, -4, -2, -4, -6, -3,  3,  6,
  -1,  4,  0,  0, -4,  2,  1, -2,  0, -4, -3,  5,
  -1, -2, -3, -5, -1, -1, -3, -5, -3,  2,  4, -2,  8,
  -3, -5, -5, -7, -4, -4, -6, -6,  0,  0,  2, -5,  1,  9,
  0, -2, -2, -1, -3, -1, -1, -3, -2, -4, -3, -1, -4, -5,  9,
  1, -1,  1,  0,  1,  0,  0,  0, -1, -3, -3, -1, -3, -3,  0,  4,
  1, -1,  0, -1,  0, -1, -1, -2, -1, -1, -2, -1, -1, -3, -1,  2,  5,
  -5, -4, -5, -7, -7, -6, -7, -5, -1, -2, -1, -5, -4,  3, -5, -4, -6, 16,
  -3, -3, -2, -5, -1, -4, -3, -5,  3, -2, -1, -3, -2,  6, -6, -2, -3,  4, 10,
  0, -4, -4, -4,  1, -3, -3, -5, -3,  4,  2, -3,  1, -1, -3, -2,  0, -5, -3,  5,
  -1, -2,  5,  6, -4,  0,  2, -1,  0, -5, -5,  0, -4, -6, -2,  1,  0, -6, -3, -4,  5,
  -1,  0,  0,  3, -5,  4,  5, -2,  0, -4, -3,  2, -3, -5, -1,  0, -1, -7, -4, -3,  2,  5,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7, -7,  6};

/*
  Matrix made by matblas from blosum50.iij
  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units
  Blocks Database = /data/blocks_5.0/blocks.dat
  Cluster Percentage: >= 50
  Entropy =   0.4808, Expected =  -0.3573
*/
int abl50[450] = {
  5,
 -2, 7,
 -1,-1, 7,
 -2,-2, 2, 8,
 -1,-4,-2,-4,13,
 -1, 1, 0, 0,-3, 7,
 -1, 0, 0, 2,-3, 2, 6,
  0,-3, 0,-1,-3,-2,-3, 8,
 -2, 0, 1,-1,-3, 1, 0,-2,10,
 -1,-4,-3,-4,-2,-3,-4,-4,-4, 5,
 -2,-3,-4,-4,-2,-2,-3,-4,-3, 2, 5,
 -1, 3, 0,-1,-3, 2, 1,-2, 0,-3,-3, 6,
 -1,-2,-2,-4,-2, 0,-2,-3,-1, 2, 3,-2, 7,
 -3,-3,-4,-5,-2,-4,-3,-4,-1, 0, 1,-4, 0, 8,
 -1,-3,-2,-1,-4,-1,-1,-2,-2,-3,-4,-1,-3,-4,10,
  1,-1, 1, 0,-1, 0,-1, 0,-1,-3,-3, 0,-2,-3,-1, 5,
  0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 2, 5,
 -3,-3,-4,-5,-5,-1,-3,-3,-3,-3,-2,-3,-1, 1,-4,-4,-3,15,
 -2,-1,-2,-3,-3,-1,-2,-3, 2,-1,-1,-2, 0, 4,-3,-2,-2, 2, 8,
  0,-3,-3,-4,-1,-3,-3,-4,-4, 4, 1,-3, 1,-1,-3,-2, 0,-3,-1, 5,
 -2,-1, 4, 5,-3, 0, 1,-1, 0,-4,-4, 0,-3,-4,-2, 0, 0,-5,-3,-4, 5,
 -1, 0, 0, 1,-3, 4, 5,-2, 0,-3,-3, 1,-1,-4,-1, 0,-1,-2,-2,-3, 2, 5,
 -1,-1,-1,-1,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1, 0,-3,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-2,-1,-1,-2,-1,-1,-1,-1,-1,-2,-2,-1, 0,-3,-1,-1,-1,-1,-1, 7};

/*
  A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   * */
int a_md10[450]= {
 11,	/* A */
-12, 12,	/* R */
-12,-13, 13,	/* N */
-11,-18, -3, 12,	/* D */
-13,-10,-14,-20, 17,	/* C */
-13, -5,-11,-13,-19, 13,	/* Q */
-10,-15,-12, -2,-22, -5, 12,	/* E */
 -8, -9,-11, -9,-12,-16, -9, 11,	/* G */
-16, -5, -5,-10,-12, -3,-15,-16, 16,	/* H */
-13,-17,-14,-19,-17,-20,-19,-21,-18, 12,	/* I */
-15,-14,-19,-21,-16,-12,-20,-21,-13, -7, 10,	/* L */
-14, -2, -6,-15,-21, -6, -8,-15,-13,-17,-18, 12,	/* K */
-13,-14,-15,-18,-15,-14,-18,-19,-15, -4, -4,-12, 16,	/* M */
-18,-22,-19,-22,-11,-22,-23,-22,-14,-11, -6,-23,-14, 14,	/* F */
 -7,-12,-17,-18,-18, -8,-17,-16,-10,-19,-10,-16,-17,-17, 13,	/* P */
 -5,-10, -4,-12, -7,-13,-15, -7,-11,-14,-13,-13,-15,-11, -6, 11,	/* S */
 -4,-12, -7,-14,-14,-13,-15,-14,-13, -7,-16,-10, -7,-19, -9, -4, 12,	/* T */
-21, -9,-21,-21,-10,-17,-21,-13,-21,-21,-13,-21,-17,-13,-21,-15,-18, 18,	/* W */
-20,-17,-12,-13, -7,-16,-21,-20, -3,-15,-16,-20,-17, -3,-20,-12,-17,-12, 15,	/* Y */
 -6,-17,-17,-15,-12,-17,-14,-13,-19, -1, -8,-18, -5,-12,-16,-14,-10,-16,-18, 11,	/* V */
-12,-15,  5,  5,-17,-12, -7,-10, -7,-16,-20,-11,-17,-21,-17, -8,-10,-22,-13,-16, 13,	/* B */
-16,-18,-17, -8,-32,  1,  9,-17,-17,-29,-26,-11,-24,-34,-21,-21,-21,-29,-29,-22, -9, 13, /* Z */
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9};

int a_md20[450] = {
 10,
-10, 12,
 -9,-10, 13,
 -8,-14, -1, 12,
-10, -7,-11,-16, 17,
-10, -3, -8, -9,-16, 13,
 -7,-11, -9,  1,-19, -3, 11,
 -5, -6, -8, -6, -9,-12, -7, 11,
-12, -3, -2, -7, -9,  0,-12,-13, 15,
-10,-14,-11,-16,-14,-16,-16,-17,-14, 12,
-12,-11,-15,-18,-13, -9,-17,-18,-10, -4, 10,
-11,  0, -4,-12,-17, -3, -5,-12, -9,-14,-15, 12,
 -9,-11,-12,-15,-12,-11,-15,-16,-12, -1, -2, -9, 15,
-15,-19,-16,-19, -8,-18,-20,-19,-11, -8, -4,-19,-10, 13,
 -5, -9,-13,-15,-14, -5,-14,-12, -7,-15, -7,-13,-14,-14, 12,
 -2, -8, -1, -9, -4,-10,-12, -5, -8,-11,-10,-10,-12, -8, -3, 10,
 -1, -9, -4,-11,-10,-10,-12,-11,-10, -4,-12, -7, -4,-15, -7, -1, 11,
-17, -6,-18,-18, -7,-14,-18,-10,-17,-17,-10,-17,-14,-10,-18,-12,-15, 18,
-16,-14, -9,-11, -4,-12,-18,-17,  0,-12,-12,-17,-14,  0,-16, -9,-13, -9, 14,
 -3,-14,-14,-12, -9,-14,-11,-11,-15,  2, -5,-15, -2, -9,-13,-11, -7,-13,-14, 11,
 -9,-12,  6,  6,-14, -9, -4, -7, -4,-13,-17, -8,-13,-18,-14, -5, -7,-19,-10,-13, 12,
-12,-13,-13, -4,-27,  4, 10,-13,-12,-24,-21, -6,-20,-29,-17,-17,-17,-24,-24,-18, -6, 12,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9 };

int a_md40[450] = {
  9,
 -7, 11,
 -6, -6, 12,
 -6,-10,  1, 11,
 -7, -5, -8,-13, 16,
 -7,  0, -5, -6,-12, 12,
 -5, -8, -5,  3,-15,  0, 11,
 -3, -4, -5, -4, -7, -9, -4, 10,
 -9,  0,  0, -4, -6,  2, -8,-10, 14,
 -6,-10, -8,-12,-11,-12,-12,-13,-11, 11,
 -9, -9,-12,-14,-10, -6,-13,-14, -7, -1,  9,
 -8,  3, -1, -8,-12, -1, -3, -9, -6,-11,-12, 11,
 -6, -8, -9,-12, -9, -8,-11,-12, -9,  1,  1, -7, 14,
-11,-15,-12,-15, -5,-14,-16,-15, -7, -5, -1,-16, -7, 13,
 -2, -6, -9,-11,-11, -3,-11, -9, -4,-11, -5,-10,-10,-11, 12,
  0, -5,  1, -6, -2, -7, -8, -2, -6, -8, -7, -7, -8, -6, -1,  9,
  1, -6, -2, -8, -7, -7, -8, -7, -7, -2, -9, -5, -2,-11, -4,  1, 10,
-14, -4,-14,-15, -4,-11,-15, -7,-13,-13, -8,-13,-11, -7,-14, -9,-12, 18,
-13,-10, -6, -8, -2, -9,-14,-13,  2, -9, -9,-13,-11,  2,-13, -7,-10, -6, 14,
 -1,-11,-10, -9, -7,-11, -8, -8,-12,  4, -2,-12,  0, -6, -9, -7, -4,-10,-11, 10,
 -6, -8,  6,  6,-10, -6, -1, -4, -2,-10,-13, -5,-10,-14,-10, -3, -5,-15, -7,-10, 11,
 -8, -8, -8,  0,-21,  6, 10, -8, -7,-18,-16, -3,-15,-23,-12,-12,-12,-19,-18,-14, -3, 11,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9};

/* 
  Matrix made by matblas from blosum62.iij
  * column uses minimum score
  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
  Blocks Database = /data/blocks_5.0/blocks.dat
  Cluster Percentage: >= 62
  Entropy =   0.6979, Expected =  -0.5209
*/

int abl62[450] = {
  4,
 -1, 5,
 -2, 0, 6,
 -2,-2, 1, 6,
  0,-3,-3,-3, 9,
 -1, 1, 0, 0,-3, 5,
 -1, 0, 0, 2,-4, 2, 5,
  0,-2, 0,-1,-3,-2,-2, 6,
 -2, 0, 1,-1,-3, 0, 0,-2, 8,
 -1,-3,-3,-3,-1,-3,-3,-4,-3, 4,
 -1,-2,-3,-4,-1,-2,-3,-4,-3, 2, 4,
 -1, 2, 0,-1,-3, 1, 1,-2,-1,-3,-2, 5,
 -1,-1,-2,-3,-1, 0,-2,-3,-2, 1, 2,-1, 5,
 -2,-3,-3,-3,-2,-3,-3,-3,-1, 0, 0,-3, 0, 6,
 -1,-2,-2,-1,-3,-1,-1,-2,-2,-3,-3,-1,-2,-4, 7,
  1,-1, 1, 0,-1, 0, 0, 0,-1,-2,-2, 0,-1,-2,-1, 4,
  0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1, 1, 5,
 -3,-3,-4,-4,-2,-2,-3,-2,-2,-3,-2,-3,-1, 1,-4,-3,-2,11,
 -2,-2,-2,-3,-2,-1,-2,-3, 2,-1,-1,-2,-1, 3,-3,-2,-2, 2, 7,
  0,-3,-3,-3,-1,-2,-2,-3,-3, 3, 1,-2, 1,-1,-2,-2, 0,-3,-1, 4,
 -2,-1, 3, 4,-3, 0, 1,-1, 0,-3,-4, 0,-3,-3,-2, 0,-1,-4,-3,-3, 4,
 -1, 0, 0, 1,-3, 3, 4,-2, 0,-3,-3, 1,-1,-3,-1, 0,-1,-3,-2,-2, 1, 4,
  0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2, 0, 0,-2,-1,-1,-1,-1,-1,
  0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2, 0, 0,-2,-1,-1,-1,-1,-1, 6};

/* blosum80 in 1/2 bit units (previous versions had 1/3 bit units) */
/*
  Matrix made by matblas from blosum80.iij
  * column uses minimum score
  BLOSUM Clustered Scoring Matrix in 1/2 Bit Units
  Blocks Database = /data/blocks_5.0/blocks.dat
  Cluster Percentage: >= 80
  Entropy =   0.9868, Expected =  -0.7442
*/

int abl80[450] = {
  5,
 -2, 6,
 -2,-1, 6,
 -2,-2, 1, 6,
 -1,-4,-3,-4, 9,
 -1, 1, 0,-1,-4, 6,
 -1,-1,-1, 1,-5, 2, 6,
  0,-3,-1,-2,-4,-2,-3, 6,
 -2, 0, 0,-2,-4, 1, 0,-3, 8,
 -2,-3,-4,-4,-2,-3,-4,-5,-4, 5,
 -2,-3,-4,-5,-2,-3,-4,-4,-3, 1, 4,
 -1, 2, 0,-1,-4, 1, 1,-2,-1,-3,-3, 5,
 -1,-2,-3,-4,-2, 0,-2,-4,-2, 1, 2,-2, 6,
 -3,-4,-4,-4,-3,-4,-4,-4,-2,-1, 0,-4, 0, 6,
 -1,-2,-3,-2,-4,-2,-2,-3,-3,-4,-3,-1,-3,-4, 8,
  1,-1, 0,-1,-2, 0, 0,-1,-1,-3,-3,-1,-2,-3,-1, 5,
  0,-1, 0,-1,-1,-1,-1,-2,-2,-1,-2,-1,-1,-2,-2, 1, 5,
 -3,-4,-4,-6,-3,-3,-4,-4,-3,-3,-2,-4,-2, 0,-5,-4,-4,11,
 -2,-3,-3,-4,-3,-2,-3,-4, 2,-2,-2,-3,-2, 3,-4,-2,-2, 2, 7,
  0,-3,-4,-4,-1,-3,-3,-4,-4, 3, 1,-3, 1,-1,-3,-2, 0,-3,-2, 4,
 -2,-2, 4, 4,-4, 0, 1,-1,-1,-4,-4,-1,-3,-4,-2, 0,-1,-5,-3,-4, 4,
 -1, 0, 0, 1,-4, 3, 4,-3, 0,-4,-3, 1,-2,-4,-2, 0,-1,-4,-3,-3, 0, 4,
 -1,-1,-1,-2,-3,-1,-1,-2,-2,-2,-2,-1,-1,-2,-2,-1,-1,-3,-2,-1,-2,-1,-1,
 -1,-1,-1,-2,-3,-1,-1,-2,-2,-2,-2,-1,-1,-2,-2,-1,-1,-3,-2,-1,-2,-1,-1, 6};

/*	DNA alphabet

	A, C, G, T, U   1-4, 5
	R, Y            6, 7
	M (A or C)	8
	W (A or T)	9
	S (C or G)	10
	K (G or T)	11
	D (not C)	12
	H (not G)	13
	V (not T)	14
	B (not A)	15
	N		16
	X 		17
*/

char nt[MAXSQ+1] ={"\0ACGTURYMWSKDHVBNXACGTURYMWSKDHVBNX\0"};
char ntx[MAXSQ+1]={"\0ACGTURYMWSKDHVBNXacgturymwskdhvbnx\0"};
char ntc[MAXSQ+1]={"\0TGCAAYRKWSMHDBVNXtgcaayrkwsmhdbvnx\0"};

/* nt complement to encoding */
                     /* A:T C:G G:C T:A U:A */
int gc_nt[MAXSQ+1]={ 0,  4,  3,  2,  1,  1, 
                     /* R:Y Y:R M:K W:W */
 		         7,  6, 11,  9,
                     /* S:S K:M D:H H:D */
		        10,  8, 13, 12,
                     /* B:V V:B N:N X:X */
		        15, 14, 16, 16};

int nnt = 17;
int nntx = 34;

int hnt[MAXSQ+1] = {
  NMAP,0,1,2,3,3,0,1,0,0,1,2,0,0,0,1,NMAP,
  NMAP,0,1,2,3,3,0,1,0,0,1,2,0,0,0,1,NMAP,NMAP};
int hntx[MAXSQ+1] = {
  NMAP,0,1,2,3,3,0,1,0,0,1,2,0,0,0,1,NMAP,
  NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,
  NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP,NMAP};

int npam[450] = {
/*       A  C  G  T  U  R  Y  M  W  S  K  D  H  V  B  N  X  */
	 5,						/* A */
	-4, 5,						/* C */
	-4,-4, 5,					/* G */
	-4,-4,-4, 5,					/* T */
	-4,-4,-4, 5, 5,					/* U */
	 2,-1, 2,-1,-1, 2,				/* R (A G)*/
	-1, 2,-1, 2, 2,-2, 2,				/* Y (C T)*/
	 2, 2,-1,-1,-1,-1,-1, 2,			/* M (A C)*/
	 2,-1,-1, 2, 2, 1, 1, 1, 2,			/* W (A T)*/
	-1, 2, 2,-1,-1, 1, 1, 1,-1, 2,			/* S (C G)*/
	-1,-1, 2, 2, 2, 1, 1,-1, 1, 1, 2,		/* K (G T)*/
	 1,-2, 1, 1, 1, 1,-1,-1, 1,-1, 1, 1,		/* D (!C) */
	 1, 1,-2, 1, 1,-1, 1, 1, 1,-1,-1,-1, 1,		/* H (!G) */
	 1, 1, 1,-2,-2, 1,-1, 1,-1, 1,-1,-1,-1, 1,	/* V (!T) */
	-2, 1, 1, 1, 1,-1, 1,-1,-1, 1, 1,-1,-1,-1, 1,	/* B (!A) */
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, /* N */
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1}; /* X */
/*       A  C  G  T  U  R  Y  M  W  S  K  D  H  V  B  N  */

int *pam;			/* Pam matrix- 1D */
int *pam12;
int *pam12x;
int pamh1[MAXSQ+1];		/* used for kfact replacement */

/* Robinson & Robinson counts */
long rrcounts[25] = {
  0,
  35155,
  23105,
  20212,
  24161,
  8669,
  19208,
  28354,
  33229,
  9906,
  23161,
  40625,
  25872,
  10101,
  17367,
  23435,
  32070,
  26311,
  5990,
  14488,
  29012,
  0, 0, 0, 0 };

long rrtotal = 450431;
#else

/* extern char sqnam[]; */
/* extern char sqtype[]; */
/* extern int gdelval, ggapval; */
extern int pamoff;
extern char aa[MAXSQ+1];
extern char aax[MAXSQ+1];
extern char nt[MAXSQ+1];
extern char ntx[MAXSQ+1];
extern char ntc[MAXSQ+1];
extern int gc_nt[MAXSQ+1];

extern  int naa;
extern  int naax;
extern  int nnt;
extern  int nntx;

extern  int haa[MAXSQ+1];
extern  int haax[MAXSQ+1];
extern  int hnt[MAXSQ+1];
extern  int hntx[MAXSQ+1];
/* extern  int had[MAXSQ+1]; */

extern  int apam250[450];
extern  int apam120[450];
extern	int a_md10[450];
extern  int a_md20[450];
extern  int a_md40[450];
extern  int abl50[450];
extern  int abl62[450];
extern  int abl80[450];
extern	int npam[450];
extern	int *pam;
extern  int *pam12;
extern  int *pam12x;
extern	int pamh1[MAXSQ+1];
extern  long rrcounts[25];
extern  long rrtotal;
#endif
#endif
