package Pairwise;

use strict;
use warnings;
use Carp;
use File::Temp;
use base qw(Root Common);

use Run qw(check);

sub path {
  my ( $self, $path ) = @_;
  if ( defined $path ) {
    $self->{path} = $path;
  } else {
    if ( defined $self->{path} ) {
      return $self->{path};
    } else {
      croak "Pairwise::run: path to pairwise not defined";
    }
  }
}

sub run {
  my ( $self, $fasta ) = @_;

  local $/ = undef;
  local $? = 0;

  my $f1 = File::Temp->new->filename;
  my $f2 = File::Temp->new->filename;
  $fasta->write_file($f1);
  my $pairwise = $self->path;
  system("$pairwise $f1 > $f2");
  check( $pairwise, $? ) or croak "Pairwise::run: $pairwise was naughty\n";
  open( my $fh, "<", $f2 );
  my @output = join "\n", split "\n", <$fh>;
  close $fh;
  unlink $f1;
  unlink $f2;

  return @output;
}

sub old_run {
  my ( $self, $fasta ) = @_;

  local ( $/, $? ) = ( undef, 0 );

  my $f = File::Temp->new->filename;
  $fasta->write_file($f);

  my $pid = open my $fh, $self->path . " $f |" or die $!;

  my @output = join "\n", split "\n", <$fh>;

  waitpid $pid, 0;
  check( $self->path, $? ) or die "Pairwise was naughty\n";

  return @output;
}

1;
