package Paths;

use strict;
use warnings;
use base qw(Exporter);
use Sys::Hostname ();

=head1 NAME

Paths - Sets paths for executable programs

=head1 DESCRIPTION

This module gathers together all of the little pieces of information that would other wise be 
floating around in all of the other modules that run external programs. Namely, the path to 
the executable and nessecery environment variables. 

Putting it all here should mean that this is the only file that needs updating when their 
location changes, or it's redeployed. Plus some degree of automagic can be used to try 
and detect changes.

=cut

our @EXPORT_OK = qw(
  $ff_bignet
  $analyze
  $batchman
  $sov
  $pairwise
  $oc
  $jnet
  $fastacmd
  $hmmbuild
  $hmmconvert
  $psiblastbin
  $alscript
  $readseq
  check_OS
  setup_env
);

my $HOME = $ENV{HOME};
#
# main production path
#my $SOFTDIR = '/homes/www-jpred/live/jpred/bin';
#my $platform_dir = "x86_64";
#
# development path
#my $SOFTDIR = '/homes/www-jpred/devel/jpred/bin';
#my $platform_dir = "x86_64";
#
# my laptop test path
my $SOFTDIR       = '/home/asherstnev/Projects/Jpred.project/jpred/branches/portable';
my $platform_name = "x86_64";

our $pairwise    = "$SOFTDIR/$platform_name/pairwise";
our $oc          = "$SOFTDIR/$platform_name/oc";
our $jnet        = "$SOFTDIR/$platform_name/jnet";
our $fastacmd    = "$SOFTDIR/$platform_name/fastacmd";
our $hmmbuild    = "$SOFTDIR/$platform_name/hmmbuild";
our $hmmconvert  = "$SOFTDIR/$platform_name/hmmconvert";
our $psiblastbin = "$SOFTDIR/$platform_name/blastpgp";
our $alscript    = "$SOFTDIR/$platform_name/alscript";
our $readseq     = "$SOFTDIR/$platform_name/readseq";

# required for training with SNNS, but unused currently
our $ff_bignet = "$HOME/projects/Jnet/bin/snns/ff_bignet";    # CC modified for new path (SNNS app)
our $analyze   = "$HOME/projects/Jnet/bin/snns/analyze";      # CC modified for new path (SNNS app)
our $batchman  = "$HOME/projects/Jnet/bin/snns/batchman";     # CC modified for new path (SNNS app)
our $sov       = "$HOME/projects/Jnet/bin/sov";

sub setup_env {
  my $newsoftdir       = shift;
  my $newplatform_name = shift;

  if ( defined $newsoftdir ) {
    if ( -d $newsoftdir ) {
      $SOFTDIR = $newsoftdir;
    } else {
      warn "setup_env: directory with Jpred software $newsoftdir does not exist. The default directory is used...\n";
    }
  }
  if ( defined $newplatform_name ) {
    $platform_name = $newplatform_name;
  }

  $oc          = "$SOFTDIR/$platform_name/oc";
  $jnet        = "$SOFTDIR/$platform_name/jnet";
  $fastacmd    = "$SOFTDIR/$platform_name/fastacmd";
  $pairwise    = "$SOFTDIR/$platform_name/pairwise";
  $hmmbuild    = "$SOFTDIR/$platform_name/hmmbuild";
  $psiblastbin = "$SOFTDIR/$platform_name/blastpgp";
  $hmmconvert  = "$SOFTDIR/$platform_name/hmmconvert";
  $alscript    = "$SOFTDIR/$platform_name/alscript";
  $readseq     = "$SOFTDIR/$platform_name/readseq";
}

sub check_OS {
  if ( "linux" eq $^O or "Linux" eq $^O ) {
    my $status = system "uname -m > .platform";
    open my $PLH, "<", ".platform" or die "can't check platform information";
    my $plt = <$PLH>;
    close $PLH;
    chop $plt;
    $platform_name = "i686" if ( $plt =~ /i[3-6]86/ );
  } elsif ( "MSWin32" eq $^O ) {
    $platform_name = "win";
  } else {
    warn "check_OS: unknown platform, I'll try to use x86_64 binaries....";
  }

  $oc          = "$SOFTDIR/$platform_name/oc";
  $jnet        = "$SOFTDIR/$platform_name/jnet";
  $fastacmd    = "$SOFTDIR/$platform_name/fastacmd";
  $pairwise    = "$SOFTDIR/$platform_name/pairwise";
  $hmmbuild    = "$SOFTDIR/$platform_name/hmmbuild";
  $psiblastbin = "$SOFTDIR/$platform_name/blastpgp";
  $hmmconvert  = "$SOFTDIR/$platform_name/hmmconvert";
  $alscript    = "$SOFTDIR/$platform_name/alscript";
  $readseq     = "$SOFTDIR/$platform_name/readseq";

  return $platform_name;
}

=head1 AUTOMATED CHANGES

Currently the paths are altered on the basis of per host rules.

=cut

1;
