/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine;

import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class SubmissionManager {
    private static final Logger log = Logger.getLogger(SubmissionManager.class);
    static final Map<String, Future<ConfiguredExecutable<?>>> submittedTasks = new ConcurrentHashMap();

    private SubmissionManager() {
    }

    public static void addTask(ConfiguredExecutable<?> configuredExecutable, Future<ConfiguredExecutable<?>> future) {
        Future<ConfiguredExecutable<?>> future2 = submittedTasks.put(configuredExecutable.getTaskId(), future);
        if (future2 != null) {
            log.fatal("Duplicated task id is detected by local engine for: " + configuredExecutable);
            throw new RuntimeException("Duplicated task ID is detected: " + configuredExecutable.getTaskId());
        }
    }

    public static Future<ConfiguredExecutable<?>> getTask(String string) {
        return submittedTasks.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTask(ConfiguredExecutable<?> configuredExecutable) {
        Map<String, Future<ConfiguredExecutable<?>>> map = submittedTasks;
        synchronized (map) {
            assert (configuredExecutable != null);
            String string = configuredExecutable.getTaskId();
            assert (EngineUtil.isValidJobId(string));
            submittedTasks.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTask(String string) {
        Map<String, Future<ConfiguredExecutable<?>>> map = submittedTasks;
        synchronized (map) {
            if (EngineUtil.isValidJobId(string)) {
                submittedTasks.remove(string);
            } else {
                log.error("Invalid key is given! " + string);
            }
        }
    }
}

