/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.client;

import compbio.metadata.Option;
import compbio.util.Util;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class CommandBuilder<T> {
    private static final Logger log = Logger.getLogger(CommandBuilder.class);
    Map<String, Parameter> paramList;
    String nameValueSeparator;

    private CommandBuilder() {
    }

    public CommandBuilder(String string) {
        this.paramList = new LinkedHashMap<String, Parameter>();
        this.nameValueSeparator = string;
    }

    public void addParams(List<String> list) {
        for (String string : list) {
            this.setParam(string);
        }
    }

    public void setParams(List<String> list) {
        this.paramList.clear();
        this.addParams(list);
    }

    Parameter newParameter(String string) {
        if (Util.isEmpty(string)) {
            throw new NullPointerException("Param must be provided!");
        }
        if (this.isCombinedValue(string)) {
            return new Parameter(this.getName(string), this.getValue(string));
        }
        return new Parameter(string);
    }

    boolean isCombinedValue(String string) {
        return string.contains(this.nameValueSeparator);
    }

    public boolean hasParam(String string) {
        return this.paramList.containsKey(string);
    }

    String getName(String string) {
        assert (string.indexOf(this.nameValueSeparator) >= 0) : "The value does not look like a combined value (key+value). Value:" + string;
        return string.substring(0, string.indexOf(this.nameValueSeparator));
    }

    String getValue(String string) {
        assert (string.indexOf(this.nameValueSeparator) >= 0) : "The value does not look like a combined value (key+value). Value:" + string;
        return string.substring(string.indexOf(this.nameValueSeparator) + 1);
    }

    public boolean setFirst(String string) {
        Parameter parameter = this.newParameter(string);
        parameter.setFirst();
        return this.setParam(parameter);
    }

    public boolean setParam(String string) {
        return this.setParam(this.newParameter(string));
    }

    boolean setParam(Parameter parameter) {
        boolean bl;
        boolean bl2 = bl = this.paramList.put(parameter.name, parameter) != null;
        if (bl) {
            log.warn("Key " + parameter.name + " in the command list has been overriden! ");
        }
        return bl;
    }

    public boolean setLast(String string) {
        Parameter parameter = this.newParameter(string);
        parameter.setLast();
        return this.setParam(parameter);
    }

    public boolean setLast(String string, String string2) {
        if (Util.isEmpty(string)) {
            throw new NullPointerException("ParamName must be provided!");
        }
        if (string2 != null && string.contains(this.nameValueSeparator)) {
            log.warn("WARN: paramName " + string + " contains nameValue separator. Removing the separator...");
            string = string.trim().substring(0, string.length() - 1);
        }
        if (string2 != null && string.contains(this.nameValueSeparator)) {
            throw new IllegalArgumentException("Parameter name '" + string + "' contains name value separator character '" + this.nameValueSeparator + "'!");
        }
        Parameter parameter = new Parameter(string, string2);
        parameter.setLast();
        return this.setParam(parameter);
    }

    public String getParamValue(String string) {
        Parameter parameter = this.paramList.get(string);
        return parameter == null ? null : parameter.value;
    }

    public boolean removeParam(String string) {
        return this.paramList.remove(string) != null;
    }

    public boolean setParam(String string, String string2) {
        return this.setParam(new Parameter(string, string2));
    }

    public List<String> getCommands() {
        return this.parameterToString(this.getCommandList());
    }

    public String getCommandString() {
        String string = "";
        for (Parameter parameter : this.getCommandList()) {
            string = string + parameter.toCommand(this.nameValueSeparator) + " ";
        }
        return string;
    }

    List<String> parameterToString(List<Parameter> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Parameter parameter : list) {
            if (this.isWhiteSpaceSeparator()) {
                arrayList.add(parameter.name);
                if (parameter.value == null) continue;
                arrayList.add(parameter.value);
                continue;
            }
            arrayList.add(parameter.toCommand(this.nameValueSeparator));
        }
        return arrayList;
    }

    public static <T> CommandBuilder<T> newCommandBuilder(List<? extends Option<T>> list, String string) {
        CommandBuilder<T> commandBuilder = new CommandBuilder<T>(string);
        for (Option<T> option : list) {
            String string2 = option.toCommand(string);
            log.trace("Setting parameter " + string2);
            commandBuilder.setParam(string2);
        }
        return commandBuilder;
    }

    public int size() {
        return this.paramList.size();
    }

    boolean isWhiteSpaceSeparator() {
        return this.nameValueSeparator.trim().length() == 0;
    }

    List<Parameter> getCommandList() {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        Parameter parameter = null;
        Parameter parameter2 = null;
        for (Parameter parameter3 : this.paramList.values()) {
            if (parameter3.isFirst()) {
                assert (parameter == null) : "Attempting to set more the one parameter as FIRST! Parameter which has been set is: " + parameter + "\n Parameters to be set is " + parameter3;
                parameter = parameter3;
                arrayList.add(0, parameter);
                continue;
            }
            if (parameter3.isLast()) {
                assert (parameter2 == null) : "Attempting to set more the one parameter as LAST! Parameter which has been set is: " + parameter2 + "\n Parameters to be set is " + parameter3;
                parameter2 = parameter3;
                continue;
            }
            arrayList.add(parameter3);
        }
        if (parameter2 != null) {
            arrayList.add(parameter2);
        }
        return arrayList;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.nameValueSeparator == null ? 0 : this.nameValueSeparator.hashCode());
        n = 31 * n + (this.paramList == null ? 0 : ((Object)this.paramList).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CommandBuilder commandBuilder = (CommandBuilder)object;
        if (this.nameValueSeparator == null ? commandBuilder.nameValueSeparator != null : !this.nameValueSeparator.equals(commandBuilder.nameValueSeparator)) {
            return false;
        }
        if (this.paramList == null && commandBuilder.paramList != null) {
            return false;
        }
        if (commandBuilder.paramList == null && this.paramList != null) {
            return false;
        }
        if (this.paramList.size() != commandBuilder.paramList.size()) {
            return false;
        }
        for (Map.Entry<String, Parameter> entry : this.paramList.entrySet()) {
            String string = entry.getKey();
            Parameter parameter = commandBuilder.paramList.get(string);
            if (parameter == null) {
                return false;
            }
            if (parameter.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String string = "NameValueSeparator: " + this.nameValueSeparator + "\n";
        for (Map.Entry<String, Parameter> entry : this.paramList.entrySet()) {
            string = string + "Key: " + entry.getKey() + "\n" + " Value: " + entry.getValue() + "\n";
        }
        return string;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class Parameter {
        @XmlTransient
        private static final int LAST = -100;
        @XmlTransient
        private static final int FIRST = -200;
        private int position = -1;
        String name;
        String value;

        Parameter() {
        }

        Parameter(String string) {
            this.name = string;
        }

        Parameter(String string, String string2) {
            this(string);
            this.value = string2;
        }

        void setLast() {
            this.position = -100;
        }

        void setFirst() {
            this.position = -200;
        }

        void setAtPosition(int n) {
            throw new UnsupportedOperationException();
        }

        boolean isLast() {
            return this.position == -100;
        }

        boolean isFirst() {
            return this.position == -200;
        }

        String toCommand(String string) {
            if (this.value == null) {
                return this.name;
            }
            return this.name + string + this.value;
        }

        public String toString() {
            String string = "Name: " + this.name + "\n";
            if (string != null) {
                string = string + "Value: " + string + "\n";
            }
            if (this.position == -100) {
                string = string + "Position: LAST\n";
            } else if (this.position == -200) {
                string = string + "Position: FIRST\n";
            } else if (this.position != -1) {
                string = string + "Position:" + this.position + "\n";
            }
            return string;
        }

        public int hashCode() {
            int n = 1;
            n = 7 * n + (this.name == null ? 0 : this.name.hashCode());
            n = 7 * n + this.position;
            n = 7 * n + (this.value == null ? 0 : this.value.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)object;
            if (this.name == null ? parameter.name != null : !this.name.equals(parameter.name)) {
                return false;
            }
            if (this.position != parameter.position) {
                return false;
            }
            return !(this.value == null ? parameter.value != null : !this.value.equals(parameter.value));
        }
    }
}

