/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.client;

import compbio.engine.Configurator;
import compbio.engine.client.ConfExecutable;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.Executable;
import compbio.engine.client.PathValidator;
import compbio.engine.client.RunConfiguration;
import compbio.engine.conf.PropertyHelperManager;
import compbio.metadata.JobStatus;
import compbio.metadata.LimitsManager;
import compbio.metadata.ResultNotAvailableException;
import compbio.util.FileUtil;
import compbio.util.PropertyHelper;
import compbio.util.SysPrefs;
import compbio.util.Util;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.Map;
import org.apache.log4j.Logger;

public final class EngineUtil {
    private static final PropertyHelper ph = PropertyHelperManager.getPropertyHelper();
    private static final Logger log = Logger.getLogger(EngineUtil.class);

    public static boolean isValidJobId(String string) {
        if (Util.isEmpty(string)) {
            return false;
        }
        int n = string.indexOf("#");
        if (n < 0) {
            return false;
        }
        String string2 = string.substring(n + "#".length());
        try {
            Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            log.debug("Invalid key! " + numberFormatException.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public static void writeStatFile(String string, String string2) {
        if (!Util.isEmpty(string)) {
            EngineUtil.writeFile(string, string2, new Long(System.currentTimeMillis()).toString(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String string, String string2, String string3, boolean bl) {
        FileWriter fileWriter;
        File file;
        block7: {
            file = null;
            if (Util.isEmpty(string)) {
                log.debug("Calling compbio.engine.Util.writeFile() with not work directory. Skipping writing statistics!");
                return;
            }
            assert (!Util.isEmpty(string3)) : "Content expected!";
            fileWriter = null;
            file = new File(string, string2);
            if (!file.exists() || bl) break block7;
            FileUtil.closeSilently(log, fileWriter);
            return;
        }
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(string3);
            fileWriter.close();
            log.debug("File " + string2 + " with content: " + string3 + " has been recorder successfully! ");
        }
        catch (IOException iOException) {
            try {
                log.error("Could not record the " + string2 + " file in " + string + " for local execution! Ignoring... " + iOException.getMessage());
            }
            catch (Throwable throwable) {
                FileUtil.closeSilently(log, fileWriter);
                throw throwable;
            }
            FileUtil.closeSilently(log, (Closeable)fileWriter);
        }
        FileUtil.closeSilently(log, (Closeable)fileWriter);
    }

    public static final boolean writeMarker(String string, JobStatus jobStatus) {
        block10: {
            block9: {
                if (jobStatus == null) {
                    throw new NullPointerException("MarkerType must be provided!");
                }
                if (jobStatus == JobStatus.FINISHED) break block9;
                if (jobStatus != JobStatus.STARTED) break block10;
            }
            throw new IllegalArgumentException("Please use Util.writeStatFile(workDirectory, fileAndEventName) to record FINISHED and STARTED statuses!");
        }
        if (!PathValidator.isValidDirectory(string)) {
            log.warn("Attempting to write " + (Object)((Object)jobStatus) + " marker in the work directory " + string + " is not provided or does not exist!");
            return false;
        }
        try {
            File file = new File(string, jobStatus.toString());
            if (!file.exists()) {
                return file.createNewFile();
            }
        }
        catch (IOException iOException) {
            log.error("Could not record stat marker file " + (Object)((Object)jobStatus) + " into the directory " + string + " ! " + iOException.getMessage(), iOException.getCause());
        }
        return false;
    }

    public static boolean isMarked(String string, JobStatus jobStatus) {
        if (!PathValidator.isValidDirectory(string)) {
            throw new NullPointerException("Work directory " + string + " is not provided or does not exist!");
        }
        return new File(string, jobStatus.toString()).exists();
    }

    public static Map<String, String> mergeEnvVariables(Map<String, String> map, Map<String, String> map2) {
        if (map2.containsKey("PATH")) {
            String string = map2.get("PATH");
            String string2 = map.get("PATH");
            String string3 = map.get("PATH".toLowerCase());
            boolean bl = false;
            String string4 = map.get("Path");
            if (string2 != null) {
                map.put("PATH", string2 + File.pathSeparator + string);
                bl = true;
            }
            if (string3 != null) {
                map.put("PATH".toLowerCase(), string3 + File.pathSeparator + string);
                bl = true;
            }
            if (string4 != null) {
                map.put("Path", string4 + File.pathSeparator + string);
                bl = true;
            }
            if (!bl) {
                map.put("PATH", string);
            }
            map2.remove("PATH");
        }
        map.putAll(map2);
        return map;
    }

    public static String convertToAbsolute(String string) {
        String string2 = string;
        if (!PathValidator.isAbsolutePath(string)) {
            string2 = PropertyHelperManager.getLocalPath() + string;
            log.trace("Changing local path in enviromental variable to absolute: FROM " + string + " TO " + string2);
        }
        return string2;
    }

    public static String getExecProperty(String string, Executable<?> executable) {
        assert (!Util.isEmpty(string));
        assert (executable != null);
        return EngineUtil.getExecProperty(string, executable.getClass());
    }

    public static String getExecProperty(String string, Class<?> clazz) {
        assert (!Util.isEmpty(string));
        assert (clazz != null);
        String string2 = clazz.getSimpleName().toLowerCase() + "." + string.toLowerCase();
        log.trace("Processing property: " + string2);
        return ph.getProperty(string2);
    }

    public static String getFullPath(String string, String string2) {
        assert (!Util.isEmpty(string2)) : "Filename must be provided! ";
        assert (!Util.isEmpty(string)) : "Workdirectory must be provided! ";
        return string + File.separator + string2;
    }

    public static String getCommand(Executable.ExecProvider execProvider, Class<?> clazz) {
        if (execProvider == Executable.ExecProvider.Any) {
            throw new IllegalArgumentException("A particular execution environment must be chosen");
        }
        String string = clazz.getSimpleName().toLowerCase();
        String string2 = "";
        if (execProvider == Executable.ExecProvider.Local) {
            string2 = SysPrefs.isWindows ? ph.getProperty("local." + string + ".bin.windows") : ph.getProperty("local." + string + ".bin");
            if (EngineUtil.isJavaLibrary(clazz) && Util.isEmpty(string2)) {
                string2 = EngineUtil.getJava();
            }
            if (!(Util.isEmpty(string2) || PathValidator.isAbsolutePath(string2) || (string2 = string2.trim()).equalsIgnoreCase("java") || string2.equalsIgnoreCase("java.exe"))) {
                string2 = PropertyHelperManager.getLocalPath() + string2;
            }
        } else {
            string2 = ph.getProperty("cluster." + string + ".bin");
        }
        log.debug("Using executable: " + string2);
        return string2;
    }

    public static boolean isJavaLibrary(Class<?> clazz) {
        String string = clazz.getSimpleName().toLowerCase();
        String string2 = ph.getProperty(string + ".jar.file");
        return !Util.isEmpty(string2);
    }

    public static String getJava() {
        String string = System.getProperty("java.home");
        if (Util.isEmpty(string)) {
            string = System.getenv("JAVA_HOME");
        }
        if (Util.isEmpty(string)) {
            log.warn("Cannot find Java in java.home system property or JAVA_HOME environment variable! ");
            return null;
        }
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            File file2;
            String string2 = string + File.separator + "bin" + File.separator + "java";
            if (SysPrefs.isWindows) {
                string2 = string2 + ".exe";
            }
            if ((file2 = new File(string2)).exists() && file2.isFile() && file2.canExecute()) {
                log.info("Using Java from: " + file2.getAbsolutePath());
                return file2.getAbsolutePath();
            }
            log.warn("Cannot find java executable in the JAVA_HOME!");
        } else {
            log.warn("JAVA_HOME does not seems to point to a valid directory! Value: " + string);
        }
        return null;
    }

    public static Executable.ExecProvider getSupportedRuntimes(Class<?> clazz) {
        boolean bl = false;
        boolean bl2 = false;
        String string = clazz.getSimpleName().toLowerCase();
        String string2 = ph.getProperty("local." + string + ".bin.windows");
        String string3 = ph.getProperty("local." + string + ".bin");
        bl = !Util.isEmpty(string2) || !Util.isEmpty(string3) ? true : EngineUtil.isJavaLibrary(clazz) && EngineUtil.getJava() != null;
        String string4 = ph.getProperty("cluster." + string + ".bin");
        if (!Util.isEmpty(string4)) {
            bl2 = true;
        }
        if (bl && bl2) {
            return Executable.ExecProvider.Any;
        }
        if (bl) {
            return Executable.ExecProvider.Local;
        }
        if (bl2) {
            return Executable.ExecProvider.Cluster;
        }
        throw new InvalidParameterException("Executable is not provided for any runtime environments");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConfiguredExecutable<?> loadExecutable(String string) throws ResultNotAvailableException {
        String string2 = Configurator.getWorkDirectory(string);
        FileInputStream fileInputStream = null;
        ConfiguredExecutable<?> configuredExecutable = null;
        try {
            fileInputStream = new FileInputStream(string2 + File.separator + "RunnerConfig.xml");
            RunConfiguration runConfiguration = RunConfiguration.load(fileInputStream);
            configuredExecutable = ConfExecutable.newConfExecutable(runConfiguration);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                log.error("Could not find run configuration to load!" + fileNotFoundException.getLocalizedMessage(), fileNotFoundException.getCause());
                throw new ResultNotAvailableException("Could not find run configuration to load!" + fileNotFoundException.getMessage(), fileNotFoundException.getCause());
                catch (IOException iOException) {
                    log.error("IO Exception while reading run configuration file!" + iOException.getLocalizedMessage(), iOException.getCause());
                    throw new ResultNotAvailableException("Could not load run configuration!" + iOException.getMessage(), iOException.getCause());
                }
            }
            catch (Throwable throwable) {
                FileUtil.closeSilently(log, fileInputStream);
                throw throwable;
            }
        }
        FileUtil.closeSilently(log, (Closeable)fileInputStream);
        return configuredExecutable;
    }

    public static <T> LimitsManager<T> getLimits(Class<T> clazz) {
        LimitsManager<T> limitsManager = null;
        try {
            limitsManager = ConfExecutable.getRunnerLimits(clazz);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.warn("No limits are found for " + clazz + " executable! " + fileNotFoundException.getLocalizedMessage(), fileNotFoundException.getCause());
        }
        catch (IOException iOException) {
            log.warn("IO exception while attempting to read limits for " + clazz + " executable! " + iOException.getLocalizedMessage(), iOException.getCause());
        }
        return limitsManager;
    }
}

