/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.client;

import compbio.engine.client.EngineUtil;
import compbio.engine.client.PathValidator;
import compbio.util.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EnvVariableProcessor {
    public static final String PATH = "PATH";
    private static Logger log = Logger.getLogger(EnvVariableProcessor.class);
    private static final String PROP_NAME_VALUE_SEPARATOR = "#";
    private static final String NEXT_ENV_PROPERTY_DELIMITER = ";";
    private static final String mafft_binaries = "MAFFT_BINARIES";
    private static final String fasta4mafft = "FASTA_4_MAFFT";
    private static final String iupred_path = "IUPred_PATH";

    static boolean containsMultipleVariables(String string) {
        String[] stringArray = string.split(NEXT_ENV_PROPERTY_DELIMITER);
        return stringArray.length != 0;
    }

    static String[] getEnvVariableList(String string) {
        if (EnvVariableProcessor.containsMultipleVariables(string = string.trim())) {
            return string.split(NEXT_ENV_PROPERTY_DELIMITER);
        }
        return new String[]{string};
    }

    static String getEnvVariableName(String string) {
        return string.split(PROP_NAME_VALUE_SEPARATOR)[0];
    }

    static String getEnvVariableValue(String string) {
        String[] stringArray = string.split(PROP_NAME_VALUE_SEPARATOR);
        if (stringArray.length > 2) {
            throw new IllegalArgumentException("Must be only one value per property! Make sure the property does not contain '#' symbol!");
        }
        if (stringArray.length == 0 || stringArray.length == 1) {
            log.warn("Environmental variable '" + string + "' does not have a value!");
            return "";
        }
        return stringArray[1];
    }

    static boolean isValidEnvVariableProperty(String string) {
        if (string == null) {
            return false;
        }
        return string.contains(PROP_NAME_VALUE_SEPARATOR);
    }

    public static Map<String, String> getEnvVariables(String string, Class<?> clazz) {
        HashMap<String, String> hashMap = Util.getNewHashMap();
        if (!EnvVariableProcessor.isValidEnvVariableProperty(string)) {
            return Collections.emptyMap();
        }
        for (String string2 : EnvVariableProcessor.getEnvVariableList(string)) {
            if (!EnvVariableProcessor.isValidEnvVariableProperty(string2)) {
                log.error(clazz.getName() + " environment variable is specified by is NOT VALID! Skipping. " + "Valid format is propertyName" + PROP_NAME_VALUE_SEPARATOR + "propertyValue. " + "Given values is: " + string2);
            }
            string2 = string2.trim();
            String string3 = EnvVariableProcessor.getEnvVariableName(string2);
            String string4 = EnvVariableProcessor.getEnvVariableValue(string2);
            if (!PathValidator.isAbsolutePath(string4) && ((string3 = string3.trim()).equalsIgnoreCase(mafft_binaries) || string3.equalsIgnoreCase(fasta4mafft) || string3.equalsIgnoreCase(iupred_path))) {
                string4 = EngineUtil.convertToAbsolute(string4);
            }
            hashMap.put(string3, string4);
        }
        return hashMap;
    }
}

