/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.client;

import compbio.util.Util;
import java.io.File;
import java.util.List;

public final class PathValidator {
    public static boolean isValidExecutable(String string) {
        if (Util.isEmpty(string)) {
            return false;
        }
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        if (!file.canExecute()) {
            try {
                return file.setExecutable(true);
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public static void validateExecutable(String string) throws IllegalArgumentException {
        if (!PathValidator.isValidExecutable(string)) {
            throw new IllegalArgumentException("External executable: " + string + " could not be found or executed. Under *nix systems check that the executable flag is set!");
        }
    }

    public static boolean isValidDirectory(String string) {
        if (Util.isEmpty(string)) {
            return false;
        }
        File file = new File(string);
        return file.exists() && file.isDirectory() && file.canRead();
    }

    public static void validatePathNames(List<String> list, String string) throws IllegalArgumentException {
        for (String string2 : list) {
            if (!PathValidator.isAbsolutePath(string2)) continue;
            throw new IllegalArgumentException("Working directory cannot be set as absolute paths are defined for at least some of the " + string + " files! This is not advisable. Violating path is : " + string2);
        }
    }

    public static boolean isAbsolutePath(String string) {
        assert (string != null) : "Path is NULL! Not NULL path expected";
        return new File(string).isAbsolute();
    }

    public static void validateDirectory(String string) throws IllegalArgumentException {
        if (!PathValidator.isValidDirectory(string)) {
            throw new IllegalArgumentException("Working directory: " + string + " is inaccessible or does not exist!");
        }
    }
}

