/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.cluster.drmaa;

import compbio.engine.AsyncExecutor;
import compbio.engine.Cleaner;
import compbio.engine.Configurator;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.Util;
import compbio.engine.cluster.drmaa.ClusterSession;
import compbio.engine.cluster.drmaa.ClusterUtil;
import compbio.engine.cluster.drmaa.JobRunner;
import compbio.metadata.JobStatus;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.ResultNotAvailableException;
import org.apache.log4j.Logger;
import org.ggf.drmaa.DrmaaException;

public class AsyncJobRunner
implements AsyncExecutor {
    private static Logger log = Logger.getLogger(AsyncJobRunner.class);

    @Override
    public String submitJob(ConfiguredExecutable<?> configuredExecutable) throws JobSubmissionException {
        JobRunner jobRunner = new JobRunner(configuredExecutable);
        jobRunner.submitJob();
        return configuredExecutable.getTaskId();
    }

    @Override
    public boolean cancelJob(String string) {
        ClusterSession clusterSession = ClusterSession.getInstance();
        return ClusterUtil.cancelJob(string, clusterSession);
    }

    @Override
    public JobStatus getJobStatus(String string) {
        return JobRunner.getJobStatus(string);
    }

    @Override
    public boolean cleanup(String string) {
        String string2 = Configurator.getWorkDirectory(string);
        return Cleaner.deleteAllFiles(string2);
    }

    @Override
    public ConfiguredExecutable<?> getResults(String string) throws ResultNotAvailableException {
        ConfiguredExecutable<?> configuredExecutable;
        assert (Util.isValidJobId(string));
        ClusterSession clusterSession = ClusterSession.getInstance();
        try {
            configuredExecutable = clusterSession.getResults(string);
        }
        catch (DrmaaException drmaaException) {
            log.error(drmaaException.getLocalizedMessage(), drmaaException.getCause());
            throw new ResultNotAvailableException(drmaaException);
        }
        return configuredExecutable;
    }

    @Override
    public String getWorkDirectory(String string) {
        return Configurator.getWorkDirectory(string);
    }
}

