/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.cluster.drmaa;

import compbio.engine.Configurator;
import compbio.engine.client.Util;
import compbio.engine.cluster.drmaa.ClusterSession;
import compbio.metadata.JobExecutionException;
import compbio.metadata.JobStatus;
import java.io.IOException;
import java.text.NumberFormat;
import org.apache.log4j.Logger;
import org.ggf.drmaa.DrmaaException;
import org.ggf.drmaa.JobInfo;
import org.ggf.drmaa.Session;

public class ClusterUtil {
    private static final Logger log = Logger.getLogger(ClusterUtil.class);
    public static final NumberFormat CLUSTER_STAT_IN_SEC = NumberFormat.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean cancelJob(String string, ClusterSession clusterSession) {
        assert (Util.isValidJobId(string));
        boolean bl = true;
        Session session = clusterSession.getSession();
        try {
            log.info("Job " + string + " is successfully cancelled");
            Util.writeMarker(Configurator.getWorkDirectory(string), JobStatus.CANCELLED);
            session.control(ClusterSession.getClusterJobId(string).getJobId(), 4);
        }
        catch (DrmaaException drmaaException) {
            log.error("Job " + string + " cancellation failed!");
            log.error("Cause: " + drmaaException.getLocalizedMessage(), drmaaException.getCause());
            bl = false;
        }
        catch (IOException iOException) {
            log.error("Could not read JOBID file to determine cluster jobid for taskid: " + string + " Message: " + iOException.getLocalizedMessage(), iOException.getCause());
        }
        finally {
            log.trace("Job " + string + " has been successfully removed from the cluster engine job list");
            clusterSession.removeJob(string);
        }
        return bl;
    }

    public static final JobInfo waitForResult(ClusterSession clusterSession, String string) throws JobExecutionException {
        JobInfo jobInfo = null;
        assert (Util.isValidJobId(string));
        try {
            jobInfo = clusterSession.waitForJob(string);
        }
        catch (DrmaaException drmaaException) {
            log.error(drmaaException.getLocalizedMessage(), drmaaException.getCause());
            throw new JobExecutionException(drmaaException);
        }
        catch (IOException iOException) {
            log.error("Could not read JOBID file for job " + string + " Message " + iOException.getMessage(), iOException.getCause());
            throw new JobExecutionException(iOException);
        }
        finally {
            clusterSession.removeJob(string);
        }
        return jobInfo;
    }

    static {
        CLUSTER_STAT_IN_SEC.setMinimumFractionDigits(4);
    }
}

