/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.cluster.drmaa;

import compbio.util.Util;
import java.util.Date;
import java.util.Map;
import org.ggf.drmaa.DrmaaException;
import org.ggf.drmaa.JobInfo;

public class StatisticManager {
    private final Map<String, String> usage;
    final JobInfo jobinfo;
    private static String newLine = "\n";
    String signal = "signal";
    String submission_time = "submission_time";
    String vmem = "vmem";
    String maxvmem = "maxvmem";
    String ru_stime = "ru_stime";
    String ru_utime = "ru_utime";
    String ru_wallclock = "ru_wallclock";
    String end_time = "end_time";
    String start_time = "start_time";
    String iow = "iow";
    String cpu = "cpu";
    String io = "io";
    String priority = "priority";
    String exit_status = "exit_status";
    String acct_cpu = "acct_cpu";
    String acct_mem = "acct_mem";
    String acct_iow = "acct_iow";
    String acct_io = "acct_io";
    String acct_maxvmem = "acct_maxvmem";

    public StatisticManager(JobInfo jobInfo) throws DrmaaException {
        Map map;
        assert (jobInfo != null);
        this.jobinfo = jobInfo;
        this.usage = map = jobInfo.getResourceUsage();
    }

    public String getJobId() throws DrmaaException {
        return this.jobinfo.getJobId();
    }

    public boolean hasExited() throws DrmaaException {
        return this.jobinfo.hasExited();
    }

    public boolean hasSignaled() throws DrmaaException {
        return this.jobinfo.hasSignaled();
    }

    public boolean hasDump() throws DrmaaException {
        return this.jobinfo.hasCoreDump();
    }

    public String termSignal() throws DrmaaException {
        return this.jobinfo.getTerminatingSignal();
    }

    public boolean wasAborted() throws DrmaaException {
        return this.jobinfo.wasAborted();
    }

    public String getSubmissionTime() {
        return this.usage.get(this.submission_time);
    }

    public String getVMem() {
        return this.usage.get(this.vmem);
    }

    public String getMaxVMem() {
        return this.usage.get(this.maxvmem);
    }

    public String getUsedSysTime() {
        return this.usage.get(this.ru_stime);
    }

    public String getUsedUserTime() {
        return this.usage.get(this.ru_utime);
    }

    public String getCalculationTime() {
        return this.usage.get(this.ru_wallclock);
    }

    public String getEndTime() {
        return this.usage.get(this.end_time);
    }

    public String getStartTime() {
        return this.usage.get(this.start_time);
    }

    public String getIOWait() {
        return this.usage.get(this.iow);
    }

    public String getCPUUsageTime() {
        return this.usage.get(this.cpu);
    }

    public String getDataTransfered() {
        return this.usage.get(this.io);
    }

    public String getJobPriority() {
        return this.usage.get(this.priority);
    }

    public String getExitStatus() {
        return this.usage.get(this.exit_status);
    }

    public String getAllStats() throws DrmaaException {
        String string = "JobID: " + this.getJobId() + newLine;
        string = string + this.getExecutionStat() + newLine;
        string = string + this.getTimeStat() + newLine;
        string = string + this.getCPUTimeStat() + newLine;
        string = string + this.getMemoryStat() + newLine;
        return string;
    }

    public String getExecutionStat() throws DrmaaException {
        String string = "Priority:" + this.getJobPriority() + newLine;
        string = this.wasAborted() ? string + "job \"" + this.getJobId() + "\" was aborted (never ran)" + newLine : (this.hasExited() ? string + "job \"" + this.getJobId() + "\" finished regularly with exit status " + this.getExitStatus() + newLine : (this.hasSignaled() ? string + "job \"" + this.getJobId() + "\" finished due to signal " + this.termSignal() + newLine : string + "job \"" + this.getJobId() + "\" finished with unclear conditions" + newLine));
        string = string + "Has Core Dump: " + this.hasDump() + newLine;
        return string;
    }

    public String getMemoryStat() {
        String string = "Data transfered: " + this.getDataTransfered() + newLine;
        string = string + "IO wait: " + this.getIOWait() + newLine;
        string = string + "Max Virtual Memory: " + this.getMaxVMem() + newLine;
        string = string + "Virtual Memory: " + this.getVMem() + newLine;
        return string;
    }

    public String getCPUTimeStat() {
        String string = "CPU time (s): " + this.getCPUUsageTime() + newLine;
        string = string + "Sys time (s): " + this.getUsedSysTime() + newLine;
        string = string + "User time (s): " + this.getUsedUserTime() + newLine;
        return string;
    }

    public String getTimeStat() {
        String string = "Submission time: " + this.formatTime(this.getSubmissionTime()) + newLine;
        string = string + "Calculation time (s): " + this.getCalculationTime() + newLine;
        string = string + "Start time: " + this.formatTime(this.getStartTime()) + newLine;
        string = string + "End time: " + this.formatTime(this.getEndTime()) + newLine;
        return string;
    }

    public Map<String, String> getRawUsage() {
        return this.usage;
    }

    public String toString() {
        String string = "";
        try {
            string = this.getAllStats();
        }
        catch (DrmaaException drmaaException) {
            throw new RuntimeException("exception during toString execution! ", drmaaException);
        }
        return string;
    }

    String formatTime(String string) {
        int n = string.indexOf(".");
        if (n > 0) {
            string = string.substring(0, n);
            Date date = new Date();
            date.setTime(Long.parseLong(string + "000"));
            string = Util.datef.format(date);
        }
        return string;
    }
}

