/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.local;

import compbio.engine.Cleaner;
import compbio.engine.Configurator;
import compbio.engine.SubmissionManager;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import compbio.metadata.JobStatus;
import compbio.metadata.ResultNotAvailableException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public final class LocalEngineUtil {
    private static final Logger log = Logger.getLogger(LocalEngineUtil.class);

    static RuntimeException launderThrowable(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new IllegalStateException("Checked exception being thrown and unwrapped by LocalRunner.launderThrowable method", throwable);
    }

    public static boolean cancelJob(Future<ConfiguredExecutable<?>> future, String string) {
        EngineUtil.writeMarker(string, JobStatus.CANCELLED);
        log.debug("Cancelling local job from work directory " + string);
        return future.cancel(true);
    }

    public static JobStatus getJobStatus(Future<ConfiguredExecutable<?>> future) {
        if (future == null) {
            throw new NullPointerException("Future must be provided!");
        }
        if (future.isCancelled()) {
            return JobStatus.CANCELLED;
        }
        if (future.isDone()) {
            return JobStatus.FINISHED;
        }
        return JobStatus.RUNNING;
    }

    public static JobStatus getRecordedJobStatus(String string) {
        String string2 = Configurator.getWorkDirectory(string);
        if (EngineUtil.isMarked(string2, JobStatus.FINISHED) || EngineUtil.isMarked(string2, JobStatus.COLLECTED)) {
            return JobStatus.FINISHED;
        }
        if (EngineUtil.isMarked(string2, JobStatus.CANCELLED)) {
            return JobStatus.CANCELLED;
        }
        if (EngineUtil.isMarked(string2, JobStatus.FAILED)) {
            return JobStatus.FAILED;
        }
        return JobStatus.UNDEFINED;
    }

    public static boolean cleanup(ConfiguredExecutable<?> configuredExecutable) {
        if (configuredExecutable == null) {
            throw new NullPointerException("Future must be provided!");
        }
        return Cleaner.deleteFiles(configuredExecutable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfiguredExecutable<?> getResults(Future<ConfiguredExecutable<?>> future, String string) throws ResultNotAvailableException {
        ConfiguredExecutable<?> configuredExecutable = null;
        try {
            configuredExecutable = future.get();
            if (configuredExecutable == null) {
                throw new ResultNotAvailableException("Job return null as a Result! Job work directory is " + Configurator.getWorkDirectory(string) + " Job id is " + string);
            }
            EngineUtil.writeMarker(Configurator.getWorkDirectory(string), JobStatus.COLLECTED);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            EngineUtil.writeMarker(Configurator.getWorkDirectory(string), JobStatus.FAILED);
            log.debug("Cancelling job due to Interruption");
            future.cancel(true);
        }
        catch (ExecutionException executionException) {
            EngineUtil.writeMarker(Configurator.getWorkDirectory(string), JobStatus.FAILED);
            log.debug("Job execution exception: " + executionException.getLocalizedMessage(), executionException.getCause());
            LocalEngineUtil.launderThrowable(executionException.getCause());
        }
        finally {
            future.cancel(true);
            SubmissionManager.removeTask(string);
        }
        return configuredExecutable;
    }
}

