/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.local;

import compbio.engine.conf.PropertyHelperManager;
import compbio.util.PropertyHelper;
import compbio.util.Util;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public final class LocalExecutorService
extends ThreadPoolExecutor {
    private static final Logger log = Logger.getLogger(LocalExecutorService.class);
    private static final String threadNumPropName = "engine.local.thread.number";
    private static LocalExecutorService INSTANCE = null;
    private final ThreadLocal<Long> startTime = new ThreadLocal();
    private final AtomicLong numTasks = new AtomicLong();
    private final AtomicLong totalTime = new AtomicLong();

    private LocalExecutorService(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        super(n, n2, l, timeUnit, blockingQueue);
    }

    public static synchronized LocalExecutorService getExecutor() {
        if (INSTANCE == null) {
            INSTANCE = LocalExecutorService.init();
        }
        log.info("Current Active Threads Count: " + INSTANCE.getActiveCount());
        return INSTANCE;
    }

    private static LocalExecutorService init() {
        int n = Runtime.getRuntime().availableProcessors();
        if (n < 1) {
            n = 1;
        }
        if (n > 4) {
            --n;
        }
        PropertyHelper propertyHelper = PropertyHelperManager.getPropertyHelper();
        String string = propertyHelper.getProperty(threadNumPropName);
        log.debug("Thread number for local execution from conf file is " + string);
        int n2 = 0;
        if (!Util.isEmpty(string)) {
            try {
                n2 = Integer.parseInt(string);
                if (n2 > 1 && n2 < n * 2) {
                    n = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                log.error("Cannot understand engine.local.thread.number property. Expecting whole number, but given " + string);
            }
        }
        log.debug("Constructing thread pool for executor with " + n + " thread(s)");
        LocalExecutorService localExecutorService = new LocalExecutorService(n, n, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LocalExecutorService.shutDown();
            }
        });
        return localExecutorService;
    }

    public static void shutDown() {
        if (INSTANCE != null) {
            INSTANCE.shutdownNow();
        }
    }

    public boolean canAcceptMoreWork() {
        return INSTANCE.getMaximumPoolSize() > INSTANCE.getActiveCount();
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        log.info(String.format("Thread %s: start %s", thread, runnable));
        this.startTime.set(System.nanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        try {
            long l = System.nanoTime();
            long l2 = l - this.startTime.get();
            this.numTasks.incrementAndGet();
            this.totalTime.addAndGet(l2);
            log.info(String.format("Throwable %s: end %s, time=%dns", throwable, runnable, l2));
        }
        finally {
            super.afterExecute(runnable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void terminated() {
        try {
            if (this.numTasks.get() != 0L) {
                log.info(String.format("Terminated : avg time=%dns", this.totalTime.get() / this.numTasks.get()));
            }
        }
        finally {
            super.terminated();
        }
    }
}

