/*
 * Decompiled with CFR 0.152.
 */
package compbio.runner.disorder;

import compbio.data.sequence.Score;
import compbio.data.sequence.ScoreManager;
import compbio.data.sequence.SequenceUtil;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.engine.client.SkeletalExecutable;
import compbio.metadata.ResultNotAvailableException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class IUPred
extends SkeletalExecutable<IUPred> {
    private static Logger log = Logger.getLogger(IUPred.class);
    private static final String GLOB_OUTPUT = "out.glob";
    private static final String SHORT_OUTPUT = "out.short";
    private static final String LONG_OUTPUT = "out.long";

    @Override
    public ScoreManager getResults(String string) throws ResultNotAvailableException {
        ScoreManager scoreManager = null;
        try {
            File file;
            File file2;
            TreeMap<String, Set<Score>> treeMap = new TreeMap<String, Set<Score>>();
            File file3 = new File(string, SHORT_OUTPUT);
            if (file3.exists()) {
                this.combineScores(treeMap, SequenceUtil.readIUPred(file3));
            }
            if ((file2 = new File(string, LONG_OUTPUT)).exists()) {
                this.combineScores(treeMap, SequenceUtil.readIUPred(file2));
            }
            if ((file = new File(string, GLOB_OUTPUT)).exists()) {
                this.combineScores(treeMap, SequenceUtil.readIUPred(file));
            }
            if (treeMap.isEmpty()) {
                throw new ResultNotAvailableException("Could not find any result files for the job: " + string);
            }
            scoreManager = ScoreManager.newInstance(treeMap);
        }
        catch (IOException iOException) {
            log.error(iOException.getMessage(), iOException.getCause());
            throw new ResultNotAvailableException(iOException);
        }
        catch (UnknownFileFormatException unknownFileFormatException) {
            log.error(unknownFileFormatException.getMessage(), unknownFileFormatException.getCause());
            throw new ResultNotAvailableException(unknownFileFormatException);
        }
        catch (NullPointerException nullPointerException) {
            log.error(nullPointerException.getMessage(), nullPointerException.getCause());
            throw new ResultNotAvailableException(nullPointerException);
        }
        return scoreManager;
    }

    void combineScores(Map<String, Set<Score>> map, Map<String, Score> map2) {
        Set<Object> set;
        if (map2 == null) {
            return;
        }
        if (map.isEmpty()) {
            for (String string : map2.keySet()) {
                set = new TreeSet();
                map.put(string, set);
            }
        }
        for (String string : map2.keySet()) {
            set = map.get(string);
            assert (set != null);
            Score score = map2.get(string);
            set.add(score);
            map.put(string, set);
        }
    }

    public IUPred setInput(String string) {
        super.setInput(string);
        this.cbuilder.setFirst(string);
        return this;
    }

    public IUPred setOutput(String string) {
        log.warn("IUpred output is predefined and cannot be set!");
        return this;
    }

    UnsupportedOperationException newUnsupportedOutputException() {
        return new UnsupportedOperationException("The outputs from this executable are always either of those 3 files (depending on the method called): out.glob, out.short, out.long");
    }

    @Override
    public String getOutput() {
        log.warn("IUpred output is predefined and is one of the three files (depending on the method called): out.glob, out.short, out.long");
        return LONG_OUTPUT;
    }

    @Override
    public Class<IUPred> getType() {
        return this.getClass();
    }
}

