/*
 * Decompiled with CFR 0.152.
 */
package compbio.runner.msa;

import compbio.data.sequence.Alignment;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.engine.client.CommandBuilder;
import compbio.engine.client.Executable;
import compbio.engine.client.SkeletalExecutable;
import compbio.metadata.ResultNotAvailableException;
import compbio.runner.RunnerUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class ClustalO
extends SkeletalExecutable<ClustalO> {
    private static Logger log = Logger.getLogger(ClustalO.class);
    private static final String EXEC_STAT_FILE = "stat.log";
    public static final String KEY_VALUE_SEPARATOR = "=";
    private static final String ncorePrm = "--threads";
    private int ncoreNumber = 0;

    public ClustalO() {
        super(KEY_VALUE_SEPARATOR);
        this.addParameters(Arrays.asList("--outfmt=clustal", "-v", "--log=stat.log"));
        this.setInput(this.inputFile);
        this.setOutput(this.outputFile);
        this.setError(this.errorFile);
    }

    public ClustalO setOutput(String string) {
        super.setOutput(string);
        this.cbuilder.setParam("--outfile=" + string);
        return this;
    }

    public ClustalO setInput(String string) {
        super.setInput(string);
        this.cbuilder.setParam("--infile=" + string);
        return this;
    }

    @Override
    public Alignment getResults(String string) throws ResultNotAvailableException {
        try {
            return RunnerUtil.readClustalFile(string, this.getOutput());
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error(fileNotFoundException.getMessage(), fileNotFoundException.getCause());
            throw new ResultNotAvailableException(fileNotFoundException);
        }
        catch (IOException iOException) {
            log.error(iOException.getMessage(), iOException.getCause());
            throw new ResultNotAvailableException(iOException);
        }
        catch (UnknownFileFormatException unknownFileFormatException) {
            log.error(unknownFileFormatException.getMessage(), unknownFileFormatException.getCause());
            throw new ResultNotAvailableException(unknownFileFormatException);
        }
        catch (NullPointerException nullPointerException) {
            log.error(nullPointerException.getMessage(), nullPointerException.getCause());
            throw new ResultNotAvailableException(nullPointerException);
        }
    }

    public static String getStatFile() {
        return EXEC_STAT_FILE;
    }

    @Override
    public Class<ClustalO> getType() {
        return this.getClass();
    }

    @Override
    public CommandBuilder<ClustalO> getParameters(Executable.ExecProvider execProvider) {
        int n;
        if (this.ncoreNumber == 0) {
            this.setNCore(1);
        }
        if (execProvider == Executable.ExecProvider.Cluster && (n = SkeletalExecutable.getClusterCpuNum(this.getType())) != 0) {
            this.setNCore(n);
        }
        return super.getParameters(execProvider);
    }

    public void setNCore(int n) {
        if (n < 1 || n > 100) {
            throw new IndexOutOfBoundsException("Number of cores must be within 1 and 100 ");
        }
        this.ncoreNumber = n;
        this.cbuilder.setParam(ncorePrm, Integer.toString(this.getNCore()));
    }

    int getNCore() {
        return this.ncoreNumber;
    }
}

