/*
 * Decompiled with CFR 0.152.
 */
package compbio.stat.collector;

import compbio.engine.Cleaner;
import compbio.engine.client.PathValidator;
import compbio.stat.collector.JobDirectory;
import compbio.stat.collector.JobStat;
import java.io.File;
import java.io.FileFilter;
import java.util.Date;
import org.apache.log4j.Logger;

public class DirCleaner
implements Runnable {
    static final int UNDEFINED = -1;
    private static final Logger log = Logger.getLogger(DirCleaner.class);
    private final File workDirectory;
    private final int LifeSpanInHours;
    static FileFilter directories = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && !file.getName().startsWith(".");
        }
    };

    public DirCleaner(String string, int n) {
        log.info("Starting cleaning for directory: " + string);
        log.info("Maximum allowed directory life span (h): " + n);
        if (!PathValidator.isValidDirectory(string)) {
            throw new IllegalArgumentException("workDirectory '" + string + "' does not exist!");
        }
        this.workDirectory = new File(string);
        this.LifeSpanInHours = n;
    }

    boolean hasCompleted(JobDirectory jobDirectory) {
        JobStat jobStat = jobDirectory.getJobStat();
        return jobStat.hasResult() || jobStat.getIsCancelled() || jobStat.getIsFinished();
    }

    boolean livesOverLifeSpan(JobDirectory jobDirectory) {
        long l = (System.currentTimeMillis() - jobDirectory.jobdir.lastModified()) / 3600000L;
        log.debug("lifetime = " + l + ", lifespan = " + this.LifeSpanInHours);
        return l > (long)this.LifeSpanInHours;
    }

    void doCleaning() {
        File[] fileArray;
        for (File file : fileArray = this.workDirectory.listFiles(directories)) {
            JobDirectory jobDirectory = new JobDirectory(file);
            Date date = new Date(file.lastModified());
            log.debug("Directory " + file.getName() + " has timestamp: " + date);
            if (this.livesOverLifeSpan(jobDirectory)) {
                if (Cleaner.deleteDirectory(this.workDirectory.getAbsolutePath() + File.separator + file.getName())) {
                    log.error("Directory " + file.getName() + " failed to deleted...");
                    continue;
                }
                log.debug("Directory " + file.getName() + " is deleted");
                continue;
            }
            log.debug("Directory " + file.getName() + " is too new and kept");
        }
    }

    @Override
    public void run() {
        log.info("Started cleaning job directory at " + new Date());
        log.info("For directory: " + this.workDirectory.getAbsolutePath());
        this.doCleaning();
        log.info("Finished cleaning job directory at " + new Date());
    }
}

