/*
 * Decompiled with CFR 0.152.
 */
package compbio.stat.collector;

import compbio.util.FileUtil;
import compbio.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;

public class InputFilter {
    private static final Logger log = Logger.getLogger(InputFilter.class);

    static boolean accept(File file) {
        if (file == null) {
            return true;
        }
        assert (file.isFile()) : "Input file is not a file! " + file;
        String[] stringArray = ">Foo\nMTADGPRELLQLRAAVRHRPQDFVAWLMLADAELGMGDTTAGEMAVQRGLALHPGHPEAV\n>Bar\nASDAAPEHPGIALWLHALEDAGQAEAAAAYTRAHQLLPEEPYITAQLLNAVA\n".split("\n");
        assert (stringArray.length == 4);
        String[] stringArray2 = ">Foo\nMTADGPRELLQLRAAVRHRPQDFVAWLMLADAELGMGDTTAGEMAVQRGLALHPGHPEAV--------\n>Bar\nASDAAPEH------------PGIALWLHALE-DAGQAEAAA---AYTRAHQLLPEEPYITAQLLNAVA\n".split("\n");
        assert (stringArray2.length == 4);
        String[] stringArray3 = "CLUSTAL\nFoo             C-UUGCGUUAAUGAGAACAGAAACG-UAAA--CUAUAA-CCUAG-G-GGUUUCUGUUGGA\nBar             G-UGGCGCUUAUGACGCAGUUGUCU-UAAA-CUCGAAC--UCGA-GCGGGCAAUUGCUGA\nFoo             UGGUUG----GCAAC\nBar             U-UACGAUUAACCAC".split("\n");
        assert (stringArray2.length == 5);
        boolean bl = InputFilter.compareLines(file, stringArray);
        if (!bl) {
            bl = InputFilter.compareLines(file, stringArray2);
        }
        if (!bl) {
            bl = InputFilter.compareClustalLines(file, stringArray3);
        }
        return !bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compareLines(File file, String[] stringArray) {
        BufferedReader bufferedReader = null;
        boolean bl = true;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            for (int i = 0; i < stringArray.length; ++i) {
                String string = bufferedReader.readLine();
                if (Util.isEmpty(string)) {
                    bl = false;
                    break;
                }
                if ((string = string.trim()).equals(stringArray[i].trim())) continue;
                bl = false;
                break;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            try {
                log.warn(iOException, iOException.getCause());
            }
            catch (Throwable throwable) {
                FileUtil.closeSilently(bufferedReader);
                throw throwable;
            }
            FileUtil.closeSilently(bufferedReader);
        }
        FileUtil.closeSilently(bufferedReader);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compareClustalLines(File file, String[] stringArray) {
        BufferedReader bufferedReader = null;
        boolean bl = true;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file));
            int n = 0;
            while (null != (string = bufferedReader.readLine())) {
                if (Util.isEmpty(string)) continue;
                if (!(string = string.trim()).equals(stringArray[n].trim())) {
                    bl = false;
                    break;
                }
                ++n;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            try {
                log.warn(iOException, iOException.getCause());
            }
            catch (Throwable throwable) {
                FileUtil.closeSilently(bufferedReader);
                throw throwable;
            }
            FileUtil.closeSilently(bufferedReader);
        }
        FileUtil.closeSilently(bufferedReader);
        return bl;
    }
}

