/*
 * Decompiled with CFR 0.152.
 */
package compbio.stat.servlet;

import compbio.engine.conf.PropertyHelperManager;
import compbio.stat.collector.StatDB;
import compbio.stat.servlet.util.RefreshIterator;
import compbio.stat.servlet.util.Scheduler;
import compbio.stat.servlet.util.SchedulerTask;
import compbio.stat.servlet.util.StatCollection;
import compbio.stat.servlet.util.Totals;
import compbio.util.PropertyHelper;
import compbio.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AnnualStat
extends HttpServlet {
    private static final Logger log = Logger.getLogger(AnnualStat.class);
    private static PropertyHelper ph = PropertyHelperManager.getPropertyHelper();
    private final Scheduler scheduler = new Scheduler();

    private static int getIntProperty(String string) {
        int n = 0;
        if (!Util.isEmpty(string)) {
            string = string.trim();
            n = Integer.parseInt(string);
        }
        return n;
    }

    static int refreshUsageStatsFrequency() {
        return AnnualStat.getIntProperty(ph.getProperty("local.usage.stats.refresh.frequency"));
    }

    public void init() {
        int n = Calendar.getInstance().get(11);
        int n2 = Calendar.getInstance().get(12);
        int n3 = Calendar.getInstance().get(13);
        final int n4 = AnnualStat.refreshUsageStatsFrequency();
        this.scheduler.schedule(new SchedulerTask(){

            @Override
            public void run() {
                this.refreshCache();
            }

            private void refreshCache() {
                AnnualStat.this.hitEndpointForRefresh();
                log.info("Refreshing the In Memory Cache...");
                log.info(String.format("Refreshing again in %d minutes", n4));
            }
        }, new RefreshIterator(n, n2, n3, n4));
    }

    public void clearContextCache() {
        try {
            this.getServletConfig().getServletContext().removeAttribute("usageStatsResults");
            this.getServletConfig().getServletContext().removeAttribute("usageStatsTimestamp");
            this.getServletConfig().getServletContext().removeAttribute("usageStatsStart");
            this.getServletConfig().getServletContext().removeAttribute("usageStatsEnd");
            log.info("In Memory Cache Cleared!");
        }
        catch (Exception exception) {
            log.warn("In Memory Cache Not Cleared. Perhaps not available yet!");
        }
    }

    private void hitEndpointForRefresh() {
        String string = (String)this.getServletConfig().getServletContext().getAttribute("usageStatsURL");
        if (string != null) {
            try {
                URL uRL = new URL(string);
                System.out.println(string);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestProperty("User-Agent", "JABAWS Usage Stats Refreshing the Context Cache");
                int n = httpURLConnection.getResponseCode();
                log.info(String.format("Hitting %s with an internal user-agent! status code: %s", string, n));
            }
            catch (IOException iOException) {
                log.warn("Something wrong when hitting " + string);
                log.warn(iOException);
            }
        }
    }

    public Map<Date, Totals> checkMonthlyTotals(HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            System.out.println("Updating the Usage Stats In Memory Cache...");
            StatDB statDB = new StatDB();
            Date date = statDB.getEarliestRecord();
            if (date == null) {
                PrintWriter printWriter = httpServletResponse.getWriter();
                printWriter.println("No statistics found in the database. Please allow at least one hour after a server start for the statistics collector to collect the data. ");
                printWriter.close();
                return null;
            }
            return StatCollection.getStats(date);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new ServletException((Throwable)sQLException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        long l;
        Map map;
        long l2;
        String string2 = new String();
        String string3 = new String();
        string3 = httpServletRequest.getRequestURL().toString();
        System.out.println("UR: " + string3);
        this.getServletConfig().getServletContext().setAttribute("usageStatsURL", (Object)string3);
        String string4 = new String();
        string4 = httpServletRequest.getHeader("user-agent");
        if (this.getServletConfig().getServletContext().getAttribute("usageStatsResults") == null || string4.equals("JABAWS Usage Stats Refreshing the Context Cache")) {
            l2 = System.nanoTime();
            map = this.checkMonthlyTotals(httpServletResponse);
            l = System.nanoTime();
            if (map == null) return;
            this.clearContextCache();
            this.getServletConfig().getServletContext().setAttribute("usageStatsResults", (Object)map);
            string2 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(Calendar.getInstance().getTime());
            this.getServletConfig().getServletContext().setAttribute("usageStatsTimestamp", (Object)string2);
            this.getServletConfig().getServletContext().setAttribute("usageStatsStart", (Object)l2);
            this.getServletConfig().getServletContext().setAttribute("usageStatsEnd", (Object)l);
            string = String.valueOf(AnnualStat.refreshUsageStatsFrequency());
            this.getServletConfig().getServletContext().setAttribute("usageStatsRefreshFreq", (Object)string);
        } else {
            map = (Map)this.getServletConfig().getServletContext().getAttribute("usageStatsResults");
            string2 = (String)this.getServletConfig().getServletContext().getAttribute("usageStatsTimestamp");
            l2 = (Long)this.getServletConfig().getServletContext().getAttribute("usageStatsStart");
            l = (Long)this.getServletConfig().getServletContext().getAttribute("usageStatsEnd");
            string = (String)this.getServletConfig().getServletContext().getAttribute("usageStatsRefreshFreq");
        }
        httpServletRequest.setAttribute("stat", (Object)map);
        httpServletRequest.setAttribute("total", (Object)Totals.sumOfTotals(map));
        httpServletRequest.setAttribute("timeexec", (Object)((l - l2) / 1000000000L));
        httpServletRequest.setAttribute("timestamp", (Object)string2);
        httpServletRequest.setAttribute("refreshfreq", (Object)string);
        RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher("statpages/MonthlySummary.jsp");
        httpServletRequest.setAttribute("isAdmin", (Object)AnnualStat.isAdmin(httpServletRequest));
        requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    static boolean isAdmin(HttpServletRequest httpServletRequest) {
        return httpServletRequest.isUserInRole("admin");
    }
}

