/*
 * Decompiled with CFR 0.152.
 */
package compbio.stat.servlet.util;

import compbio.stat.collector.StatDB;
import compbio.stat.collector.StatProcessor;
import compbio.stat.servlet.util.Totals;
import compbio.ws.client.Services;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class StatCollection {
    private Map<Services, StatProcessor> allStat;
    private Map<Services, StatProcessor> clusterStat;
    private Map<Services, StatProcessor> localStat;
    private static final Logger log = Logger.getLogger(StatCollection.class);

    public Map<Services, StatProcessor> getAllStat() {
        return this.allStat;
    }

    public Map<Services, StatProcessor> getClusterStat() {
        return this.clusterStat;
    }

    public Map<Services, StatProcessor> getLocalStat() {
        return this.localStat;
    }

    public static Map<Date, Totals> getStats(int n) throws SQLException {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.add(2, -n);
        return StatCollection.getStats(calendar.getTime());
    }

    public static Map<Date, Totals> getStats(Date date) throws SQLException {
        TreeMap<Date, Totals> treeMap = new TreeMap<Date, Totals>();
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        Calendar calendar2 = GregorianCalendar.getInstance();
        calendar2.setTime(new Date());
        if (calendar.after(calendar2)) {
            throw new AssertionError((Object)"From Date must be before ToDate! ");
        }
        while (calendar.before(calendar2)) {
            Date date2 = calendar.getTime();
            calendar.add(2, 1);
            treeMap.put(date2, StatCollection.getJobCounts(date2, calendar.getTime()));
        }
        return treeMap;
    }

    private static Totals getJobCounts(Date date, Date date2) throws SQLException {
        StatDB statDB = new StatDB();
        Totals totals = new Totals();
        Timestamp timestamp = new Timestamp(date.getTime());
        Timestamp timestamp2 = new Timestamp(date2.getTime());
        totals.total = statDB.getTotalJobsCount(timestamp, timestamp2);
        totals.incomplete = statDB.getIncompleteCount(timestamp, timestamp2);
        totals.abandoned = statDB.getAbandonedCount(timestamp, timestamp2);
        totals.cancelled = statDB.getCancelledCount(timestamp, timestamp2);
        log.trace("Job counts: total = " + totals.total + ", incomplete = " + totals.incomplete + ", abandoned = " + totals.abandoned + ", cancelled = " + totals.cancelled);
        return totals;
    }

    public static StatCollection newStatCollecton(Date date, Date date2) throws SQLException {
        Timestamp timestamp = new Timestamp(date.getTime());
        Timestamp timestamp2 = new Timestamp(date2.getTime());
        StatCollection statCollection = new StatCollection();
        StatDB statDB = new StatDB();
        statCollection.allStat = new TreeMap<Services, StatProcessor>();
        for (Services services : Services.values()) {
            statCollection.allStat.put(services, new StatProcessor(statDB.readData(timestamp, timestamp2, services, null)));
        }
        statCollection.clusterStat = new TreeMap<Services, StatProcessor>();
        for (Services services : Services.values()) {
            statCollection.clusterStat.put(services, new StatProcessor(statDB.readData(timestamp, timestamp2, services, true)));
        }
        statCollection.localStat = new TreeMap<Services, StatProcessor>();
        for (Services services : Services.values()) {
            statCollection.localStat.put(services, new StatProcessor(statDB.readData(timestamp, timestamp2, services, false)));
        }
        return statCollection;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.allStat == null ? 0 : ((Object)this.allStat).hashCode());
        n = 31 * n + (this.clusterStat == null ? 0 : ((Object)this.clusterStat).hashCode());
        n = 31 * n + (this.localStat == null ? 0 : ((Object)this.localStat).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StatCollection statCollection = (StatCollection)object;
        if (this.allStat == null ? statCollection.allStat != null : !((Object)this.allStat).equals(statCollection.allStat)) {
            return false;
        }
        if (this.clusterStat == null ? statCollection.clusterStat != null : !((Object)this.clusterStat).equals(statCollection.clusterStat)) {
            return false;
        }
        return !(this.localStat == null ? statCollection.localStat != null : !((Object)this.localStat).equals(statCollection.localStat));
    }

    public String toString() {
        String string = "";
        for (Map.Entry<Services, StatProcessor> entry : this.allStat.entrySet()) {
            string = string + (Object)((Object)entry.getKey()) + ": ";
            string = string + entry.getValue() + "\n";
        }
        for (Map.Entry<Services, StatProcessor> entry : this.clusterStat.entrySet()) {
            string = string + (Object)((Object)entry.getKey()) + ": ";
            string = string + entry.getValue() + "\n";
        }
        for (Map.Entry<Services, StatProcessor> entry : this.localStat.entrySet()) {
            string = string + (Object)((Object)entry.getKey()) + ": ";
            string = string + entry.getValue() + "\n";
        }
        return string;
    }

    public static enum Stattype {
        CLUSTER,
        LOCAL,
        ALL;

    }
}

