/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.server;

import compbio.data.msa.MsaWS;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.Program;
import compbio.engine.AsyncExecutor;
import compbio.engine.Configurator;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import compbio.engine.client.Executable;
import compbio.engine.client.SkeletalExecutable;
import compbio.metadata.ChunkHolder;
import compbio.metadata.JobStatus;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Limit;
import compbio.metadata.LimitsManager;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.RunnerConfig;
import compbio.metadata.WrongParameterException;
import compbio.runner.RunnerUtil;
import compbio.runner.msa.ClustalO;
import compbio.ws.server.WSUtil;
import java.io.File;
import java.util.List;
import javax.jws.WebService;
import org.apache.log4j.Logger;

@WebService(endpointInterface="compbio.data.msa.MsaWS", targetNamespace="http://msa.data.compbio/01/12/2010/", serviceName="ClustalOWS")
public class ClustalOWS
implements MsaWS<ClustalO> {
    private static Logger log = Logger.getLogger(ClustalOWS.class);
    private static final RunnerConfig<ClustalO> clustalOptions = RunnerUtil.getSupportedOptions(ClustalO.class);
    private static final PresetManager<ClustalO> clustalPresets = RunnerUtil.getPresets(ClustalO.class);
    private static final LimitsManager<ClustalO> limitMan = EngineUtil.getLimits(new ClustalO().getType());

    @Override
    public String align(List<FastaSequence> list) throws JobSubmissionException {
        WSUtil.validateFastaInput(list);
        ConfiguredExecutable<ClustalO> configuredExecutable = this.init(list);
        return WSUtil.align(list, configuredExecutable, log, "align", this.getLimit(""));
    }

    ConfiguredExecutable<ClustalO> init(List<FastaSequence> list) throws JobSubmissionException {
        int n;
        ClustalO clustalO = new ClustalO();
        clustalO.setInput("input.txt");
        clustalO.setOutput("result.txt");
        clustalO.setError("error.txt");
        ConfiguredExecutable<ClustalO> configuredExecutable = Configurator.configureExecutable(clustalO, list);
        if (configuredExecutable.getExecProvider() == Executable.ExecProvider.Cluster && (n = SkeletalExecutable.getClusterCpuNum(clustalO.getType())) != 0) {
            clustalO.setNCore(n);
        }
        return configuredExecutable;
    }

    @Override
    public String presetAlign(List<FastaSequence> list, Preset<ClustalO> preset) throws JobSubmissionException, WrongParameterException {
        WSUtil.validateFastaInput(list);
        if (preset == null) {
            throw new WrongParameterException("Preset must be provided!");
        }
        Limit<ClustalO> limit = this.getLimit(preset.getName());
        ConfiguredExecutable<ClustalO> configuredExecutable = this.init(list);
        configuredExecutable.addParameters(preset.getOptions());
        return WSUtil.align(list, configuredExecutable, log, "presetAlign", limit);
    }

    @Override
    public String customAlign(List<FastaSequence> list, List<Option<ClustalO>> list2) throws JobSubmissionException, WrongParameterException {
        WSUtil.validateFastaInput(list);
        ConfiguredExecutable<ClustalO> configuredExecutable = this.init(list);
        List<String> list3 = WSUtil.getCommands(list2, "=");
        configuredExecutable.addParameters(list3);
        log.info("Setting parameters: " + list3);
        return WSUtil.align(list, configuredExecutable, log, "customAlign", this.getLimit(""));
    }

    @Override
    public RunnerConfig<ClustalO> getRunnerOptions() {
        return clustalOptions;
    }

    @Override
    public Alignment getResult(String string) throws ResultNotAvailableException {
        WSUtil.validateJobId(string);
        AsyncExecutor asyncExecutor = Configurator.getAsyncEngine(string);
        ConfiguredExecutable<?> configuredExecutable = asyncExecutor.getResults(string);
        Alignment alignment = (Alignment)configuredExecutable.getResults();
        return new Alignment(alignment.getSequences(), Program.ClustalO, '-');
    }

    @Override
    public Limit<ClustalO> getLimit(String string) {
        if (limitMan == null) {
            return null;
        }
        Limit<ClustalO> limit = limitMan.getLimitByName(string);
        return limit;
    }

    @Override
    public LimitsManager<ClustalO> getLimits() {
        return limitMan;
    }

    @Override
    public boolean cancelJob(String string) {
        WSUtil.validateJobId(string);
        boolean bl = WSUtil.cancelJob(string);
        return bl;
    }

    @Override
    public JobStatus getJobStatus(String string) {
        WSUtil.validateJobId(string);
        JobStatus jobStatus = WSUtil.getJobStatus(string);
        return jobStatus;
    }

    @Override
    public PresetManager<ClustalO> getPresets() {
        return clustalPresets;
    }

    @Override
    public ChunkHolder pullExecStatistics(String string, long l) {
        WSUtil.validateJobId(string);
        String string2 = Configurator.getWorkDirectory(string) + File.separator + ClustalO.getStatFile();
        ChunkHolder chunkHolder = WSUtil.pullFile(string2, l);
        return chunkHolder;
    }
}

