/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.server;

import compbio.engine.conf.PropertyHelperManager;
import compbio.stat.ga.AnalyticsConfigData;
import compbio.stat.ga.GoogleAnalyticsTracker;
import compbio.util.PropertyHelper;
import compbio.util.Util;
import compbio.ws.client.Services;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class GAUtils {
    static final String VERSION_TYPE = "WAR";
    private static final Logger log = Logger.getLogger(GAUtils.class);
    static PropertyHelper PROP_HELPER = PropertyHelperManager.getPropertyHelper();
    private static AnalyticsConfigData config = new AnalyticsConfigData("UA-5356328-1");
    private static GoogleAnalyticsTracker TRACKER = new GoogleAnalyticsTracker(config);
    static final boolean IS_GA_ENABLED = GAUtils.isGoogleAnalyticsEnabled();
    private static String SERVER_ADDRESS = GAUtils.getServerIP();

    private static boolean isGoogleAnalyticsEnabled() {
        String string = PROP_HELPER.getProperty("enable.ga");
        if (Util.isEmpty(string)) {
            return false;
        }
        return "yes".equalsIgnoreCase(string = string.trim()) || "true".equalsIgnoreCase(string);
    }

    private static String getServerIP() {
        String string = "127.0.0.1";
        if (!GAUtils.anonymizeIP()) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                string = inetAddress.getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return string;
    }

    private static boolean anonymizeIP() {
        String string = PROP_HELPER.getProperty("anonymize.ip");
        if (Util.isEmpty(string)) {
            return false;
        }
        return "yes".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string);
    }

    static void reportUsage(Services services) {
        String string = "UNKNOWN";
        if (services == null) {
            log.warn("GA: Services was NULL!");
        } else {
            string = services.toString();
        }
        String string2 = "JABAWS/" + services.getJabawsVersion() + "/" + string;
        TRACKER.trackPageViewFromReferrer(string2, string, "http://www.compbio.dundee.ac.uk", SERVER_ADDRESS, VERSION_TYPE);
        TRACKER.resetSession();
    }

    static void reportUsage(Services services, String string) {
        String string2 = "UNKNOWN";
        if (services == null) {
            log.warn("GA: Services was NULL!");
        } else {
            string2 = services.toString();
        }
        String string3 = "JABAWS/" + services.getJabawsVersion() + "/" + string2;
        TRACKER.trackPageViewFromReferrer(string3, string2, "http://www.compbio.dundee.ac.uk", string, VERSION_TYPE);
        TRACKER.resetSession();
    }
}

