/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.server;

import compbio.engine.client.EngineUtil;
import compbio.engine.conf.PropertyHelperManager;
import compbio.engine.local.ExecutableWrapper;
import compbio.engine.local.LocalExecutorService;
import compbio.stat.collector.DirCleaner;
import compbio.stat.collector.StatDB;
import compbio.util.PropertyHelper;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class MainManager
implements ServletContextListener {
    private final Logger log = Logger.getLogger(MainManager.class);
    static PropertyHelper ph = PropertyHelperManager.getPropertyHelper();
    private ScheduledFuture<?> localcl;
    private ScheduledFuture<?> clustercl;
    private ScheduledExecutorService executor;

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            if (null != this.localcl) {
                this.localcl.cancel(true);
            }
            if (null != this.clustercl) {
                this.clustercl.cancel(true);
            }
            this.executor.shutdown();
            this.executor.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            this.log.warn(interruptedException.getMessage(), interruptedException);
        }
        this.log.info("JABAWS context is destroyed. Shutting down engines...");
        LocalExecutorService.shutDown();
        this.log.info("Local engine is shutdown OK");
        ExecutableWrapper.shutdownService();
        this.log.info("Individual executables stream engine is shutdown OK");
        StatDB.shutdownDBServer();
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        Object object;
        this.log.info("Initializing directory cleaners");
        this.executor = Executors.newScheduledThreadPool(2);
        String string = MainManager.getClusterJobDir();
        int n = PropertyHelperManager.getIntProperty(ph.getProperty("cluster.jobdir.maxlifespan"));
        int n2 = PropertyHelperManager.getIntProperty(ph.getProperty("cluster.jobdir.cleaning.frequency"));
        boolean bl = PropertyHelperManager.getBooleanProperty(ph.getProperty("cluster.stat.collector.enable"));
        if (0 < n && bl) {
            object = new DirCleaner(string, n);
            this.clustercl = this.executor.scheduleAtFixedRate((Runnable)object, 1L, n2, TimeUnit.MINUTES);
            this.log.info("Cleaning local job directory every " + n2 + " minutes");
        } else {
            this.log.info("Cluster job directory cleaner is disabled. ");
        }
        object = EngineUtil.convertToAbsolute(MainManager.getLocalJobDir());
        int n3 = PropertyHelperManager.getIntProperty(ph.getProperty("local.jobdir.maxlifespan"));
        int n4 = PropertyHelperManager.getIntProperty(ph.getProperty("local.jobdir.cleaning.frequency"));
        boolean bl2 = PropertyHelperManager.getBooleanProperty(ph.getProperty("local.stat.collector.enable"));
        if (0 < n3 && bl2) {
            DirCleaner dirCleaner = new DirCleaner((String)object, n3);
            this.localcl = this.executor.scheduleAtFixedRate(dirCleaner, 1L, n4, TimeUnit.MINUTES);
            this.log.info("Cleaning local job directory every " + n4 + " minutes");
        } else {
            this.log.info("Local job directory cleaner is disabled. ");
        }
    }

    static String getClusterJobDir() {
        String string = ph.getProperty("cluster.tmp.directory");
        if (null != string) {
            string = string.trim();
        }
        return string;
    }

    static String getLocalJobDir() {
        String string = ph.getProperty("local.tmp.directory");
        if (null != string) {
            string = string.trim();
        }
        return string;
    }
}

