/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.server;

import compbio.data.msa.MsaWS;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.Program;
import compbio.engine.AsyncExecutor;
import compbio.engine.Configurator;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import compbio.metadata.ChunkHolder;
import compbio.metadata.JobStatus;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Limit;
import compbio.metadata.LimitsManager;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.RunnerConfig;
import compbio.metadata.WrongParameterException;
import compbio.runner.RunnerUtil;
import compbio.runner.msa.Probcons;
import compbio.ws.server.WSUtil;
import java.io.File;
import java.util.List;
import javax.jws.WebService;
import org.apache.log4j.Logger;

@WebService(endpointInterface="compbio.data.msa.MsaWS", targetNamespace="http://msa.data.compbio/01/01/2010/", serviceName="ProbconsWS")
public class ProbconsWS
implements MsaWS<Probcons> {
    private static Logger log = Logger.getLogger(ProbconsWS.class);
    private static final RunnerConfig<Probcons> probconsOptions = RunnerUtil.getSupportedOptions(Probcons.class);
    private static final LimitsManager<Probcons> limitMan = EngineUtil.getLimits(new Probcons().getType());

    @Override
    public String align(List<FastaSequence> list) throws JobSubmissionException {
        WSUtil.validateFastaInput(list);
        ConfiguredExecutable<Probcons> configuredExecutable = this.init(list);
        return WSUtil.align(list, configuredExecutable, log, "align", this.getLimit(""));
    }

    ConfiguredExecutable<Probcons> init(List<FastaSequence> list) throws JobSubmissionException {
        Probcons probcons = new Probcons();
        probcons.setInput("input.txt");
        probcons.setOutput("result.txt");
        probcons.setError("error.txt");
        return Configurator.configureExecutable(probcons, list);
    }

    @Override
    public String customAlign(List<FastaSequence> list, List<Option<Probcons>> list2) throws JobSubmissionException, WrongParameterException {
        WSUtil.validateFastaInput(list);
        ConfiguredExecutable<Probcons> configuredExecutable = this.init(list);
        List<String> list3 = WSUtil.getCommands(list2, " ");
        log.info("Setting parameters:" + list3);
        configuredExecutable.addParameters(list3);
        return WSUtil.align(list, configuredExecutable, log, "customAlign", this.getLimit(""));
    }

    @Override
    public String presetAlign(List<FastaSequence> list, Preset<Probcons> preset) throws JobSubmissionException, WrongParameterException {
        WSUtil.validateFastaInput(list);
        if (preset == null) {
            throw new WrongParameterException("Preset must be provided!");
        }
        ConfiguredExecutable<Probcons> configuredExecutable = this.init(list);
        configuredExecutable.addParameters(preset.getOptions());
        Limit<Probcons> limit = this.getLimit(preset.getName());
        return WSUtil.align(list, configuredExecutable, log, "presetAlign", limit);
    }

    @Override
    public Alignment getResult(String string) throws ResultNotAvailableException {
        WSUtil.validateJobId(string);
        AsyncExecutor asyncExecutor = Configurator.getAsyncEngine(string);
        ConfiguredExecutable<?> configuredExecutable = asyncExecutor.getResults(string);
        Alignment alignment = (Alignment)configuredExecutable.getResults();
        return new Alignment(alignment.getSequences(), Program.Probcons, '-');
    }

    @Override
    public Limit<Probcons> getLimit(String string) {
        if (limitMan == null) {
            return null;
        }
        return limitMan.getLimitByName(string);
    }

    @Override
    public LimitsManager<Probcons> getLimits() {
        return limitMan;
    }

    @Override
    public ChunkHolder pullExecStatistics(String string, long l) {
        WSUtil.validateJobId(string);
        String string2 = Configurator.getWorkDirectory(string) + File.separator + new Probcons().getError();
        return WSUtil.pullFile(string2, l);
    }

    @Override
    public boolean cancelJob(String string) {
        WSUtil.validateJobId(string);
        return WSUtil.cancelJob(string);
    }

    @Override
    public JobStatus getJobStatus(String string) {
        WSUtil.validateJobId(string);
        return WSUtil.getJobStatus(string);
    }

    @Override
    public PresetManager<Probcons> getPresets() {
        return null;
    }

    @Override
    public RunnerConfig<Probcons> getRunnerOptions() {
        return probconsOptions;
    }
}

