/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.data.sequence.FastaSequence;
import compbio.util.SysPrefs;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Limit<T> {
    private String preset;
    private int seqNumber;
    private int seqLength;
    @XmlAttribute
    boolean isDefault;

    private Limit() {
    }

    public Limit(int n, int n2, String string) {
        if (n <= 0) {
            throw new IllegalArgumentException("seqNumber - a maximum number of sequences to align must be greater than 0. Value given:" + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("seqLength - an average sequence length must be greater than 0. Value given:" + n2);
        }
        this.seqNumber = n;
        this.seqLength = n2;
        this.preset = string;
        this.isDefault = false;
    }

    public Limit(int n, int n2, String string, boolean bl) {
        this(n, n, string);
        this.isDefault = bl;
    }

    public String getPreset() {
        return this.preset;
    }

    public int getAvgSeqLength() {
        return this.seqLength;
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.preset == null ? 0 : this.preset.hashCode());
        n = 31 * n + this.seqLength;
        n = 31 * n + this.seqNumber;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Limit limit = (Limit)object;
        if (this.preset == null ? limit.preset != null : !this.preset.equals(limit.preset)) {
            return false;
        }
        if (this.seqLength != limit.seqLength) {
            return false;
        }
        return this.seqNumber == limit.seqNumber;
    }

    public String toString() {
        String string = "";
        string = this.isDefault ? "Default Limits:" + SysPrefs.newlinechar : "Limits for Preset '" + this.preset + "'" + SysPrefs.newlinechar;
        string = string + "Maximum sequence number=" + this.seqNumber + SysPrefs.newlinechar;
        string = string + "Average sequence length=" + this.seqLength + SysPrefs.newlinechar;
        return string;
    }

    long numberOfLetters() {
        return this.seqNumber * this.seqLength;
    }

    public boolean isExceeded(List<FastaSequence> list) {
        if (list == null) {
            throw new NullPointerException("List of fasta sequences is expected!");
        }
        if (list.size() > this.seqNumber) {
            return true;
        }
        return this.seqLength != 0 && list.size() > 0 && (long)Limit.getAvgSequenceLength(list) * (long)list.size() > this.numberOfLetters();
    }

    public static int getAvgSequenceLength(List<FastaSequence> list) {
        long l = 0L;
        for (FastaSequence fastaSequence : list) {
            l += (long)fastaSequence.getLength();
        }
        return (int)(l / (long)list.size());
    }

    void validate() {
        if (this.seqNumber < 1) {
            throw new AssertionError((Object)("Maximum number of sequences must be defined and be positive! Set value is: " + this.seqNumber));
        }
        if (this.seqLength != 0 && this.seqLength < 1) {
            throw new AssertionError((Object)("Average sequence length must be positive! Set value is: " + this.seqLength));
        }
    }
}

