/*
 * Decompiled with CFR 0.152.
 */
package compbio.util;

import compbio.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(FileUtil.class);

    public static boolean isDirectoryEmpty(String dirpath) {
        assert (!Util.isEmpty(dirpath));
        return FileUtil.isDirectoryEmpty(new File(dirpath));
    }

    public static boolean exist(String file) {
        assert (!Util.isEmpty(file));
        return new File(file).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File sourceFile, File destinationFile) throws IOException {
        if (!destinationFile.exists()) {
            destinationFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destinationFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
            source.close();
            destination.close();
        }
        finally {
            if (destination != null && destination.isOpen()) {
                destination.close();
            }
            if (source != null && source.isOpen()) {
                source.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream source, File destination) throws IOException {
        BufferedInputStream bfinput = new BufferedInputStream(source);
        BufferedOutputStream destStream = null;
        try {
            destStream = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] buff = new byte[1024];
            int length = 0;
            while ((length = bfinput.read(buff)) > 0) {
                destStream.write(buff, 0, length);
            }
            destStream.close();
        }
        catch (Throwable throwable) {
            FileUtil.closeSilently(destStream);
            throw throwable;
        }
        FileUtil.closeSilently(destStream);
    }

    private static boolean isNotEmpty(String filepath, int minSizeExpectedInBytes) {
        assert (!Util.isEmpty(filepath));
        File file = new File(filepath);
        if (!file.exists()) {
            return false;
        }
        assert (file.isFile()) : "File expected! but directory is given!";
        assert (file.canRead()) : "Does not have permissions to read the file!";
        long bytelenght = file.length();
        return bytelenght > (long)minSizeExpectedInBytes;
    }

    public static boolean hasData(String filepath, int minSizeExpectedInBytes) {
        return FileUtil.isNotEmpty(filepath, minSizeExpectedInBytes);
    }

    public static boolean hasData(String filepath) {
        return FileUtil.isNotEmpty(filepath, 0);
    }

    public static boolean isDirectoryEmpty(File directory) {
        assert (directory != null);
        assert (directory.canRead()) : "Cannot read!";
        assert (directory.isDirectory()) : "Directory expected, but file is given!";
        return directory.listFiles().length == 0;
    }

    public static File[] getAllFiles(String directory) {
        File ff = new File(directory);
        return ff.listFiles();
    }

    public static File[] getFiles(String directory, FileFilter fileFilter) {
        File ff = new File(directory);
        return ff.listFiles(fileFilter);
    }

    public static String getFileExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".")).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTempFile(int sizeinKBytes) throws IOException {
        int i;
        assert (sizeinKBytes > 0) : "Size must be positive integer but the value received is: " + sizeinKBytes;
        assert (sizeinKBytes < 1000000) : "Size must be less than 1 Gb!";
        File file = File.createTempFile("" + System.currentTimeMillis(), ".bin");
        FileOutputStream out = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        for (i = 0; i < buf.length; ++i) {
            buf[i] = (byte)i;
        }
        for (i = 0; i < sizeinKBytes; ++i) {
            ((OutputStream)out).write(buf);
        }
        try {
            ((OutputStream)out).close();
        }
        finally {
            FileUtil.closeSilently(log, (Closeable)out);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file) throws IOException {
        int length;
        FileInputStream inStream = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(inStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        while (0 < (length = bis.read(buffer))) {
            out.write(buffer, 0, length);
        }
        byte[] result = out.toByteArray();
        try {
            out.close();
            bis.close();
            inStream.close();
        }
        finally {
            FileUtil.closeSilently(log, (Closeable)out);
            FileUtil.closeSilently(log, (Closeable)bis);
            FileUtil.closeSilently(log, (Closeable)inStream);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(InputStream inStream) throws IOException {
        byte[] bytes = new byte[inStream.available()];
        inStream.read(bytes);
        ByteArrayOutputStream contentStr = new ByteArrayOutputStream();
        contentStr.write(bytes);
        String content = contentStr.toString();
        try {
            contentStr.close();
        }
        finally {
            FileUtil.closeSilently(log, (Closeable)contentStr);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file) throws IOException {
        String fileStr = "";
        String line = null;
        if (file.exists()) {
            FileReader reader = new FileReader(file);
            BufferedReader br = new BufferedReader(reader);
            while ((line = br.readLine()) != null) {
                fileStr = fileStr + line + "\n";
            }
            try {
                br.close();
                reader.close();
            }
            finally {
                FileUtil.closeSilently(log, (Closeable)br);
                FileUtil.closeSilently(log, (Closeable)reader);
            }
        }
        return fileStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String data, String filePathandName) throws IOException {
        FileWriter fwriter = null;
        BufferedWriter bw = null;
        try {
            fwriter = new FileWriter(filePathandName);
            bw = new BufferedWriter(fwriter);
            bw.write(data);
            bw.close();
            fwriter.close();
        }
        catch (Throwable throwable) {
            FileUtil.closeSilently(log, bw);
            FileUtil.closeSilently(log, (Closeable)fwriter);
            throw throwable;
        }
        FileUtil.closeSilently(log, (Closeable)bw);
        FileUtil.closeSilently(log, (Closeable)fwriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(byte[] data, String filePathandName, boolean append) throws IOException {
        FileOutputStream outStream = null;
        BufferedOutputStream bw = null;
        try {
            outStream = new FileOutputStream(filePathandName, append);
            bw = new BufferedOutputStream(outStream);
            bw.write(data);
            bw.close();
            outStream.close();
        }
        catch (Throwable throwable) {
            FileUtil.closeSilently(log, bw);
            FileUtil.closeSilently(log, (Closeable)outStream);
            throw throwable;
        }
        FileUtil.closeSilently(log, (Closeable)bw);
        FileUtil.closeSilently(log, (Closeable)outStream);
    }

    public static void appendToFile(byte[] data, String filePathandName) throws IOException {
        FileUtil.writeToFile(data, filePathandName, true);
    }

    public static void writeToFile(byte[] data, String filePathandName) throws IOException {
        FileUtil.writeToFile(data, filePathandName, false);
    }

    public static List<String> getFileNameList(String path) {
        return FileUtil.getFileNameList(path, null);
    }

    public static List<String> getFileNameList(String path, FilenameFilter filter) {
        assert (!Util.isEmpty(path));
        assert (new File(path).isDirectory());
        if (filter == null) {
            return Arrays.asList(new File(path).list());
        }
        return Arrays.asList(new File(path).list(filter));
    }

    public static final void closeSilently(org.apache.log4j.Logger log, Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                log.error((Object)e.getLocalizedMessage(), e.getCause());
            }
        }
    }

    public static final void closeSilently(Logger log, Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                log.severe(e.getLocalizedMessage() + " Cause: " + e.getCause());
            }
        }
    }

    public static final void closeSilently(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                log.error((Object)e.getLocalizedMessage(), e.getCause());
            }
        }
    }

    public static class ExtensionFilter
    implements FilenameFilter {
        String extension = "";

        public ExtensionFilter(String extension) {
            this.extension = extension;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(this.extension);
        }
    }
}

