/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.SequenceUtil;
import compbio.util.SysPrefs;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class FastaSequence {
    private String id;
    private String sequence;

    FastaSequence() {
    }

    public FastaSequence(String string, String string2) {
        this.id = string;
        this.sequence = SequenceUtil.cleanSequence(string2);
    }

    public String getId() {
        return this.id;
    }

    public String getSequence() {
        return this.sequence;
    }

    public static int countMatchesInSequence(String string, String string2) {
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        while (matcher.find()) {
            ++n;
        }
        return n;
    }

    public String getFormattedFasta() {
        return this.getFormatedSequence(80);
    }

    public String getOnelineFasta() {
        String string = ">" + this.getId() + SysPrefs.newlinechar;
        string = string + this.getSequence() + SysPrefs.newlinechar;
        return string;
    }

    public String getFormatedSequence(int n) {
        if (this.sequence == null) {
            return "";
        }
        assert (n >= 0) : "Wrong width parameter ";
        StringBuilder stringBuilder = new StringBuilder(this.sequence);
        int n2 = this.sequence.length() % n;
        int n3 = (this.sequence.length() - n2) / n;
        int n4 = 0;
        int n5 = 0;
        for (int i = 1; i <= n3; ++i) {
            n5 = n * i + n4;
            if (stringBuilder.length() <= n5) break;
            stringBuilder.insert(n5, "\n");
            ++n4;
        }
        return stringBuilder.toString();
    }

    public int getLength() {
        return this.sequence.length();
    }

    public String toString() {
        return this.getOnelineFasta();
    }

    public int hashCode() {
        int n = 1;
        n = 17 * n + (this.id == null ? 0 : this.id.hashCode());
        n = 17 * n + (this.sequence == null ? 0 : this.sequence.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof FastaSequence)) {
            return false;
        }
        FastaSequence fastaSequence = (FastaSequence)object;
        if (!fastaSequence.getId().equals(this.getId())) {
            return false;
        }
        return fastaSequence.getSequence().equalsIgnoreCase(this.getSequence());
    }
}

