#! /usr/bin/perl -w
# Copyright (2006) Ian M. Overton, Geoffrey J. Barton and the University of Dundee


use strict;
use OB;
use Getopt::Std;

my $opt = OB->new;
getopts ('i:o:m:p:hn', $opt);
my $vars = OB->new;
$vars->ob_vars($opt);
if ($vars->{nomw}) {
	my  $pi = OB->new;
	my  $wt = OB->new;
	$pi->calc_pI($vars);
	my  $gravy = OB->new;
	my  $len = OB->new;
	$gravy->calc_gravy_len($len, $vars);
	my  $ob = OB->new;
	my ($scor_href, $xl, $xh, $yl, $yh, $xv_aref, $yv_aref) = $vars->read_zmat ();
	my ($irregX, $xint) = $xv_aref->assess_interval ();
	my ($irregY, $yint) = $yv_aref->assess_interval ();
	die "need to implement alternative lookup method\n" if (($$irregX) or ($$irregY)); # current lookup only works for table with regular values of X and Y
	my ($xu_re, $yu_re, $xl_re, $yl_re) = $pi->assign_matrixBound($gravy, $xint, $yint);
	$scor_href->OB_out_nomwt($xu_re, $yu_re, $xl_re, $yl_re, $vars, $len, $pi, $gravy);


} else {

	my  $pi = OB->new;
	my  $wt = OB->new;
	$pi->calc_pI_mwt($wt, $vars);
	my  $gravy = OB->new;
	my  $len = OB->new;
	$gravy->calc_gravy_len($len, $vars);
	my  $ob = OB->new;
	my ($scor_href, $xl, $xh, $yl, $yh, $xv_aref, $yv_aref) = $vars->read_zmat ();
	my ($irregX, $xint) = $xv_aref->assess_interval ();
	my ($irregY, $yint) = $yv_aref->assess_interval ();
	die "need to implement alternative lookup method\n" if (($$irregX) or ($$irregY)); # current lookup only works for table with regular values of X and Y

	my ($xu_re, $yu_re, $xl_re, $yl_re) = $pi->assign_matrixBound($gravy, $xint, $yint);
	$scor_href->OB_out($xu_re, $yu_re, $xl_re, $yl_re, $vars, $len, $wt, $pi, $gravy);
}
