/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.AlignmentMetadata;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.Program;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public final class Alignment {
    private AlignmentMetadata metadata;
    private List<FastaSequence> sequences;

    private Alignment() {
    }

    public Alignment(List<FastaSequence> list, Program program, char c) {
        this.sequences = list;
        this.metadata = new AlignmentMetadata(Program.CLUSTAL, c);
    }

    public Alignment(List<FastaSequence> list, AlignmentMetadata alignmentMetadata) {
        this.sequences = list;
        this.metadata = alignmentMetadata;
    }

    public List<FastaSequence> getSequences() {
        return this.sequences;
    }

    public int getSize() {
        return this.sequences.size();
    }

    public AlignmentMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        String string = "";
        for (FastaSequence fastaSequence : this.getSequences()) {
            string = string + fastaSequence.toString() + "\n";
        }
        return string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.metadata == null ? 0 : this.metadata.hashCode());
        n = 31 * n + (this.sequences == null ? 0 : ((Object)this.sequences).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Alignment)) {
            return false;
        }
        Alignment alignment = (Alignment)object;
        if (this.getSize() != alignment.getSize()) {
            return false;
        }
        if (!this.getMetadata().equals(alignment.getMetadata())) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        for (FastaSequence fastaSequence : this.getSequences()) {
            ++n;
            for (FastaSequence fastaSequence2 : alignment.getSequences()) {
                if (!fastaSequence.equals(fastaSequence2)) continue;
                ++n2;
            }
            if (n == n2) continue;
            return false;
        }
        return true;
    }
}

