/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.Alignment;
import compbio.data.sequence.AlignmentMetadata;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.Program;
import compbio.data.sequence.SequenceUtil;
import compbio.data.sequence.UnknownFileFormatException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public final class ClustalAlignmentUtil {
    private static final Logger log = Logger.getLogger(ClustalAlignmentUtil.class.getCanonicalName());
    public static final char gapchar = '-';
    private static final String spacer = "      ";
    private static final int maxNameLength = 30;
    private static final int minNameHolderLength = 10;
    private static final int oneLineAlignmentLength = 60;

    public static Alignment readClustalFile(InputStream inputStream) throws IOException, UnknownFileFormatException {
        Object object;
        String string;
        boolean bl = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashMap<Object, StringBuffer> hashMap = new HashMap<Object, StringBuffer>();
        FastaSequence[] fastaSequenceArray = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            StringBuffer stringBuffer;
            if (string.indexOf(" ") == 0) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            object = "";
            if (!stringTokenizer.hasMoreTokens()) continue;
            object = stringTokenizer.nextToken();
            if (((String)object).equals("CLUSTAL") || ((String)object).equals("PROBCONS")) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            if (hashMap.containsKey(object)) {
                stringBuffer = (StringBuffer)hashMap.get(object);
            } else {
                stringBuffer = new StringBuffer();
                hashMap.put(object, stringBuffer);
            }
            if (!arrayList.contains(object)) {
                arrayList.add(object);
            }
            stringBuffer.append(stringTokenizer.nextToken());
        }
        bufferedReader.close();
        if (bl) {
            fastaSequenceArray = new FastaSequence[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                if (hashMap.get(arrayList.get(i)) == null) {
                    throw new AssertionError((Object)("Bizarreness! Can't find sequence for " + (String)arrayList.get(i)));
                }
                fastaSequenceArray[i] = object = new FastaSequence((String)arrayList.get(i), ((StringBuffer)hashMap.get(arrayList.get(i))).toString());
            }
        }
        if (fastaSequenceArray == null || fastaSequenceArray.length == 0) {
            throw new UnknownFileFormatException("Input does not appear to be a clustal file! ");
        }
        return new Alignment(Arrays.asList(fastaSequenceArray), new AlignmentMetadata(Program.CLUSTAL, '-'));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidClustalFile(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("Input is expected!");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            if (inputStream.available() < 10) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i < 10; ++i) {
                String string = bufferedReader.readLine();
                if (string == null || !(string = string.toUpperCase().trim()).contains("CLUSTAL") && !string.contains("PROBCONS")) continue;
                boolean bl = true;
                return bl;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            log.severe("Could not read from the stream! " + iOException.getLocalizedMessage() + iOException.getCause());
        }
        finally {
            SequenceUtil.closeSilently(log, bufferedReader);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeClustalAlignment(OutputStream outputStream, Alignment alignment) throws IOException {
        List<FastaSequence> list = alignment.getSequences();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        printWriter.write("CLUSTAL\n\n\n");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (FastaSequence fastaSequence : list) {
            String string = fastaSequence.getId();
            if (fastaSequence.getSequence().length() > n) {
                n = fastaSequence.getSequence().length();
            }
            if (string.length() > n2) {
                n2 = string.length();
            }
            ++n3;
        }
        if (n2 < 10) {
            n2 = 10;
        }
        if (n2 > 30) {
            n2 = 30;
        }
        int n4 = 60;
        int n5 = n / n4 + 1;
        for (n3 = 0; n3 < n5; ++n3) {
            int n6 = 0;
            for (FastaSequence fastaSequence : list) {
                String string = fastaSequence.getId();
                printWriter.format("%-" + n2 + "s" + spacer, string.length() > 30 ? string.substring(0, n2) : string);
                int n7 = n3 * n4;
                int n8 = n7 + n4;
                if (n8 < fastaSequence.getSequence().length() && n7 < fastaSequence.getSequence().length()) {
                    printWriter.write(fastaSequence.getSequence().substring(n7, n8) + "\n");
                } else if (n7 < fastaSequence.getSequence().length()) {
                    printWriter.write(fastaSequence.getSequence().substring(n7) + "\n");
                }
                ++n6;
            }
            printWriter.write("\n");
        }
        try {
            printWriter.close();
        }
        finally {
            SequenceUtil.closeSilently(log, printWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Alignment readClustalFile(File file) throws UnknownFileFormatException, IOException {
        if (file == null) {
            throw new NullPointerException("File is expected!");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        Alignment alignment = ClustalAlignmentUtil.readClustalFile(fileInputStream);
        try {
            fileInputStream.close();
        }
        finally {
            SequenceUtil.closeSilently(log, fileInputStream);
        }
        return alignment;
    }
}

